/**
 * LPCXPresso1769のADCクラスを定義します。
 class Adc
 ADCペリフェラルを操作するクラス
 class AdcPin
 ADCピンを操作するクラス
 */
(function(){
var DEV=LPCXpresso1769;
var BCF=DEV._BCF;
var EE=DEV._EE;
var isUndef=MiMicLib.isUndef;



/**
 * このクラスは、ADCペリフェラルを管理します。
 @param i_opt
 オプション値です。省略時は、{phy:{power:1}}を指定します。
 {phy:{ペリフェラルオプション}}
 */
DEV.Adc=function Adc(i_mcu,i_opt)
{
	try{
		this._mcu=i_mcu;
		var phyopt=isUndef(i_opt)?{power:1}:i_opt.phy;
		//PHY生成。
		this._phy=new DEV.Peripheral(i_mcu,DEV.PHY.ADC);
		//初期化。
		var bc="";
		var db=new Array();
		if(isUndef(i_opt)){
			//パワーONのみ
			bc+=this._phy.BCF_setOpt({power:1},db);
		}else{
			bc+=this._phy.BCF_setOpt(i_opt.phy,db);
		}
		//0x00210000(PDN,BURSTを1)
		bc+=BCF.setMem(this._AD0CR,0x00200500,db);
		bc+=BCF.setMem(this._AD0CR,0x00210500,db);
		//
		this._mcu.callMiMicWithCheck(bc+BCF.END,db);
		//ペリフェラルをMCUに登録
		this._mcu.registerPhy(this,"ADC");
	}catch(e){
		throw new MiMicException(e);
	}

}
DEV.Adc.prototype=
{
	_AD0CR:0x40034000,
	_AD0DR:[0x40034010,0x40034014,0x40034018,0x4003401C,0x40034020,0x40034024,0x40034028,0x4003402C],
	_phy:null,
	_mcu:null,
	/**
	 * AD0CRのSELフィールドの値を更新するBC
	 */
	BCF_setSel:function BCF_setSel(i_bit,i_val,i_db)
	{
		try{
			return BCF.setBit(this._AD0CR,0x00000001,i_val,i_bit,i_db);
		}catch(e){
			throw new MiMicException(e);
		}
	},
	/**
	 * n番のAD0DRの値を得るBC
	 */
	BCF_getAD0DR:function BCF_getAD0DR(i_ch,i_db)
	{
		try{
			return BCF.getMem(this._AD0DR[i_ch],i_db);
		}catch(e){
			throw new MiMicException(e);
		}
	},
	/**
	 * see
	 */
	getPin:function getPin(i_pin,i_opt)
	{
		try{
			return new DEV.AdcPin(this,i_pin,i_opt);
		}catch(e){
			throw new MiMicException(e);
		}
	}	
}

/**
 * このクラスは、ADCペリフェラルとPin識別子から、ADCピンを構成します。
 @param i_adc
 ADCペリフェラル
 @param i_pin
 ADCを構成するピン番号
 @param i_opt
 ピンオプション。省略してください。
 */
DEV.AdcPin=function AdcPin(i_adc,i_pin,i_opt)
{
	try{
		this._adc=i_adc;
		//PINがAD持ってるか確認
		this._pin=new DEV.Pin(i_adc._mcu,i_pin);
		//PinNameからピン情報を得る。
		this._adinfo=function(i_pin){
			//pinの完全な機能名を得る。(得られれば機能がある。)
			var func_name=DEV.completePinFunctionName(i_pin,"AD");
			//portとbitを得る(AD0だけしか管理しないよ)
			var a=func_name.substring(2).split(".");
			var r={port:0,ch:parseInt(a[1]),pin_sel:DEV.getPinSelByFunctionName(i_pin,func_name)};
			if(!isNaN(r.ch)){
				return r;
			}
			throw new MiMicException(EE.INVALID_CFG,"The pin has not AD fuction.");
		}(i_pin);
		//設定用のBCを作って実行
		{
			var bc="";
			var db=new Array();
			bc+=this._pin.BCF_setOpt({sel:this._adinfo.pin_sel},db);
			//AD0CRに値設定
			bc+=this._adc.BCF_setSel(this._adinfo.ch,1,db);
			var ret=this._adc._mcu.callMiMicWithCheck(bc+BCF.END,db);
		}
	}catch(e){
		throw new MiMicException(e);
	}
}

DEV.AdcPin.prototype=
{
	_adc:null,
	_pin:null,
	_adinfo:null,
	/**
	 * ピンからAD変換した値を得る。
	 @return
	 12bitのAD変換値
	 */
	getValue:function getValue()
	{
		try{
			//メモリから値取得
			var db=new Array();
			var bc=this._adc.BCF_getAD0DR(this._adinfo.ch,db);
			var ret=this._adc._mcu.callMiMicWithCheck(bc+BCF.END,db);
			return (ret.stream[0]>>4)&0x00000fff;
		}catch(e){
			throw new MiMicException(e);
		}

	}	
}
	


}());
