/*********************************************************************************
 * PROJECT: MiMic
 * --------------------------------------------------------------------------------
 *
 * This file is part of MiMic
 * Copyright (C)2011 Ryo Iizuka
 *
 * MiMic is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by　the Free Software Foundation, either version 3 of the　License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * For further information please contact.
 *	http://nyatla.jp/
 *	<airmail(at)ebony.plala.or.jp> or <nyatla(at)nyatla.jp>
 *
 *
 * Parts of this file were leveraged from uIP:
 *
 * Copyright (c) 2001-2003, Adam Dunkels.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior
 *    written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#define ICMP6_ECHO_REPLY             129
#define ICMP6_ECHO                   128
#define ICMP6_NEIGHBOR_SOLICITATION  135
#define ICMP6_NEIGHBOR_ADVERTISEMENT 136

#define ICMP6_FLAG_S (1 << 6)

#define ICMP6_OPTION_SOURCE_LINK_ADDRESS 1
#define ICMP6_OPTION_TARGET_LINK_ADDRESS 2

void uip_process_ICMP6(
	const void* in_packet)
{
#if UIP_CONF_IPV6

	/* This is IPv6 ICMPv6 processing code. */
	DEBUG_PRINTF("icmp6_input: length %d\n", uip_len);


	UIP_STAT(++uip_stat.icmp.recv);

	/* If we get a neighbor solicitation for our address we should send
	 a neighbor advertisement message back. */
	if(ICMPBUF->type == ICMP6_NEIGHBOR_SOLICITATION) {
		if(uip_ipaddr_cmp(ICMPBUF->icmp6data, uip_hostaddr)) {

			if(ICMPBUF->options[0] == ICMP6_OPTION_SOURCE_LINK_ADDRESS) {
				/* Save the sender's address in our neighbor list. */
				uip_neighbor_add(ICMPBUF->srcipaddr, &(ICMPBUF->options[2]));
			}

			/* We should now send a neighbor advertisement back to where the
			 neighbor solicication came from. */
			ICMPBUF->type = ICMP6_NEIGHBOR_ADVERTISEMENT;
			ICMPBUF->flags = ICMP6_FLAG_S; /* Solicited flag. */

			ICMPBUF->reserved1 = ICMPBUF->reserved2 = ICMPBUF->reserved3 = 0;

			uip_ipaddr_copy(ICMPBUF->destipaddr, ICMPBUF->srcipaddr);
			uip_ipaddr_copy(ICMPBUF->srcipaddr, uip_hostaddr);
			ICMPBUF->options[0] = ICMP6_OPTION_TARGET_LINK_ADDRESS;
			ICMPBUF->options[1] = 1; /* Options length, 1 = 8 bytes. */
			memcpy(&(ICMPBUF->options[2]), &uip_ethaddr, sizeof(uip_ethaddr));
			ICMPBUF->icmpchksum = 0;
			ICMPBUF->icmpchksum = ~uip_icmp6chksum();
			goto send;

		}
		uip_func_drop();
		return;

	} else if(ICMPBUF->type == ICMP6_ECHO) {
		/* ICMP echo (i.e., ping) processing. This is simple, we only
		 change the ICMP type from ECHO to ECHO_REPLY and update the
		 ICMP checksum before we return the packet. */

		ICMPBUF->type = ICMP6_ECHO_REPLY;

		uip_ipaddr_copy(BUF->destipaddr, BUF->srcipaddr);
		uip_ipaddr_copy(BUF->srcipaddr, uip_hostaddr);
		ICMPBUF->icmpchksum = 0;
		ICMPBUF->icmpchksum = ~uip_icmp6chksum();

		UIP_STAT(++uip_stat.icmp.sent);
		goto send;
	} else {
		DEBUG_PRINTF("Unknown icmp6 message type %d\n", ICMPBUF->type);
		UIP_STAT(++uip_stat.icmp.drop);
		UIP_STAT(++uip_stat.icmp.typeerr);
		UIP_LOG("icmp: unknown ICMP message.");
		uip_func_drop();
		return;

	}
#endif
}






void uip_icmp6_v6(void)
{
//	if (uip_ipaddr_cmp(uip_hostaddr, all_zeroes_addr)) {
		/* If we are configured to use ping IP address configuration and
		 hasn't been assigned an IP address yet, we accept all ICMP
		 packets. */


//	} else {
		/* For IPv6, packet reception is a little trickier as we need to
		 make sure that we listen to certain multicast addresses (all
		 hosts multicast address, and the solicited-node multicast
		 address) as well. However, we will cheat here and accept all
		 multicast packets that are sent to the ff02::/16 addresses. */
/*		if(!uip_ipaddr_cmp(BUF->destipaddr, uip_hostaddr) &&
				BUF->destipaddr[0] != NyLPC_HTONS(0xff02)) {
			UIP_STAT(++uip_stat.header.drop);
			goto drop;
		}
*///	}
}
