/*
 * cConfiglationStorage.h
 *
 *  Created on: 2011/10/18
 *      Author: nyatla
 */

#ifndef CCONFIGLATIONSTORAGE_H_
#define CCONFIGLATIONSTORAGE_H_
/**
 * IPアドレスはネットワークオーダーで格納する。
 */
struct TMimicConfigulation{
	/**
	 * ROM焼検出用。0xFFFFFFFFを書く
	 */
	NyLPC_TUInt32	fast_boot;
	NyLPC_TUInt32	mac_00_01_02_03;
	NyLPC_TUInt32	mac_04_05_xx_xx;
	NyLPC_TUInt32	ipv4_addr_net;
	NyLPC_TUInt32	ipv4_mask_net;
	NyLPC_TUInt32	ipv4_drut_net;
	NyLPC_TUInt32	ipv4_port;
	NyLPC_TUInt32	accessmode;

};

/**
 * ユーザコンフィギュレーションを更新する。
 * この関数は、RTOSが停止中に実行すること。
 */
NyLPC_TBool cConfiglationStorage_updateConfigulation(const struct TMimicConfigulation* i_congfiglation);
/**
 * コンフィギュレーション値を返す。
 * この関数は、RTOSが停止中に実行すること。
 */
const struct TMimicConfigulation* cConfiglationStorage_loadMiMicConfigulation(void);


#endif /* CCONFIGLATIONSTORAGE_H_ */
