/*********************************************************************************
 * PROJECT: MiMic
 * --------------------------------------------------------------------------------
 *
 * This file is part of MiMic
 * Copyright (C)2011 Ryo Iizuka
 *
 * MiMic is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by　the Free Software Foundation, either version 3 of the　License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * For further information please contact.
 *	http://nyatla.jp/
 *	<airmail(at)ebony.plala.or.jp> or <nyatla(at)nyatla.jp>
 *
 *********************************************************************************/
#ifndef NYLPC_cMiMicReqestParser_H_
#define NYLPC_cMiMicReqestParser_H_
#include "sketch_config.h"	//include this file at first!
#include "NyLPC_httpService.h"
#include "NyLPC_mimicVm.h"

/**
 * RemoteMcuシステムのURLをパースします。
 * このクラスは、RemoteMCUApplicationのCGIを定義します。
 * <p>
 * MiMicServerのURL一覧
 * <ol>
 * <li>
 * 		/?mvm.api?v=[:version:]&bc=[:MiMicBC:]
 * 		[:version:]="1"
 * 		MiMicBCを実行する。
 * </li>
 * <li>
 * 		/setup.api?c=[update|get]p=[:param:]
 * 		cコマンドが無い場合、プレースホルダとなるhtmlを返却する。
 * 		c="get"なら、json形式の設定データを返却する。
 * 		c=updateなら、pパラメタの内容でFlashをアップデートする。
 * 		[:param:]=[:emac:][:hostaddr:][:subnetmask:][:defaultroot:][:port:]
 * 		ROMパラメータ。固定長のHEX文字列である。
 * 		[:emac:]=[[:HEX32:]{2}}
 * 		ビックエンディアン48bit値+パディング16bit
 * 		[:hostaddr:]=[:HEX32:]
 * 		IPアドレス。32bit値。ビックエンディアン
 * 		[:subnetmask:]=[:HEX32:]
 * 		サブネットマスク。32bit値。ビックエンディアン
 * 		[:defaultroot:]=[:HEX32:]
 * 		defaultrootアドレス。32bit値。ビックエンディアン
 * 		[:port:]=[:HEX32:]
 * 		ポート番号。2桁のHEX値である。ビックエンディアン。値16bit、パディング16bit
 * </li>
 * <li>
 * 		/status.api
 * 		サーバステータスを返す。
 * </li>
 * </ol>
 * </p>
 * このクラスは、NyLPC_TBasicHttpHeader_tにキャストできます。
 */
typedef struct TcRemoteMcuRequestParser TcRemoteMcuRequestParser_t;




/**
 * コンテンツID定義(コンテンツ名に対応)
 */
typedef NyLPC_TUInt8 TRemoteMcuRequest_CONTENT_ID;
#define TRemoteMcuRequest_CONTENT_ID_MIMICBC 1
#define TRemoteMcuRequest_CONTENT_ID_SETUP   2
#define TRemoteMcuRequest_CONTENT_ID_INDEX   3
#define TRemoteMcuRequest_CONTENT_ID_STATUS  4
#define TRemoteMcuRequest_CONTENT_ID_CSS     5
#define TRemoteMcuRequest_CONTENT_ID_LOGO    6
#define TRemoteMcuRequest_CONTENT_ID_UNKNOWN 0

/**
 * URLパラメータ名IDの定義
 */
typedef NyLPC_TUInt8 TRemoteMcuRequest_QNAME_ID;
#define TRemoteMcuRequest_QNAME_ID_V	1
#define TRemoteMcuRequest_QNAME_ID_O	2
#define TRemoteMcuRequest_QNAME_ID_BC	3
#define TRemoteMcuRequest_QNAME_ID_P	4
#define TRemoteMcuRequest_QNAME_ID_C	5


/**
 * MiMicVMのインストラクションバッファポインタ。
 * TRemoteMcuRequest_SIZE_OF_IBUF_CONFIGが宣言されているときは、それを使います。
 */
#ifdef TRemoteMcuRequest_SIZE_OF_IBUF_CONFIG
	#define TRemoteMcuRequest_SIZE_OF_IBUF TRemoteMcuRequest_SIZE_OF_IBUF_CONFIG
#else
	#define TRemoteMcuRequest_SIZE_OF_IBUF 64
#endif

#define TRemoteMcuRequest_SIZE_OF_SETUP_PARAM 16

/**
 * TRemoteMcuRequest.content.mvm.vの値
 */
#define TRemoteMcuRequest_QVAL_VERSION_UNKNOWN	0
#define TRemoteMcuRequest_QVAL_VERSION_1       	1
/**
 * TRemoteMcuRequest.content.mvm.oの値
 */
#define TRemoteMcuRequest_QVAL_O_JSON 0	//default
#define TRemoteMcuRequest_QVAL_O_XML  1

#define TRemoteMcuRequest_QVAL_C_UNKNOWN 0	//default
#define TRemoteMcuRequest_QVAL_C_GET 1
#define TRemoteMcuRequest_QVAL_C_UPDATE 2

/**
 *
 */
struct TRemoteMcuRequest
{
	struct NyLPC_THttpBasicHeader super;
	TRemoteMcuRequest_CONTENT_ID _content_id;
	union{
		struct{
			NyLPC_TUInt8 v;//バージョン
			NyLPC_TUInt8 o;//outputスタイル
			/**
			 * il_bufはbcとdbの2パートのデータを格納します。
			 * 先頭からbc_lenの長さのBCパートと、db_partからdb_lenの長さのデータです。
			 */
			struct{
				/** MiMicVMインストラクションの蓄積用。前半にTXT,後半にDBを格納する。 */
				NyLPC_TUInt32 bc_buf[TRemoteMcuRequest_SIZE_OF_IBUF];
				/** MiMicVM入力ストリーム(MimicDB)の開始位置(bufの一部を指す) */
				const NyLPC_TUInt32* db_part;
				/** MiMicTXTのワード長(1ワード32bit)*/
				NyLPC_TUInt16 txt_len;
				/** MiMicDBのワード長(1ワード32bit)*/
				NyLPC_TUInt16 db_len;
			}vm_instruction;
		}mvm;
		struct{
			/**pパラメータ。最大長さは16。長さ6であること。
			 * [0]:MACAddrの、[0][1][2][3]
			 * [1]:MACAddrの、[4][5][X][X]
			 * [2]:IPAddr(Networkorder)
			 * [3]:Subnetmask(Networkorder)
			 * [4]:Defaultgateway
			 * [5]:[port(Networkorder16bit)][X][X]
			 */
			NyLPC_TUInt32 param_buf[TRemoteMcuRequest_SIZE_OF_SETUP_PARAM];
			NyLPC_TUInt16 param_len;
			NyLPC_TUInt32 cval;//コマンド値
		}setup;
		struct{
			/**
			 * 不明な名前の場合は、ここに名前をコピー
			 */
			NyLPC_TChar path[32];
		}unknown;
	}content;
};



/**
 * パーサのステータス
 */
typedef NyLPC_TUInt8 TcRemoteMcuRequestParser_ST;




struct TcRemoteMcuRequestParser{
	NyLPC_TcHttpBasicHeaderParser_t super;
	TcRemoteMcuRequestParser_ST _astate;//解析ステータス
	TRemoteMcuRequest_QNAME_ID _content_qery_name_id;
	NyLPC_TcStr_t _tstr;
	NyLPC_TChar _tstr_buf[16];
	NyLPC_TcMiMicTxtCompiler_t _txtcmp;
	NyLPC_TcMiMicDbCompiler_t _dbcmp;
	struct NyLPC_TUInt32ArrayPtr bin_ptr;

};

void cRemoteMcuRequestParser_initialize(TcRemoteMcuRequestParser_t* i_inst);
void cRemoteMcuRequestParser_finalize(TcRemoteMcuRequestParser_t* i_inst);


/**
 * @return
 * HTTPレスポンスコード。200で成功。
 */
NyLPC_TUInt16 cRemoteMcuRequestParser_parse(TcRemoteMcuRequestParser_t* i_inst,NyLPC_TcHttpStream_t* i_stream,struct TRemoteMcuRequest* o_out);


#endif /* NYLPC_CHTTPSHORTHTTPHEADERPARSER_H_ */
