/*
 * naitive_interface.h
 *
 * このファイルは、ネイティブファンクションのテーブルを定義します。
 * ネイティブファンクションコールは、TNativeFunctionItem_t
 */

#ifndef NAITIVE_INTERFACE_H_
#define NAITIVE_INTERFACE_H_
#include "NyLPC_mimicVm.h"

typedef NyLPC_TBool (*NyLPC_TNativeFunction)(NyLPC_TcMiMicVM_t* i_vm);

struct TNativeFunctionItem
{
	/**
	 * 関数id。関数のidを定義する。関数idはビットフィールドを持つ。フォーマットは以下の通り。
	 * <table>
	 * <tr><td>bit field</td><td>bit field</td></tr>
	 * <tr><td>31-24</td><td>Addr type</td></tr>
	 * <tr><td>23-0</td><td>Number</td></tr>
	 * </table>
	 * AddrType
	 * <ul>
	 * <li>0x00: LocalIDモード。23-0に、ユーザ定義IDが含まれていることを示す。他のシステムと重複の可能性があるので注意すること。</li>
	 * <li>0x01: MAC-OUIモード。23-0に、MACAddrのOUI値が含まれていることを示す。OUI所有事業者が、ベンダ固有の関数を定義する場合に使用する。</li>
	 * <li>0x02: MiMicDomainモード。23-0に、MiMic projectがユーザに割り当てたIDが格納されていることを示す。</li>
	 * <li>0x39: MiMic予約値。</li>
	 * <li>other: reserved</li>
	 * </ul>
	 */
	NyLPC_TUInt32 id;
	/**
	 * 関数の名前。Javaパッケージ風に定義すると良い。重複可。
	 * @example "jp.nyatla.sample"
	 */
	const char* name;
	/**
	 * 関数ポインタ。
	 */
	NyLPC_TNativeFunction function;
};
typedef struct TNativeFunctionItem TNativeFunctionItem_t;

/**
 * ネイティブ関数テーブルから、idに一致する関数を検索する。
 */
NyLPC_TNativeFunction getNativeFunctionById(NyLPC_TUInt32 i_id);


#endif /* NAITIVE_INTERFACE_H_ */
