<?php
/**
 * @fileOverview 低レベルAPIを定義する。低レベルAPIは、MiMicRemoteMcuをインストールしたMCUとの通信クラスを提供する。
 */


class MiMicLib
{
	private static $_hex_dt=array("","0","00","000","0000","00000","000000","0000000");
	/**
	 * 桁数を指定して、int値を16進数に変換する。
	 * @param {int} i_val
	 * 変換する値
	 * @param {int} i_digit
	 * 桁数
	 * @return {string}
	 * 文字列形式の値
	 */
	static public function hexout($i_val,$i_digit)
	{
		try{
			$s=sprintf('%x',$i_val);
			if(strlen($s)>$i_digit){
				//マイナスだともれなくエラー
				throw new MiMicException();
			}
			$l=$i_digit-strlen($s);
			return self::$_hex_dt[$l].$s;
		}catch(Exception $e){
			throw new MiMicException($e);
		}
	}
}
class MiMicException extends Exception
{
	public function __construct($s=null)
	{
		if(is_null($s)){
			parent::__construct();
		}else{
			parent::__construct($s);
		}
	}
}


?>

