/**
 * @file
 * LPC176xのターゲットテーブルです。
 */
#include "TargetTypes.h"
#include "RpcHandlerBase.h"
#ifdef TARGET_LPC1768
namespace MiMic
{

#define NS_LPC_PIN_0	PINID_LPC
#define NS_LPC_PIN_1	(NS_LPC_PIN_0+32)
#define NS_LPC_PIN_2	(NS_LPC_PIN_1+32)
#define NS_LPC_PIN_3	(NS_LPC_PIN_2+32)
#define NS_LPC_PIN_4	(NS_LPC_PIN_3+32)
#define NS_LPC_PIN_5	(NS_LPC_PIN_4+32)

const static struct TPinNameMapItem pin_table[]={
	{P0_0	,NS_LPC_PIN_0+0},	{P0_1	,NS_LPC_PIN_0+1},	{P0_2	,NS_LPC_PIN_0+2},	{P0_3	,NS_LPC_PIN_0+3},
	{P0_4	,NS_LPC_PIN_0+4},	{P0_5	,NS_LPC_PIN_0+5},	{P0_6	,NS_LPC_PIN_0+6},	{P0_7	,NS_LPC_PIN_0+7},
	{P0_8	,NS_LPC_PIN_0+8},	{P0_9	,NS_LPC_PIN_0+9},	{P0_10	,NS_LPC_PIN_0+10},	{P0_11	,NS_LPC_PIN_0+11},
	{P0_12	,NS_LPC_PIN_0+12},	{P0_13	,NS_LPC_PIN_0+13},	{P0_14	,NS_LPC_PIN_0+14},	{P0_15	,NS_LPC_PIN_0+15},
	{P0_16	,NS_LPC_PIN_0+16},	{P0_17	,NS_LPC_PIN_0+17},	{P0_18	,NS_LPC_PIN_0+18},	{P0_19	,NS_LPC_PIN_0+19},
	{P0_20	,NS_LPC_PIN_0+20},	{P0_21	,NS_LPC_PIN_0+21},	{P0_22	,NS_LPC_PIN_0+22},	{P0_23	,NS_LPC_PIN_0+23},
	{P0_24	,NS_LPC_PIN_0+24},	{P0_25	,NS_LPC_PIN_0+25},	{P0_26	,NS_LPC_PIN_0+26},	{P0_27	,NS_LPC_PIN_0+27},
	{P0_28	,NS_LPC_PIN_0+28},	{P0_29	,NS_LPC_PIN_0+29},	{P0_30	,NS_LPC_PIN_0+30},	{P0_31	,NS_LPC_PIN_0+31},

	{P1_0	,NS_LPC_PIN_1+0},	{P1_1	,NS_LPC_PIN_1+1},	{P1_2	,NS_LPC_PIN_1+2},	{P1_3	,NS_LPC_PIN_1+3},
	{P1_4	,NS_LPC_PIN_1+4},	{P1_5	,NS_LPC_PIN_1+5},	{P1_6	,NS_LPC_PIN_1+6},	{P1_7	,NS_LPC_PIN_1+7},
	{P1_8	,NS_LPC_PIN_1+8},	{P1_9	,NS_LPC_PIN_1+9},	{P1_10	,NS_LPC_PIN_1+10},	{P1_11	,NS_LPC_PIN_1+11},
	{P1_12	,NS_LPC_PIN_1+12},	{P1_13	,NS_LPC_PIN_1+13},	{P1_14	,NS_LPC_PIN_1+14},	{P1_15	,NS_LPC_PIN_1+15},
	{P1_16	,NS_LPC_PIN_1+16},	{P1_17	,NS_LPC_PIN_1+17},	{P1_18	,NS_LPC_PIN_1+18},	{P1_19	,NS_LPC_PIN_1+19},
	{P1_20	,NS_LPC_PIN_1+20},	{P1_21	,NS_LPC_PIN_1+21},	{P1_22	,NS_LPC_PIN_1+22},	{P1_23	,NS_LPC_PIN_1+23},
	{P1_24	,NS_LPC_PIN_1+24},	{P1_25	,NS_LPC_PIN_1+25},	{P1_26	,NS_LPC_PIN_1+26},	{P1_27	,NS_LPC_PIN_1+27},
	{P1_28	,NS_LPC_PIN_1+28},	{P1_29	,NS_LPC_PIN_1+29},	{P1_30	,NS_LPC_PIN_1+30},	{P1_31	,NS_LPC_PIN_1+31},

	{P2_0	,NS_LPC_PIN_2+0},	{P2_1	,NS_LPC_PIN_2+1},	{P2_2	,NS_LPC_PIN_2+2},	{P2_3	,NS_LPC_PIN_2+3},
	{P2_4	,NS_LPC_PIN_2+4},	{P2_5	,NS_LPC_PIN_2+5},	{P2_6	,NS_LPC_PIN_2+6},	{P2_7	,NS_LPC_PIN_2+7},
	{P2_8	,NS_LPC_PIN_2+8},	{P2_9	,NS_LPC_PIN_2+9},	{P2_10	,NS_LPC_PIN_2+10},	{P2_11	,NS_LPC_PIN_2+11},
	{P2_12	,NS_LPC_PIN_2+12},	{P2_13	,NS_LPC_PIN_2+13},	{P2_14	,NS_LPC_PIN_2+14},	{P2_15	,NS_LPC_PIN_2+15},
	{P2_16	,NS_LPC_PIN_2+16},	{P2_17	,NS_LPC_PIN_2+17},	{P2_18	,NS_LPC_PIN_2+18},	{P2_19	,NS_LPC_PIN_2+19},
	{P2_20	,NS_LPC_PIN_2+20},	{P2_21	,NS_LPC_PIN_2+21},	{P2_22	,NS_LPC_PIN_2+22},	{P2_23	,NS_LPC_PIN_2+23},
	{P2_24	,NS_LPC_PIN_2+24},	{P2_25	,NS_LPC_PIN_2+25},	{P2_26	,NS_LPC_PIN_2+26},	{P2_27	,NS_LPC_PIN_2+27},
	{P2_28	,NS_LPC_PIN_2+28},	{P2_29	,NS_LPC_PIN_2+29},	{P2_30	,NS_LPC_PIN_2+30},	{P2_31	,NS_LPC_PIN_2+31},

	{P3_0	,NS_LPC_PIN_2+0},	{P3_1	,NS_LPC_PIN_2+1},	{P3_2	,NS_LPC_PIN_2+2},	{P3_3	,NS_LPC_PIN_2+3},
	{P3_4	,NS_LPC_PIN_2+4},	{P3_5	,NS_LPC_PIN_2+5},	{P3_6	,NS_LPC_PIN_2+6},	{P3_7	,NS_LPC_PIN_2+7},
	{P3_8	,NS_LPC_PIN_2+8},	{P3_9	,NS_LPC_PIN_2+9},	{P3_10	,NS_LPC_PIN_2+10},	{P3_11	,NS_LPC_PIN_2+11},
	{P3_12	,NS_LPC_PIN_2+12},	{P3_13	,NS_LPC_PIN_2+13},	{P3_14	,NS_LPC_PIN_2+14},	{P3_15	,NS_LPC_PIN_2+15},
	{P3_16	,NS_LPC_PIN_2+16},	{P3_17	,NS_LPC_PIN_2+17},	{P3_18	,NS_LPC_PIN_2+18},	{P3_19	,NS_LPC_PIN_2+19},
	{P3_20	,NS_LPC_PIN_2+20},	{P3_21	,NS_LPC_PIN_2+21},	{P3_22	,NS_LPC_PIN_2+22},	{P3_23	,NS_LPC_PIN_2+23},
	{P3_24	,NS_LPC_PIN_2+24},	{P3_25	,NS_LPC_PIN_2+25},	{P3_26	,NS_LPC_PIN_2+26},	{P3_27	,NS_LPC_PIN_2+27},
	{P3_28	,NS_LPC_PIN_2+28},	{P3_29	,NS_LPC_PIN_2+29},	{P3_30	,NS_LPC_PIN_2+30},	{P3_31	,NS_LPC_PIN_2+31},
	
	{P4_0	,NS_LPC_PIN_4+0},	{P4_1	,NS_LPC_PIN_4+1},	{P4_2	,NS_LPC_PIN_4+2},	{P4_3	,NS_LPC_PIN_4+3},
	{P4_4	,NS_LPC_PIN_4+4},	{P4_5	,NS_LPC_PIN_4+5},	{P4_6	,NS_LPC_PIN_4+6},	{P4_7	,NS_LPC_PIN_4+7},
	{P4_8	,NS_LPC_PIN_4+8},	{P4_9	,NS_LPC_PIN_4+9},	{P4_10	,NS_LPC_PIN_4+10},	{P4_11	,NS_LPC_PIN_4+11},
	{P4_12	,NS_LPC_PIN_4+12},	{P4_13	,NS_LPC_PIN_4+13},	{P4_14	,NS_LPC_PIN_4+14},	{P4_15	,NS_LPC_PIN_4+15},
	{P4_16	,NS_LPC_PIN_4+16},	{P4_17	,NS_LPC_PIN_4+17},	{P4_18	,NS_LPC_PIN_4+18},	{P4_19	,NS_LPC_PIN_4+19},
	{P4_20	,NS_LPC_PIN_4+20},	{P4_21	,NS_LPC_PIN_4+21},	{P4_22	,NS_LPC_PIN_4+22},	{P4_23	,NS_LPC_PIN_4+23},
	{P4_24	,NS_LPC_PIN_4+24},	{P4_25	,NS_LPC_PIN_4+25},	{P4_26	,NS_LPC_PIN_4+26},	{P4_27	,NS_LPC_PIN_4+27},
	{P4_28	,NS_LPC_PIN_4+28},	{P4_29	,NS_LPC_PIN_4+29},	{P4_30	,NS_LPC_PIN_4+30},	{P4_31	,NS_LPC_PIN_4+31},

	// mbed DIP Pin Names
	
	{P0_9	,PINID_MBED_DIP+5},	{P0_8	,PINID_MBED_DIP+6},	{P0_7	,PINID_MBED_DIP+7},	{P0_6	,PINID_MBED_DIP+8},
	{P0_0	,PINID_MBED_DIP+9},	{P0_1	,PINID_MBED_DIP+10},{P0_18	,PINID_MBED_DIP+11},{P0_17	,PINID_MBED_DIP+12},
	{P0_15	,PINID_MBED_DIP+13},{P0_16	,PINID_MBED_DIP+14},{P0_23	,PINID_MBED_DIP+15},{P0_24	,PINID_MBED_DIP+16},
	{P0_25	,PINID_MBED_DIP+17},{P0_26	,PINID_MBED_DIP+18},{P1_30,	PINID_MBED_DIP+19},	{P1_31,	PINID_MBED_DIP+20},
	{P2_5,	PINID_MBED_DIP+21},	{P2_4,	PINID_MBED_DIP+22},	{P2_3,	PINID_MBED_DIP+23},	{P2_2,	PINID_MBED_DIP+24},
	{P2_1,	PINID_MBED_DIP+25},	{P2_0,	PINID_MBED_DIP+26},	{P0_11,	PINID_MBED_DIP+27},	{P0_10,	PINID_MBED_DIP+28},
	{P0_5,	PINID_MBED_DIP+29},	{P0_4,	PINID_MBED_DIP+30},
		
	// Other mbed Pin Names	

#ifdef MCB1700
	{P1_28	,PINID_OTHER_MBED_LEDx+0},	{P1_29	,PINID_OTHER_MBED_LEDx+1},	{P1_31	,PINID_OTHER_MBED_LEDx+2},	{P2_2	,PINID_OTHER_MBED_LEDx+3},
#else
	{P1_18	,PINID_OTHER_MBED_LEDx+0},	{P1_20	,PINID_OTHER_MBED_LEDx+1},	{P1_21	,PINID_OTHER_MBED_LEDx+2},	{P1_23	,PINID_OTHER_MBED_LEDx+3},
#endif
	{P0_2,PINID_OTHER_MBED_USBx+0},{P0_3,PINID_OTHER_MBED_USBx+1},

	// Arch Pro Pin Names

	{P4_29	,PINID_ARCH_PRO_Dx+0},	{P4_28	,PINID_ARCH_PRO_Dx+1},	{P0_4	,PINID_ARCH_PRO_Dx+2},	{P0_5	,PINID_ARCH_PRO_Dx+3},
	{P2_2	,PINID_ARCH_PRO_Dx+4},	{P2_3	,PINID_ARCH_PRO_Dx+5},	{P2_4	,PINID_ARCH_PRO_Dx+6},	{P2_5	,PINID_ARCH_PRO_Dx+7},
	{P0_0	,PINID_ARCH_PRO_Dx+8},	{P0_1	,PINID_ARCH_PRO_Dx+9},	{P0_6	,PINID_ARCH_PRO_Dx+10},{P0_9	,PINID_ARCH_PRO_Dx+11},
	{P0_8	,PINID_ARCH_PRO_Dx+12},{P0_7	,PINID_ARCH_PRO_Dx+13},{P0_27	,PINID_ARCH_PRO_Dx+14},{P0_28	,PINID_ARCH_PRO_Dx+15},
	
	{P0_23,PINID_ARCH_PRO_Ax+0},{P0_24,PINID_ARCH_PRO_Ax+1},{P0_25,PINID_ARCH_PRO_Ax+2},{P0_26,PINID_ARCH_PRO_Ax+3},
	{P1_30,PINID_ARCH_PRO_Ax+4},{P1_31,PINID_ARCH_PRO_Ax+5},
 
	{D15,PINID_ARCH_PRO_I2C_x+0},{D14,PINID_ARCH_PRO_I2C_x+1},
	{NC,PINID_NC}
};

#define NUMBER_OF_PINMODE 5
const static struct TPinModeMapItem pinmode_table[]=
{
	{PullUp		,PINMODEID+0},
	{PullDown	,PINMODEID+1},
	{PullNone	,PINMODEID+2},
	{OpenDrain	,PINMODEID+3},
	{PullDefault,PINMODEID+4}
};
#define NUMBER_OF_PORT_NAME 5
const static struct TPortNameMapItem portname_table[]=
{
	{Port0	,PORTID+0},
	{Port1	,PORTID+1},
	{Port2	,PORTID+2},
	{Port3	,PORTID+3},
	{Port4	,PORTID+4}
};

PinName RpcHandlerBase::pinId2PinName(unsigned int i_id)
{
	for(int i=0;pin_table[i].name!=NC;i++){
		if(i_id==pin_table[i].id){
			return pin_table[i].name;
		}
	}
	return NC;
}

PinMode RpcHandlerBase::pinmodeId2PinMode(unsigned int i_id)
{
	for(int i=0;i<NUMBER_OF_PINMODE;i++){
		if(i_id==pinmode_table[i].id){
			return pinmode_table[i].mode;
		}
	}
	return PullDefault;
}
PortName RpcHandlerBase::portId2PortName(unsigned int i_id)
{
	for(int i=0;i<NUMBER_OF_PORT_NAME;i++){
		if(i_id==portname_table[i].id){
			return portname_table[i].port;
		}
	}
	return Port0;
}

}
#endif
