class Composite:
  def __init__(self):
    self.children = []
    self.parent = None

  def addChild(self, child, index = None):
    if index == None:
      self.children.append(child)
    else:
      self.children.insert(index, child)      
    child.parent = self

  def removeChild(self, child):
    self.children.remove(child)
    child.parent = None

  def moveForward(self):
    parent = self.parent
    if parent == None:
      return
    index = parent.children.index(self)
    parent.removeChild(self)
    parent.addChild(self, index - 1)

  def moveBack(self):
    parent = self.parent
    if parent == None:
      return
    index = parent.children.index(self)
    parent.removeChild(self)
    parent.addChild(self, index + 1)

  def moveUp(self):
    parent = self.parent
    if parent == None:
      return
    grand_parent = parent.parent
    if grand_parent == None:
      return 
    index = grand_parent.children.index(parent)
    parent.removeChild(self)
    grand_parent.addChild(self, index + 1)

  def moveDown(self):
    parent = self.parent
    if parent == None:
      return
    index = parent.children.index(self)
    if index == 0:
      return
    
    brother = parent.children[index - 1]
    parent.removeChild(self)
    brother.addChild(self)
