import unittest
from Composite import Composite

class CompositeTestCase(unittest.TestCase):
  def setUp(self):
    self.parent  = Composite()
    self.child1  = Composite()
    self.child2  = Composite()
    self.child11 = Composite()
    self.child21 = Composite()
    self.child22 = Composite()

    self.parent.addChild(self.child1)
    self.parent.addChild(self.child2)
    self.child1.addChild(self.child11)
    self.child2.addChild(self.child21)
    self.child2.addChild(self.child22)

  def testChildren(self):
    self.assertEqual([self.child1, self.child2],   self.parent.children)
    self.assertEqual([self.child11],               self.child1.children)
    self.assertEqual([self.child21, self.child22], self.child2.children)
    self.assertEqual([], self.child11.children)
    self.assertEqual([], self.child21.children)
    self.assertEqual([], self.child22.children)

  def testParent(self):
    self.assertEqual(None,        self.parent.parent)
    self.assertEqual(self.parent, self.child1.parent)
    self.assertEqual(self.parent, self.child2.parent)
    self.assertEqual(self.child1, self.child11.parent)
    self.assertEqual(self.child2, self.child21.parent)
    self.assertEqual(self.child2, self.child22.parent)

  def testAddChild(self):
    child12 = Composite()

    self.assertEqual([self.child11], self.child1.children)
    self.assertEqual(None, child12.parent)
    
    self.child1.addChild(child12)
    self.assertEqual([self.child11, child12], self.child1.children)
    self.assertEqual(self.child1, child12.parent)

  def testAddChildWithIndex(self):
    child21_5 = Composite()

    self.assertEqual([self.child21, self.child22], self.child2.children)
    self.assertEqual(None, child21_5.parent)
    
    self.child2.addChild(child21_5, 1)
    self.assertEqual([self.child21, child21_5, self.child22], self.child2.children)
    self.assertEqual(self.child2, child21_5.parent)

  def testRemoveChild(self):
    self.assertEqual([self.child21, self.child22], self.child2.children)
    self.assertEqual(self.child2, self.child21.parent)
    
    self.child2.removeChild(self.child21)
    self.assertEqual([self.child22], self.child2.children)
    self.assertEqual(None, self.child21.parent)

  def testMoveForward(self):
    self.child2.moveForward()
    self.assertEqual([self.child2, self.child1], self.parent.children)

    # don't move
    self.child2.moveForward()
    self.assertEqual([self.child2, self.child1], self.parent.children)

  def testMoveBack(self):
    self.child1.moveBack()
    self.assertEqual([self.child2, self.child1], self.parent.children)

    # don't move
    self.child1.moveBack()
    self.assertEqual([self.child2, self.child1], self.parent.children)

  def testMoveUp(self):
    self.child11.moveUp()
    self.assertEqual([self.child1, self.child11, self.child2], self.parent.children)
    self.assertEqual([], self.child1.children)

    # don't move
    self.child11.moveUp()
    self.assertEqual([self.child1, self.child11, self.child2], self.parent.children)
    self.assertEqual([], self.child1.children)

  def testMoveDown(self):
    self.child2.moveDown()
    self.assertEqual([self.child1], self.parent.children)
    self.assertEqual([self.child11, self.child2], self.child1.children)

    # don't move
    self.child1.moveDown()
    self.assertEqual([self.child1], self.parent.children)
    self.assertEqual([self.child11, self.child2], self.child1.children)

  def testMoveRoot(self):
    self.parent.moveForward()
    self.parent.moveBack()
    self.parent.moveUp()


if __name__ == "__main__":
  unittest.main()
