from Globals import InitializeClass, DTMLFile
from App.ImageFile import ImageFile
from Acquisition import Implicit
from Globals import Persistent
from OFS.SimpleItem import Item
#from OFS.PropertyManager import PropertyManager
from MindMap import MindMap, MindMapRoot
from XML2MindMapRoot import XML2MindMapRoot

manage_addMindMapBBSForm=DTMLFile('dtml/add', globals())
def manage_addMindMapBBS(context, id, title, REQUEST=None):
  """ add function """
  p = MindMapBBS(id, title)
  context._setObject(id, p)
  if REQUEST is not None:
    context.manage_main(context, REQUEST)

class MindMapBBS(Implicit, Persistent, Item):
  meta_type = 'MindMapBBS'
  _properties = (
    {'id':'title',   'type':'string', 'mode':'w'},
  )
  index_html = DTMLFile('dtml/index_html', globals())
  view = DTMLFile('dtml/view', globals())
  editForm = DTMLFile('dtml/edit', globals())
  triangle = DTMLFile('dtml/triangle', globals())
  mind_branch = DTMLFile('dtml/mind_branch', globals())
  mind_leaf = DTMLFile('dtml/mind_leaf', globals())
  mind_leaf_view = DTMLFile('dtml/mind_leaf_view', globals())
  mind_leaf_view_icons = DTMLFile('dtml/mind_leaf_view_icons', globals())
  mind_leaf_edit = DTMLFile('dtml/mind_leaf_edit', globals())

  xml = DTMLFile('dtml/xml', globals())
  xml_leaf = DTMLFile('dtml/xml_leaf', globals())

  manage_options = (
    {'label' : 'Edit', 'action' : 'editForm'},
    {'label' : 'View', 'action' : 'index_html'},
    )


  def __init__(self, id, title):
    """ init """
    self.id = id
    self.title = title
    self.root = MindMapRoot()
    self.root.add(None, 'root')
    self._p_changed = 1

  def __call__(self, client=None, REQUEST={}, RESPONSE=None, **kw):
    """ call from dtml var """
    return self.view.__call__(client, REQUEST, RESPONSE, kw)

  def root_message(self):
    return self.root.getRoot().getMessage()

  def manage_edit(self, title, xml_string, REQUEST=None):
    """ set project setting """
    self.title = title
    self.root = XML2MindMapRoot().createFromXML(xml_string)

    if REQUEST is not None:
      return self.editForm(REQUEST,
                           manage_tabs_message="Saved changes.")

  def action(self, command, code, mmb_url, return_url,
             color=None, message=None, link=None, picture=None, REQUEST=None):
    """ action """
    if command == 'add':
      child = self.root.add(code, '')
      self._p_changed = 1
      return_url += '?code=' + child.getCode() + '&mmb_url=' + mmb_url
      return_url += '#MMB' + mmb_url + '-' + child.getCode()

    if command == 'change':
      return_url += '?code=' + code + '&mmb_url=' + mmb_url
      return_url += '#MMB' + mmb_url + '-' + code
      
    if command == 'edit':
      self.root.change(code, message, color, link, picture)
      self.refresh(self.root.getRoot())
      self._p_changed = 1
      return_url += '#MMB' + mmb_url + '-' + code
      
    if command == 'forward':
      self.root.decode_map[code].moveForward()
      self.refresh(self.root.getRoot())
      self._p_changed = 1
      return_url += '#MMB' + mmb_url + '-' + code

    if command == 'back':
      self.root.decode_map[code].moveBack()
      self.refresh(self.root.getRoot())
      self._p_changed = 1
      return_url += '#MMB' + mmb_url + '-' + code

    if command == 'up':
      self.root.decode_map[code].moveUp()
      self.refresh(self.root.getRoot())
      self._p_changed = 1
      return_url += '#MMB' + mmb_url + '-' + code

    if command == 'down':
      self.root.decode_map[code].moveDown()
      self.refresh(self.root.getRoot())
      self._p_changed = 1
      return_url += '#MMB' + mmb_url + '-' + code

    if command == 'newmmb':
      folder = self.aq_parent
      nextKey = self.getNextKey(folder)
      to_mmb = MindMapBBS(nextKey, '')
      folder._setObject(nextKey, to_mmb)

      from_mm = self.root.decode_map[code]
      message = from_mm.getMessage()
      color = from_mm.getColor()
      to_mm = to_mmb.root.getRoot()
      to_mm.setMessage(message)
      to_mm.setColor(color)
      to_mm.setMmbLink(None)      
      to_mmb._p_changed = 1

      changed = self.mmbRefresh(self.root.getRoot())
      if changed:
        self._p_changed = 1

      return_url = nextKey

    if REQUEST is not None:
      REQUEST.RESPONSE.redirect(return_url)
    
  def getNextKey(self, folder):
    keys = self.getKeys(folder)
    key_number = 0
    while 1:
      key_string = 'mmb' + str(key_number)
      if not key_string in keys:
        return key_string
      key_number += 1
      
  def getKeys(self, folder):
    ids = folder.objectIds()
    keys = []
    for id in ids:
      keys.append(id)
    return keys

  def refresh(self, root):
    root.refresh()
    self.mmbRefresh(root)

  def mmbRefresh(self, root):
    root.refresh()
    folder = self.aq_parent
    items = folder.objectItems('MindMapBBS')
    map = {}
    for id, mmb in items:
      if id != self.id:
        map[mmb.root_message()] = id
    changed = root.mmbRefresh(map, root.getMessage())
    print "changed", changed
    return changed

InitializeClass(MindMapBBS)
