import unittest
from MindMap import *

class MindMapRootTestCase(unittest.TestCase):
  def setUp(self):
    self.mmr = MindMapRoot()
    self.root    = self.mmr.add(None, 'root')
    self.child0  = self.mmr.add(self.root.getCode(),   'child0')
    self.child00 = self.mmr.add(self.child0.getCode(), 'child00')
    self.child1  = self.mmr.add(self.root.getCode(),   'child1')
    self.child10 = self.mmr.add(self.child1.getCode(), 'child10')
    self.child11 = self.mmr.add(self.child1.getCode(), 'child11')

  def testGetRoot(self):
    self.assertEqual('root', self.mmr.getRoot().getMessage())

  def testIdNumber(self):
    self.assertEqual('0', self.root.getCode())
    self.assertEqual('1', self.child0.getCode())
    self.assertEqual('2', self.child00.getCode())
    self.assertEqual('3', self.child1.getCode())
    self.assertEqual('4', self.child10.getCode())
    self.assertEqual('5', self.child11.getCode())

    self.assertEqual(self.root, self.mmr.decode_map['0'])
    self.assertEqual(self.child0, self.mmr.decode_map['1'])
    self.assertEqual(self.child00, self.mmr.decode_map['2'])
    self.assertEqual(self.child1, self.mmr.decode_map['3'])
    self.assertEqual(self.child10, self.mmr.decode_map['4'])
    self.assertEqual(self.child11, self.mmr.decode_map['5'])

  def testColor(self):
    self.assertEqual('black', self.mmr.getRoot().getColor())
 
  def testChangeRoot(self):
    child = self.mmr.getRoot()
    self.assertEqual('root', child.getMessage())
    self.assertEqual('black', child.getColor())
    self.assertEqual('', child.getLink())

    self.mmr.change(self.root.getCode(), 'changed message', 'red', 'link', 'picture')
    self.assertEqual('changed message', child.getMessage())
    self.assertEqual('red', child.getColor())
    self.assertEqual('link', child.getLink())
    self.assertEqual('picture', child.getPicture())

  def testChangeChild10(self):
    child10 = self.mmr.decode_map[self.child10.getCode()]
    self.assertEqual('child10', child10.getMessage())
    self.assertEqual('black', child10.getColor())

    self.mmr.change(self.child10.getCode(), 'changed message', 'red', 'link', 'picture')
    self.assertEqual('changed message', child10.getMessage())
    self.assertEqual('red', child10.getColor())
    self.assertEqual('link', child10.getLink())
    self.assertEqual('picture', child10.getPicture())

  def testAdd(self):
    child10 = self.mmr.decode_map[self.child10.getCode()]
    child10.setColor('green')

    child100 = self.mmr.add(self.child10.getCode(), 'add message')
    self.assertEqual('6', child100.getCode())
    self.assertEqual('add message', child100.getMessage())
    self.assertEqual('green', child100.getColor())
    self.assertEqual(child100, self.mmr.decode_map['6'])

if __name__ == "__main__":
  unittest.main()
