import unittest
from XML2MindMapRoot import XML2MindMapRoot

class XML2MindMapRootTestCase(unittest.TestCase):
  def setUp(self):
    self.xml2mmr = XML2MindMapRoot()

  def testCreateFromXML1(self):
    xml_string = '<map>\n'
    xml_string += ' <node TEXT="parent" color="red"/>\n'
    xml_string += '</map>\n'
    root = self.xml2mmr.createFromXML(xml_string)
    parent = root.getRoot()
    self.assertEqual('parent', parent.getMessage())
    self.assertEqual('red', parent.getColor())

  def testCreateFromXML1n(self):
    xml_string = '<map>\n'
    xml_string += ' <node TEXT="parent\nsecond" color="red"/>\n'
    xml_string += '</map>\n'
    root = self.xml2mmr.createFromXML(xml_string)
    parent = root.getRoot()
    self.assertEqual('parent second', parent.getMessage())
    self.assertEqual('red', parent.getColor())

  def testCreateFromXML2(self):
    xml_string = '<map>\n'
    xml_string += ' <node TEXT="parent" color="red">\n'
    xml_string += '  <node TEXT="child" color="blue"/>\n'
    xml_string += ' </node>\n'
    xml_string += '</map>\n'
    root = self.xml2mmr.createFromXML(xml_string)
    parent = root.getRoot()
    self.assertEqual('parent', parent.getMessage())
    self.assertEqual('red', parent.getColor())

    child = parent.children[0]
    self.assertEqual('child', child.getMessage())
    self.assertEqual('blue', child.getColor())

if __name__ == "__main__":
  unittest.main()
