<?php
//	php の閉じタグは、動作不具合の原因になるおそれがあるため、省略する。

define("MODE_INSUPD_NG", "0");
define("MODE_INSUPD_OK", "1");

define("MODE_DISP_OFF", "100");
define("MODE_DISP_ON", "200");

define("MODE_OUT_PHP", "0");
define("MODE_OUT_HTML", "1");
define("MODE_OUT_HTML_LINK", "2");
define("MODE_OUT_WGET", "3");

define("MODE_TRUE", "1");
define("MODE_FALSE", "2");

define("RESULT_OK", "1");
define("RESULT_NG", "2");

define("DS_DBG_SILENT", 0);	//デバッグ表示レベル(表示なし)
define("DS_DBG_IMP", 10);	//デバッグ表示レベル(重要なもののみ表示)
define("DS_DBG_DETAIL", 20);	//デバッグ表示レベル(詳細な表示)

define("MODE_UPDATE", "1");
define("MODE_INSERT", "2");
define("MODE_SELECT", "3");




// E_NOTICE を表示させるのもおすすめ（初期化されていない
// 変数、変数名のスペルミスなど…）
// error_reporting(E_ERROR | E_WARNING | E_PARSE | E_NOTICE);

// 単純な実行時エラーを表示する
error_reporting(E_ERROR | E_WARNING | E_PARSE);

// 全てのエラー出力をオフにする
// error_reporting(0);

Function cGetDsnStr() {
	$c_Dsn_dat = new c_Dsn;
	Return $c_Dsn_dat->cGetDsnStr();
}

class c_Dsn	{
	var$dbUser;
	var$dbPass;
	var$dbHost;
	var$dbName;
	var$dbType;
	var$dbdsn;

	Function cGetDsnStr() {
		// それぞれcfg.php で設定
		$this->dbUser = DB_USERNAME;	
		$this->dbPass = DB_PASSWORD;
		$this->dbHost = DB_HOST;
		$this->dbName = DB_NAME;
		$this->dbType = DB_TYPE;

		$this->dsn = "$this->dbType://$this->dbUser:$this->dbPass@$this->dbHost/$this->dbName";
		Return $this->dsn;
	}
}

Function GetPDODsnStr() {
	$c_PDODsn_dat = new c_PDODsn;
	Return $c_PDODsn_dat->cGetPDODsnStr();
}

class c_PDODsn	{
	var $dbUser;
	var $dbPass;
	var $dbHost;
	var $dbName;
	var $dbType;
	var $PDODBdsn;
	Function cGetPDODsnStr() {
		// それぞれcfg.php で設定
		$this->dbUser = DB_USERNAME;	
		$this->dbPass = DB_PASSWORD;
		$this->dbHost = DB_HOST;
		$this->dbName = DB_NAME;
		$this->dbType = DB_TYPE;

		$this->PDODBdsn = "$this->dbType:dbname=$this->dbName;host=$this->dbHost";
		Return $this->PDODBdsn;
	}
}

class c_cfg1	{
	var $html_charset;		//1.出力時の HTML charset
	var $php_in_charset;	//2.PHP 内部の charset

	var $charset_html2db_in_html;	// 3-A.HTML の form で入力された HTML の charset
	var $charset_html2db_out_db;	// 3-B.DB へ INSERT/UPDATE する際の charset
	var $charset_db2html_in_db;		// 3-C.DB から SELECT した際の charset
	var $charset_db2html_out_html;	// 3-D.HTML へ出力する際の charset

	function cGetCharsetInfo()	{
//1.HTML 出力時に使用する文字列 (以下参照)
		//例: <meta http-equiv="Content-Type" content="text/html; charset=shift_jis">
		$this->html_charset = HTML_CHARSET;		// cfg.php 内で設定

//2. PHP 内部の charset
		$this->php_in_charset = PHP_IN_CHARSET;	// cfg.php 内で設定

// 3-A. HTML のフォームで入力された文字列の charset
		$this->charset_html2db_in_html = CHARSET_HTML2DB_IN_HTML;	// cfg.php 内で設定

// 3-B. DB へ INSERT する文字列の charset
		$this->charset_html2db_out_db = CHARSET_HTML2DB_OUT_DB;		// cfg.php 内で設定

// 3-C. DB から SELECT した際の charset 
//(通常は、「3-B. DB へ INSERT する文字列の charset」と同じ)
		$this->charset_db2html_in_db = $this->charset_html2db_out_db;
//		$this->charset_db2html_in_db = "SJIS";
//		$this->charset_db2html_in_db = "EUC-JP";
//		$this->charset_db2html_in_db = "ISO-2022-JP";

// 3-D. HTML へ出力する際の charset
//(通常は、「3-A. HTML のフォームで入力された文字列の charset」と同じ)
		$this->charset_db2html_out_html = $this->charset_html2db_in_html;
//		$this->charset_db2html_out_html = "SJIS";
//		$this->charset_db2html_out_html = "EUC-JP";
//		$this->charset_db2html_out_html = "ISO-2022-JP";
	}

	// DB へ INSERT する charset へ(必要に応じて) charset を変換
	Function cChgCharset4DB($pIn)	{
		$wStr = $pIn;
		if ($this->charset_html2db_out_db == $this->charset_html2db_in_html)	{
			//入力元と出力先の文字コードが同じなので文字コード変換はしない。
		}	else	{
			// HTML のフォームで入力された文字列の charset を、DB へ INSERT する charset へ変換
			$wStr = mb_convert_encoding($wStr, $this->charset_html2db_out_db, $this->charset_html2db_in_html);
//			$wStr = mb_convert_encoding($wStr,"SJIS","auto");//eucからsjis変換
		}
		Return $wStr;
	}

	Function cChgCharset4DB2($pIn)	{
		$wStr = $pIn;
		//	2013/05/02	文字化け対策
		Return $wStr;


		if ($this->charset_html2db_out_db == $this->charset_html2db_in_html)	{
			//入力元と出力先の文字コードが同じなので文字コード変換はしない。
		}	else	{
			// HTML のフォームで入力された文字列の charset を、DB へ INSERT する charset へ変換
			if ($this->charset_html2db_in_html == "SJIS")	{
				if ($this->charset_html2db_out_db == "EUC-JP")	{
					$wStr = addslashes_sjis($wStr);
				}
			}
			$wStr = mb_convert_encoding($wStr, $this->charset_html2db_out_db, $this->charset_html2db_in_html);
//			$wStr = mb_convert_encoding($wStr,"SJIS","auto");//eucからsjis変換
		}
//		//MySQL の場合は、addslashes 関数で、5C を含む文字をエスケープ
//		if (DB_TYPE == "mysql")	{
//			if (!get_magic_quotes_gpc())	{
//				$wStr = addslashes($wStr);
//			}
//		}


		Return $wStr;
	}

	// DB から SELECT した文字列の charset を HTML に出力する charset へ(必要に応じて)変換
	Function cChgCharset4HTML($pIn)	{
		$wStr = $pIn;
		if ($this->charset_db2html_out_html == $this->charset_db2html_in_db)	{
			//入力元と出力先の文字コードが同じなので文字コード変換はしない。
		}	else	{
			// DB から SELECT した文字列の charset を HTML に出力する charset へ変換
			$wStr = mb_convert_encoding($wStr, $this->charset_db2html_out_html, $this->charset_db2html_in_db);
		}
		Return $wStr;
	}

	// PHP internal の charset を HTML に出力する charset へ(必要に応じて)変換
	Function cChgCharset4HTMLFromInternal($pIn)	{
		$wStr = $pIn;
		if ($this->charset_db2html_out_html == $this->php_in_charset)	{
			//入力元と出力先の文字コードが同じなので文字コード変換はしない。
		}	else	{
			// DB から SELECT した文字列の charset を HTML に出力する charset へ変換
			$wStr = mb_convert_encoding($wStr, $this->charset_db2html_out_html, $this->php_in_charset);
		}
		Return $wStr;
	}
}

class c_cfg2	{
	var $php_exec_file;
	var $insupdmode=MODE_INSUPD_OK;	//0: INSERT/UPDATE 不可(参照のみ) 1:INSERT/UPDATE 可
//	var $insupdmode=MODE_INSUPD_NG;	//0: INSERT/UPDATE 不可(参照のみ) 1:INSERT/UPDATE 可
	var $disp_tmclsftbl_all;
	var $disp_tref;
	var $disp_tref2;
	var $outputmode;
	var $disp_outfilemode;
	var $top_banner_str;	//画面上部のバナー文字列 → <img src...>
	var $html_charset;		//HTML のキャラクタセット
	var $html_title;		//HTML の <title></tilte> の文字列
	var $css_file;			//css ファイルパス (相対パス、絶対パス指定可能)
	var $dispdfid_cfg2val;			//文書タイトルの先頭に [(文書番号)] を付加するかどうか(初期設定値)。

	function cJdgInsUpdMode()	{
		$wStr = $this->php_exec_file;
		$wStr = mb_ereg_replace("[\\\]", "/", $wStr);	//パス区切り文字「\」を「/」へ変更。
		$path = dirname($wStr);      //ファイル名を抜かしたパスだけ取得
//		echo "\$path=$path<br>\n";
		// 最後にディレクトリセパレータが出た箇所から最後までを取得
		$dirname = strrchr($path, "/");
//		echo "\$dirname=$dirname<br>\n";
		// 頭についている/を取る
		$dirnamens = substr($dirname, 1);
//		echo "\$dirnamens=$dirnamens<br>\n";

		if ($dirnamens == ADMIN_DIR)	{
			$insupdmode=MODE_INSUPD_OK;	//0: INSERT/UPDATE 不可(参照のみ) 1:INSERT/UPDATE 可
		}	else	{
			$insupdmode=MODE_INSUPD_NG;	//0: INSERT/UPDATE 不可(参照のみ) 1:INSERT/UPDATE 可
		}
		return $insupdmode;
	}
	
	function cGetOutputMode($pMdNo)	{
		if ($pMdNo == "")	{
			$pMdNo = "0";
		}
		switch($pMdNo)	{
			case MODE_OUT_PHP:	//通常モード。php で画面表示。
				$this->disp_tmclsftbl_all = MODE_DISP_ON;
				$this->disp_tref = MODE_DISP_ON;
				$this->disp_tref2 = MODE_DISP_OFF;
				$this->dispdfid = DFIDTITLENODISPMODE;
				//css file
				$this->css_file =OM_0_CSS;
				//画面最上部のバナー
				if ($this->cJdgInsUpdMode()==MODE_INSUPD_OK)	{
					$this->top_banner_str = "<img src=\"" . OM_0_TOP_BANNER_INSUPD_OK. "\">";
				}	else	{
					$this->top_banner_str = "<img src=\"" . OM_0_TOP_BANNER_INSUPD_NG. "\">";
				}
				break;
			case MODE_OUT_HTML:	//HTML へエクスポートするモード。
				$this->disp_tmclsftbl_all = MODE_DISP_OFF;
				$this->disp_tref = MODE_DISP_OFF;
				$this->disp_tref2 = MODE_DISP_ON;
				$this->disp_outfilemode = MODE_OUT_HTML;
				$this->dispdfid = DFIDTITLENODISPMODE;
				//css file
				$this->css_file =OM_1_CSS;
				break;
			case MODE_OUT_WGET:	//WGET でダウンロードするモード。
				$this->disp_tmclsftbl_all = MODE_DISP_OFF;
				$this->disp_tref = MODE_DISP_OFF;
				$this->disp_tref2 = MODE_DISP_ON;
				$this->disp_outfilemode = $pMdNo;
				$this->dispdfid = DFIDTITLENODISPMODE;
				//css file
				$this->css_file =OM_1_CSS;
				break;
			default:
				$this->disp_tmclsftbl_all = MODE_DISP_ON;
				$this->disp_tref = MODE_DISP_ON;
				$this->disp_tref2 = MODE_DISP_OFF;
				$this->dispdfid = DFIDTITLENODISPMODE;
				//css file
				$this->css_file =OM_DEF_CSS;
				break;
		}
	}

	function cInitProc()	{
		$this->cJdgInsUpdMode();
		$this->cGetOutputMode($this->outputmode);
	}

	function cGetHtmlCharset()	{
		$c_cfg1dat = new c_cfg1;
		$c_cfg1dat = new c_cfg1;
		$c_cfg1dat->cGetCharsetInfo();
		$this->html_charset = "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=". $c_cfg1dat->html_charset . "\">\n";
//		$this->html_charset = cGetHtmlCharset();	//cfg.php の cGetHtmlCharset() 関数を実行
		Return $this->html_charset;
	}

	Function cGetHtmlTitleStr($p_dispdfid_cfg2val, $p_dispdfid_getargval, $p_dfid, $p_dftitle) {

		if (isset($p_dispdfid_cfg2val))	{
		}
		else
		{
			$p_dispdfid_cfg2val = MODE_TRUE;
		}
		$wDispdfid = $p_dispdfid_cfg2val;

		//GET の引数に指定されている場合のみ
		//cfg2 で指定されている値よりも
		//GET の引数の値が優先される。
		if (isset($p_dispdfid_getargval))	{
			$wDispdfid = $p_dispdfid_getargval;
		}

		$wStr = "";
		if ($wDispdfid == MODE_TRUE)	{
			//文書タイトルの先頭に、文書番号を付加する
			$wStr= $wStr . "[". $p_dfid. "] ";
		}
		
//		$wStr= $wStr . "「" . DFIDTITLENODISPMODE . "」";
		$wStr= $wStr . $p_dftitle . "";
		return $wStr;
	}

	Function cGetHeaderStr() {
		$this->cInitProc();

		$wHStr="<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\">\n";
		$wHStr= $wHStr. "<html lang=\"ja\">";
		$wHStr= $wHStr. "<head>\n";
		$wHStr= $wHStr. $this->cGetHtmlCharset();
		$wHStr= $wHStr. "<meta http-equiv=\"Content-Style-Type\" content=\"text/css\">\n";
		$wHStr= $wHStr. "<link rel=\"stylesheet\" type=\"text/css\" href=\"" .$this->css_file ."\">\n";
		$wHStr= $wHStr. "<title>" . $this->html_title."</title>\n";
		$wHStr= $wHStr. "</head>\n";
		$wHStr= $wHStr. "<body>\n";
		return $wHStr;

	}

	Function cGetFooterStr() {

		$wHStr="\n";
		$wHStr= "</body>\n</html>\n";
		return $wHStr;

	}
}
