from statistics import NormalDist
import sys


class RunTest:
    def __init__(self, sequence, v1, v2):
        self.sequence = sequence
        self.v1, self.v2 = v1, v2

    def get_p(self):
        n1 = self.sequence.count(self.v1)
        n2 = self.sequence.count(self.v2)
        if n1 == 0 or n2 == 0:
            return None, None
        r_bar = 1.0 + (2.0 * n1 * n2) / (n1 + n2)
        sd = (2 * n1 * n2 * (2 * n1 * n2 - n1 -n2)) / (((n1 + n2) ** 2) * (n1 + n2 - 1))
        r = self.get_runs()
        z = (r - r_bar) / sd
        p = 2 * (1 - NormalDist().cdf(z))
        if p > 1.0:
            p = 1.0
        return z, p

    def get_runs(self):
        prev_value = None
        i = 0
        runs = 0
        while i < len(self.sequence):
            cur_vale = self.sequence[i]
            if prev_value != cur_vale:
                runs += 1
            i += 1
            prev_value = cur_vale
        return runs


def get_random_sequence(min, max, random):
    mn = 10**min
    mx = 10**max
    n = random.randint(mn, mx)
    return bin(n)[2:]
