#!/usr/local/bin/wish86

# Copyright: 2012 Miranda-JP Project, All Right Reserved.
# Redistribution and use in source and binary forms, with or without 
# modification, are permitted provided that the following conditions are met:
# 
# 1. Redistributions of source code must retain the above copyright notice, this 
#    list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright notice, 
#    this list of conditions and the following disclaimer in the documentation 
#    and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE MIRANDA-JP PROJECT ``AS IS'' AND ANY EXPRESS 
# OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
# EVENT SHALL THE MIRANDA-JP PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
# OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
# EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# The views and conclusions contained in the software and documentation are 
# those of the authors and should not be interpreted as representing official 
# policies, either expressed or implied, of the Miranda-JP Project.
#
# ϐ
set exts [list *.c *.cpp *.cxx *.h *.hxx]; # Ώۃt@Cglobp^[
set path [pwd]; # ΏۃpX̏l
set msg {ΏۃpXw肵ĉ}; # \bZ[W̏l
set files 0; # Ώۃt@C
set success 0; # t@C
set failed 0; # st@C
set outside 0; # ς݃t@C

# codeMenu -
#  w    tk_optionMenu ɓnEBhE
#      var  ϐ
# Tv
# SĂencoding nameIɂoptionMenu𐶐R[h
# 𐶐Bencoding names͐񂳂Asystem encoding擪ɒuB
# ʏÃvV[W̖߂levalėpB
proc codeMenu {w var} {
    set allEncodings [lsort -dictionary [encoding names]]; # sɃT|[g邷ׂĂencoding
    set defaultEncoding [encoding system]; # VXeencodingftHgƂ
    set cmd [list tk_optionMenu $w $var $defaultEncoding];# R}h̍쐬Jn
    foreach i $allEncodings {
	if {![string equal $defaultEncoding $i]} {
	    lappend cmd $i; # 擪ɕtς݂̃ftHgencodingȊOR}hlappend
	}
    }
    return $cmd; # 쐬R}hԂ
}

# expandPath -
#  path  JnfBNgpX
#      code  \[X؂̂ƂƂ̕R[h
#      mode  샂[h fromUTF8|toUTF
# Tv
# w肵fBNgȉׂĂ̊Kwɑ΂ĕϊΏۃt@Cɕϊ݂
proc expandPath {path code mode} {
    global files; # Ώۃt@CJE^
    # wpXׂ̂ẴGgɑ΂A
    foreach i [glob -nocomplain -- [file join $path *]] {
	# ꂪfBNgȂ
	if {[file isdirectory $i]} {
	    expandPath $i $code $mode; # expandPathċNs
	    continue; # ÃGg̏
	}
	# ꂪʏt@CłAΏۂ̃p^[ɈvȂ΁A
	if {[file isfile $i] && [isFile $i]} {
	    incr files; # JE^i߁A
	    doConvertFile $i $code $mode; # ̃t@Cɕϊ݂
	}
    }
}

# isFile -
#  path  `FbNt@C
# Tv
# wt@C path p^[Xg exts ̗vf̂ꂩɃ}b`Ȃΐ^A
# ɂ}b`ȂȂ΋UԂ
proc isFile {path} {
    global exts
    foreach i $exts {
	if {[string match $i $path]} {
	    return 1
	}
    }
    return 0
}

# doConvertFile
#  path  ϊt@C
#      code  \[X̕R[h
#      mode  샂[h fromUTF8|toUTF
# Tv
# modetoUTF8̏ꍇ̓\[Xt@Cpath𕶎R[hcodeƉ肵BOMtUTF-8R[h
# ɏ㏑ϊ
# łBOMtUTF-8ƂȂĂꍇAу\[XR[hSASCIIt@CłꍇA
# Ȃ킿łVC++ŏ\Ȍ`ƂȂĂꍇ͉Ȃ
# modefromUTF8̏ꍇ́A\[Xt@Cpath𕶎R[hBOMtUTF-8AR[h
# codeɏ㏑ϊ
# ̏ꍇApathBOMtUTF-8łȂΉȂB܂codeASCIȈꍇȂ
# ӁF͔̏jIłBΏۂ̓obNAbvƂAׂ݂ł
#       Ӑ}Ȃ삪ꍇ́AΏۃ\[X؂͔j󂳂\
proc doConvertFile {path code mode} {
    global success failed outside
    global msg
    
    # t@Cpath̓ebinaryœǂݍł܂
    if {[catch [list open $path] fp]} {
	incr failed; # t@CJȂ΃G[
	set msg "G[F $fp"; update
	return
    }
    fconfigure $fp -encoding binary -translation auto; # t@C`lbinary[hɐݒ
    set contents [read $fp]; # t@Ceꊇǂݍ
    catch [list close $fp];  # t@C

    # ̓t@CASCIIt@CA邢͂łBOMtׂ
    set isAscii [string is ascii $contents]
    set hasBOM [string match "\xef\xbb\xbf*" $contents]
    # ̓t@CASCIIȂ΃R[hϊȂB
    # łBOMtȂBOMt͂Ȃ
    # BOMtƎw肳ꂽ̓t@CBOMȂΉȂB
    # BOMtUTF-8ASCIIɂ͕ϊȂB
    if { $isAscii || \
	     ( $hasBOM && ( [string equal "toUTF8" $mode]) || [string equal "ascii" $code] ) || \
	     ( ! $hasBOM && [string equal "fromUTF8" $mode] ) } {
	incr outside; # ΏۊOJE^JEgAbv
	return
    }

    # o̓t@CJ
    if {[catch [list open $path w] fp]} {
	incr failed; # JȂ΃G[
	set msg "G[F $fp"; update
	return
    }
    fconfigure $fp -encoding binary -translation auto; # o̓t@Cbinary[h

    # BOMtUTF-8o͂ȂBOM܂o
    if {[string equal "toUTF8" $mode]} {
	if {[catch [list puts -nonewline $fp "\xef\xbb\xbf"] err]} {
	    catch [list close $fp]; # t@Co͂łȂ΃G[
	    incr failed; # G[JE^JEgAbv
	    set msg "G[F $err"; update
	    return
	}
    }
    # BOM폜Ȃ΍폜
    if {$hasBOM && [string equal "fromUTF8" $mode]} {
	set contents [string range $contents 3 end]
    }

    # o̓R[hɂ茈肷
    if {[string equal "toUTF8" $mode]} {
	set incode $code
	set outcode utf-8
    } else {
	set incode utf-8
	set outcode $code
    }
    # o
    if {[catch [list puts -nonewline $fp [encoding convertto $outcode [encoding convertfrom $incode $contents]]] err]} {
	    catch [list close $fp]; # Ƃ͌Ȃ
	    incr failed
	set msg "G[F $err"; update
	    return
    }
    if {[catch [list close $fp] err]} {
	incr failed; # o̓t@CȂ΃G[
	set msg "G[F $err"; update
	return
    }
    incr success; # JE^JEgAbv
}

# EBWFbg
label .l -textvariable msg -anchor w
frame .f1
label .f1.l -text "ΏۃpX:"
entry .f1.e -textvariable path
button .f1.b -text "Q" -command {
    set path [tk_chooseDirectory -initialdir $path -title "ΏۃtH_I"]
    if {[string equal "" $path]} {
	set path [pwd]
    }
}
pack .f1.l -side left
pack .f1.b -side right
pack .f1.e -side bottom -fill x -expand true
frame .f2
label .f2.l -text "t@CR[h"
eval [codeMenu .f2.cm code]
button .f2.exec1 -text "BOMtUTF-8ɕϊ" -command {
    set ret [tk_dialog .d1 "smF" \
		 "tH_ $path ȉ̊gq $exts ̃t@CSĂ̕R[h $code BOMtUTF-8ɕϊ܂H" \
		 question 0 yes no]
    if {[string equal "0" $ret]} {
	set files 0; set success 0; set failed 0; set outside 0; # 
	set msg "ł"; update
	expandPath $path $code toUTF8
	tk_dialog .d "s" \
	    "$files ̑Ώۃt@Ĉ $success ̃t@C̏ɐA $failed ̏ɎsA$outside ͑ΏۊOłB" info 0 ok 
    }
    set msg {ΏۃpXw肵ĉ}
}
button .f2.exec2 -text "BOMtUTF-8ϊ" -command {
    set ret [tk_dialog .d1 "smF" \
		 "tH_ $path ȉ̊gq $exts ̃t@CSĂ̕R[h $code BOMtUTF-8ϊ܂H" \
		 question 0 yes no]
    if {[string equal "0" $ret]} {
	set files 0; set success 0; set failed 0; set outside 0; # 
	set msg "ł"; update
	expandPath $path $code fromUTF8
	tk_dialog .d "s" \
	    "$files ̑Ώۃt@Ĉ $success ̃t@C̏ɐA $failed ̏ɎsA$outside ͑ΏۊOłB" info 0 ok 
    }
    set msg {ΏۃpXw肵ĉ}
}
pack .f2.l -side left -fill y -expand true
pack .f2.cm -side left -fill both -expand true
pack .f2.exec1 .f2.exec2 -side top -fill y -expand true
button .exit -text "I" -command {exit}

pack .l -fill both -expand true
pack .f1 .f2 -fill x -expand true 
pack .exit -fill x -expand true

encoding system utf-8

