// -*- mode: C++ -*-
#ifndef MiX_ATTRMAP_H_
#define MiX_ATTRMAP_H_

#include <vector>
#include "XMLString.h"
#include "misc.h"

namespace MiX{
  template <class charT,class char_traits,class xml_traits>
  class AttrMap {
  public:
    MiX_Template_Typedef(charT,char_traits,xml_traits);
    typedef std::pair<string_type,string_type> val_type;
    typedef std::vector<val_type> container_type;
    typedef typename container_type::iterator iterator;
    typedef typename container_type::const_iterator const_iterator;
  private:
    container_type impl_;
    struct search_by_key{
      string_type key_;
      search_by_key(const string_type& key) : key_(key) { };
      bool operator()(const val_type& v){ return v.first==key_; }
    };

  public:
    /// RXgN^
    AttrMap(){ impl_.clear(); }
    /// Rei̍ŏ̗vfCe[^𓾂
    iterator begin() { return impl_.begin(); }
    /// Rei̍Ō̗vf̈Ce[^𓾂
    iterator end() { return impl_.end(); }
    /// Rei̍ŏ̗vfCe[^𓾂(const)
    const_iterator begin()const{ return impl_.begin(); }
    /// Rei̍Ō̗vf̈Ce[^𓾂(const)
    const_iterator end()const{ return impl_.end(); }
    /// ReiɊi[Ăvf𓾂
    size_t size()const{ return impl_.size(); }
    /// Rei󂩂ǂ𓾂
    bool empty()const{ return impl_.empty(); }
    /// Reiɒlǉ
    void insert(const val_type& data){ impl_.push_back(data); }
    /// Reiɂ
    void clear(){ impl_.clear(); }
    /// keyɂėvfCe[^Ԃ
    iterator find(const string_type& key){ 
      return find_if(begin(),end(),search_by_key(key));
    }
    /// keyɂėvfCe[^Ԃ(const)
    const_iterator find(const string_type key)const{ 
      return find_if(begin(),end(),search_by_key(key));
    }
    /// keyɂĎvf폜
    void erase(const string_type key){
      iterator it = find(key);
      if(it!=end()) impl_.erase(it);
    }
    /// keyɂĎvf̒l𓾂
    string_type operator[](const string_type& key) const;
  };
}

#ifndef MiX_ATTRMAP_CPP_
#include "AttrMap.cpp"
#endif

#endif
