// -*- mode: c++ -*-

#ifndef MiX_NODECONTAINER_H_
#define MiX_NODECONTAINER_H_

#include "NodeList.h"
#include "Node.h"

namespace MiX{

  template <class charT,class char_traits,class xml_traits>
  class NodeContainer : virtual public Node<charT,char_traits,xml_traits>{
  public:
    MiX_Template_Typedef(charT,char_traits,xml_traits);
    typedef NodeContainer<charT,char_traits,xml_traits> this_type;
  protected:
    nodelist_type children_;
    void addChild(node_type* node);

    std::map<string_type,string_type> name_to_url_;

    void cloneChildren(this_type& dest) const{
      typename nodelist_type::const_iterator it = getChildren().begin();
      typename nodelist_type::const_iterator last = getChildren().end();
      for( ; it!=last ; ++it ){
	(*it)->clone(dest,dest.getChildren().end());
      }
    }

  protected:
    ///RXgN^
    NodeContainer() : node_type(),children_() { };
    /**
     * Rs[RXgN^
     *
     * NCAg͂ĂяoȂB܂Rs[łȂB
     */
    NodeContainer(const this_type& src){ };
    /// 
    template <class Pred>
    typename nodelist_type::iterator search(Pred pred,int index){
      int i = 0;
      typename nodelist_type::iterator it,first,last=getChildren().end();
      for ( first=getChildren().begin(); it!=last ; first=++it,++i ){
	it = std::find_if(first,last,pred);
	if( i==index ) break;
      }
      return it;
    }
  public:
    ///fXgN^
    virtual ~NodeContainer() throw();
    ///qm[h̃Xgւ̎QƂ𓾂܂
    nodelist_type& getChildren(){ return children_; };
    ///qm[h̃Xgւ̎QƂ𓾂܂(const)
    const nodelist_type& getChildren() const { return children_; };

    ///Agr[g݂邩ǂ
    bool hasAttribute(const string_type& nm);
    ///Agr[g݂邩ǂ
    bool hasAttribute(const string_type& nm,const string_type& ns);
    ///qAgr[g𓾂܂
    attribute_type& getAttribute(const string_type& nm,const string_type& ns);
    ///qAgr[g𓾂܂
   attribute_type& getAttribute(const string_type& nm);
    ///qGg𓾂܂
    element_type& getElement(const string_type& name,int index);
    ///qGg𓾂܂
    element_type& getElement(const string_type& name,const string_type& ns,int index);
    
    /**
     * w肵OqGgAXgԂ܂
     *
     * \param tagname ^O
     */
    nodelist_type getElementsByTagName(const string_type& tagname,const string_type& ns = string_type() );

    /// OURLɖOݒ肵܂
    void addNSName(const string_type& name,const string_type& url) {
      name_to_url_.insert(make_pair(name,url));
    }
    /// OURL𓾂܂B
    string_type queryURL(const string_type& name) const;
    /// URL疼O𓾂܂B
    string_type queryNSName(const string_type& url) const;
    
    friend class DOM_Parser<charT,char_traits,xml_traits>;
  };
}

#ifndef MiX_NODECONTAINER_CPP_
#include "NodeContainer.cpp"
#endif

#endif
