//CUPPA:include=+
#include "../src/MiX/AttrMap.h"
//CUPPA:include=-
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestAssert.h>

//CUPPA:namespace=+
//CUPPA:namespace=-

class AttrMapTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(AttrMapTest);
//CUPPA:suite=+
  CPPUNIT_TEST(testInit);
  CPPUNIT_TEST(testOperation);
  CPPUNIT_TEST(testIterator);
//CUPPA:suite=-
  CPPUNIT_TEST_SUITE_END();
private:

  // your stuff...

public:

  virtual void setUp() { /* initialize */ }
  virtual void tearDown() { /* terminate */ }

//CUPPA:decl=+
  void testInit() {
    MiX::AttrMap<char> atts;
    CPPUNIT_ASSERT(atts.empty());
    CPPUNIT_ASSERT(atts.size()==0); 
  }
  void testOperation() {
    MiX::AttrMap<char> atts;
    atts.insert(MiX::AttrMap<char>::val_type("key1","val1"));
    atts.insert(MiX::AttrMap<char>::val_type("key2","val2"));
    atts.insert(MiX::AttrMap<char>::val_type("key3","val3"));
    CPPUNIT_ASSERT(atts.size()==3);
    CPPUNIT_ASSERT(atts["key1"]=="val1");
    CPPUNIT_ASSERT(atts["key2"]=="val2");
    CPPUNIT_ASSERT(atts["key3"]=="val3");
  }
  void testIterator() {
    MiX::AttrMap<char> atts;
    atts.insert(MiX::AttrMap<char>::val_type("key1","val1"));
    atts.insert(MiX::AttrMap<char>::val_type("key2","val2"));
    atts.insert(MiX::AttrMap<char>::val_type("key3","val3"));
    MiX::AttrMap<char>::iterator it = atts.begin();
    MiX::AttrMap<char>::iterator last = atts.end(); 
    CPPUNIT_ASSERT_EQUAL(3,(last-it));
    CPPUNIT_ASSERT(it->second=="val1");++it;
    CPPUNIT_ASSERT(it->second=="val2");++it;
    CPPUNIT_ASSERT(it->second=="val3");++it;
  }
//CUPPA:decl=-
};

//CUPPA:impl=+
//CUPPA:impl=-

CPPUNIT_TEST_SUITE_REGISTRATION(AttrMapTest);
