#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# HTMLのbody部を受け取り
# S5(A Simple Standards-Based Slide Show System)
# 形式に整形する。
# 

import xml.dom.minidom
from make_mm_dom import make_mm_dom
from notation3ToRDF import notation3ToRDF

head1 = '''<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1 plus MathML 2.0 plus SVG 1.1//EN"
 "http://www.w3.org/2002/04/xhtml-math-svg/xhtml-math-svg.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>[slide show title here]</title>
<!-- metadata -->
<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
<meta name="generator" content="S5" />
<meta name="version" content="S5 1.1" />
<meta name="presdate" content="20050728" />
<meta name="author" content="Eric A. Meyer" />
<meta name="company" content="Complex Spiral Consulting" />
<!-- configuration parameters -->
<meta name="defaultView" content="slideshow" />
<meta name="controlVis" content="hidden" />
<!-- style sheet links -->
<link rel="stylesheet" href="s5ui/default/slides.css" type="text/css" media="projection" id="slideProj" />
<link rel="stylesheet" href="s5ui/default/outline.css" type="text/css" media="screen" id="outlineStyle" />
<link rel="stylesheet" href="s5ui/default/print.css" type="text/css" media="print" id="slidePrint" />
<link rel="stylesheet" href="s5ui/default/opera.css" type="text/css" media="projection" id="operaFix" />
<!-- S5 JS -->
<script src="s5ui/default/slides.js" type="text/javascript"></script>
'''

head2 = '''
</head>
<body>

<div class="layout">
<div id="controls"><!-- DO NOT EDIT --></div>
<div id="currentSlide"><!-- DO NOT EDIT --></div>
<div id="header"></div>
<div id="footer">
<h1>[location/date of presentation]</h1>
<h2>[slide show title here]</h2>
</div>
</div>

'''

tail = '''</body>
</html>
'''

def isH1(n):
    if n.nodeType == xml.dom.minidom.Node.ELEMENT_NODE:
        if n.tagName == 'h1':
            return True
        else:
            return False
    else:
        return False

def addDiv(nodes,retDoc):
    if isH1(nodes[0]):
        div = retDoc.createElement('div')
        div.setAttribute('class','slide')
        for n in nodes:
            div.appendChild(n)
        retDoc.documentElement.appendChild(div)
    else:
        for n in nodes:
            retDoc.documentElement.appendChild(n)

def packSlide(body):
    doc = make_mm_dom(body)
    topLevelNode = doc.documentElement.firstChild.firstChild

    domImpl = xml.dom.minidom.getDOMImplementation()
    retDoc = domImpl.createDocument(None, "retBody", None)

    nodes = []
    while (topLevelNode):
        if isH1(topLevelNode):
            addDiv(nodes,retDoc)
            nodes = [topLevelNode]
        else:
            nodes.append(topLevelNode)
        topLevelNode = topLevelNode.nextSibling
    addDiv(nodes,retDoc)

    ret = ''
    topLevelNode = retDoc.documentElement.firstChild
    while (topLevelNode):
        ret = ret + topLevelNode.toxml('UTF-8')
        topLevelNode = topLevelNode.nextSibling

    doc.unlink()
    retDoc.unlink()

    return ret


# これがメインの変換関数
# 現在エンティティの処理が上手くいかないので、
# ヘナチョコなプログラムになっている。
def transToS5(inText, headers):
    inText = inText.replace('&','＆')
    inText = packSlide(inText)
    inText = inText.replace('＆','&')
    inText = inText.replace('&amp;gt;','>')
    inText = inText.replace('&amp;quot;','"')
    #inText = inText.replace('&amp;apos;',"'")
    if headers.has_key('notation3'):
        rdf = notation3ToRDF(headers['notation3'])
        return head1 + rdf + head2 + inText + tail
    else:
        return head1 + head2 + inText + tail

def transToS5Body(inText, headers):
    inText = inText.replace('&','＆')
    inText = packSlide(inText)
    inText = inText.replace('＆','&')
    inText = inText.replace('&amp;gt;','>')
    inText = inText.replace('&amp;quot;','"')
    #inText = inText.replace('&amp;apos;',"'")
    return inText
