#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# HTMLのbody部を受け取り
# headerとかを付けて整形する。
# 

from notation3ToRDF import notation3ToRDF

headXHTML1 = '''<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1 plus MathML 2.0 plus SVG 1.1//EN"
    "http://www.w3.org/2002/04/xhtml-math-svg/xhtml-math-svg.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="jp" lang="jp">
<head>
<meta http-equiv="Content-Type" content="application/xhtml+xml; charset=UTF-8" />
'''

headXHTML2 = '''</head>
<body>
'''


tailXHTML = '''</body>
</html>
'''


# これがメインの変換関数
def transToXHTML(inText, headers):
    result = headXHTML1
    if headers.has_key('title'):
        result = result + ('<title>%s</title>\n' % headers['title'])
    if headers.has_key('css'):
        css = headers['css'].split('\n')
        for c in css:
            c = c.strip()
            result = result + ('<link rel="stylesheet" type="text/css" href="%s" />\n' % c)
    if headers.has_key('notation3'):
        rdf = notation3ToRDF(headers['notation3'])
        result = result + rdf
    result = result + headXHTML2
    result = result + inText
    result = result + tailXHTML
    return result
