#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# XHTMLのbody部を受け取り
# いろんな処理を行う．
# 
# DOMのパーサのデフォルトの動作により
# プロパティエンティティに対して余計な
# 展開や変換が行われるのでヘナチョコな方法で対処する。
# 
# (2006,11/05)とりあえず、今のところ
# idとclass属性の処理だけ入れている。
# 
# (2008,01/18) <p>要素中のテキストノードで改行があり，
# かつ改行の前後が日本語ならば改行を削除する処理を入れた．
# 

from xml.dom.minidom import *
from make_mm_dom import make_mm_dom
import re


#他でも使うのでDOMのDocumentオブジェクトをグローバル
#変数に入れとくことにする。
doc = None

#外から呼び出すのはこのメソッドだけということに
#なると思う。XHTMLのbodyの文字列を受けとり
#さまざまなDOM処理を行う。
#現在、エンティティの処理方法が上手くコントロール
#できないので、ヘナチョコなプログラムになっている。
#つまり、エンティティをエンティティでなくしてしまって
#処理して、後で戻している。ヘナチョコな所にヘナチョコ印
#を付けておく。
def mmPostProcess(body):
    body = body.replace('&',u'＆') #ヘナチョコ印

    global doc
    doc = make_mm_dom(body.encode("utf-8"))
    #doc.documentElement.firstChild.normalize()

    nodes = doc.documentElement.firstChild.childNodes
    for n in nodes:
        traverse(n)

    ret = ''
    nodes = doc.documentElement.firstChild.childNodes
    for n in nodes:
        ret = ret + n.toxml('UTF-8')

    doc.unlink()

    ret = ret.replace('＆','&')         #ヘナチョコ印
    ret = ret.replace('&amp;gt;','>')   #ヘナチョコ印
    ret = ret.replace('&amp;quot;','"') #ヘナチョコ印
    #ret = ret.replace('&amp;apos;',"'") #ヘナチョコ印

    return ret

#「@(...)」の形式にマッチしたもが見付かった時に
#呼び出される。グローバル変数のdocとcurrentElement
#を利用しつつ処理を行う。とりあえずdiとclass属性
#の処理だけ書いてある。
def atMatch(m):
    global doc
    global currentElement
    s = m.group(1),
    ss = s[0].split(',')
    if ss[0]=='id':
        n = currentElement
        n.setAttribute('id',ss[1])
    elif ss[0]=='id1':
        n = currentElement
        n = n.parentNode
        n.setAttribute('id',ss[1])
    elif ss[0]=='id2':
        n = currentElement
        n = n.parentNode
        n = n.parentNode
        n.setAttribute('id',ss[1])
    elif ss[0]=='id3':
        n = currentElement
        n = n.parentNode
        n = n.parentNode
        n = n.parentNode
        n.setAttribute('id',ss[1])
    elif ss[0]=='class':
        n = currentElement
        n.setAttribute('class',ss[1])
    elif ss[0]=='class1':
        n = currentElement
        n = n.parentNode
        n.setAttribute('class',ss[1])
    elif ss[0]=='class2':
        n = currentElement
        n = n.parentNode
        n = n.parentNode
        n.setAttribute('class',ss[1])
    elif ss[0]=='class3':
        n = currentElement
        n = n.parentNode
        n = n.parentNode
        n = n.parentNode
        n.setAttribute('class',ss[1])
    return ''

p = re.compile(u"@\\((.*?)\\)")
j=u"([\u3000-\u30ff\u4e00-\u9fff\u3400-\u4dbf\uff0c\uff0e])"
pp = re.compile(j+u"\n"+j)

currentElement = None

#再帰的に木を探索し処理するためのメソッド。
#今のところ、テキストノードが見つかったら
#その中の「@(...)」を処理させているだけ。
#ただ、例外的に<img>要素のalt属性も
#処理する。
def traverse(n):
    global doc
    global currentElement
    if n.nodeType == Node.ELEMENT_NODE:
        currentElement = n
        if n.localName=="img":
            s = n.getAttribute('alt')
            s = p.sub(atMatch,s)
            n.setAttribute('alt',s)
        else:
            for nn in n.childNodes:
                traverse(nn)
    elif n.nodeType == Node.TEXT_NODE:
        #s = n.toxml('UTF-8')
        s = n.toxml()
        s = p.sub(atMatch,s)

        #<p>要素中のテキストノードで改行があり，
        #かつ改行の前後が日本語ならば改行を削除する
        if n.parentNode.nodeType == Node.ELEMENT_NODE:
            if n.parentNode.localName=="p":
                s = pp.sub(u"\\1\\2",s)

        nn = doc.createTextNode(s)
        n.parentNode.replaceChild(nn,n)
