# -*- coding: utf-8 -*-
from Globals import package_home
from Products.CMFCore import utils, DirectoryView
from Products.Archetypes.public import *
from Products.Archetypes import listTypes
from Products.Archetypes.utils import capitalize

# plone3.0から変ったみたい．
try:
    #plone2.5まで
    from Products.CMFCore import CMFCorePermissions
    from Products.CMFPlone.PloneUtilities import ToolInit
except ImportError:
    #plone3.0から
    from Products.CMFCore import permissions as CMFCorePermissions
    from Products.CMFPlone.utils import ToolInit

import os, os.path, sys, content

# Module aliases - we don't always get it right on the first try, but and we
# can't move modules around because things are stored in the ZODB with the
# full module path. However, we can create aliases for backwards compatability.

sys.modules['Products.MixedMark.MixedMark'] = content.mixedmark


# Get configuration data, permissions
from Products.MixedMark.config import *

# Register skin directories so they can be added to portal_skins
DirectoryView.registerDirectory('skins', product_globals)
DirectoryView.registerDirectory('skins/MixedMark', product_globals)

def initialize(context):

    # Import the type, which results in registerType() being called
    from content import MixedMark

    # initialize the content, including types and add permissions
    content_types, constructors, ftis = process_types(
        listTypes(PROJECTNAME),
        PROJECTNAME)

    utils.ContentInit(
        PROJECTNAME + ' Content',
        content_types      = content_types,
        permission         = DEFAULT_ADD_CONTENT_PERMISSION,
        extra_constructors = constructors,
        fti                = ftis,
        ).initialize(context)
