# -*- coding: utf-8 -*-
"""PGraphviz"""

__author__  = 'Kenji Saito <ksaito@do-johodai.ac.jp>'
#__docformat__ = 'plaintext'

from AccessControl import ClassSecurityInfo

try:
  from Products.LinguaPlone.public import *
except ImportError:
  # No multilingual support
  from Products.Archetypes.public import *

from Products.PGraphviz.interfaces import IPGraphviz

from Products.ATContentTypes.content.document import ATDocument
from Products.ATContentTypes.content.document import finalizeATCTSchema

from Products.Archetypes.Marshall import RFC822Marshaller
import os, string

from Products.PageTemplates.PageTemplateFile import PageTemplateFile

# Copy the ATDocument schema (to avoid modifying the original) and append our
# own fields for the images and attachments manager widgets.
PGraphvizSchema = ATDocument.schema.copy() + Schema((
        TextField('text',
                  searchable=1,
                  required=1,
                  primary=1,
                  widget=TextAreaWidget(label='Body',rows=30),
                  ),
    ),
    marshall=RFC822Marshaller(),
    )

# Finalise the schema according to ATContentTypes standards. This basically
# moves the Related items and Allow discussion fields to the bottom of the
# form. See ATContentTypes.content.schemata for details.
finalizeATCTSchema(PGraphvizSchema)

graphvizCommand = 'dot '
graphvizFont = ''
if os.name == 'nt':
    graphvizFont = '-Gfontname="MSGOTHIC.TTC" -Nfontname="MSGOTHIC.TTC" -Efontname="MSGOTHIC.TTC" '
elif os.name == 'mac':
    graphvizFont = '-Gfontname="HiraMaruPro-W4" -Nfontname="HiraMaruPro-W4" -Efontname="HiraMaruPro-W4" '
elif os.name == 'posix':
    graphvizFont = '-Gfontname="san serif" -Nfontname="san serif" -Efontname="san serif" '

class PGraphviz(ATDocument):
    """
    PGraphviz
    """

    # Standard content type setup
    portal_type = meta_type = 'PGraphviz'
    archetype_name = 'PGraphviz'
    #content_icon = 'RichDocument.gif'
    schema = PGraphvizSchema
    typeDescription= 'PGraphviz'
    typeDescMsgId  = 'PGraphviz'

    # Set up our views - these are available from the 'display' menu
    default_view = 'default_pgraphviz_view'
    immediate_view = 'default_pgraphviz_view'
    suppl_views = ()

    # Make sure we get title-to-id generation when an object is created
    _at_rename_after_creation = True

    # Make sure we get all the interface declarations from ATDocument,
    # which includes support for ISelectableBrowserDefault to get the
    # 'display' menu to work, IHistoryAware and other standard interfaces.
    # In addition, add INonStructuralFolder to tell Plone that even though
    # this type is technically a folder, it should be treated as a standard
    # content type. This ensures the user doesn't perceive a RichDocument as
    # a folder.
    __implements__ = ATDocument.__implements__ + \
                     (IPGraphviz,)

    # Get the standard actions (tabs)
    actions = ATDocument.actions
    #actions = ({
    #    'id': 'view',
    #    'name': 'View',
    #    'action': 'string:${object_url}/graphviz_view',
    #    'permissions': (CMFCorePermissions.View,)
    #    },)

    # This method, from ISelectableBrowserDefault, is used to check whether
    # the "Choose content item to use as deafult view" option will be 
    # presented. This makes sense for folders, but not for RichDocument, so
    # always disallow
    def canSetDefaultPage(self):
        return False

    # enable FTP/WebDAV and friends
    PUT = ATDocument.PUT

    outputPage = PageTemplateFile('../skins/PGraphviz/pgraphviz_view.pt', globals())

    def CookedBody(self, stx_level=None, setlevel=0):
        mm = self.getRawText()
        mm = '<pre>' + mm + '</pre>'
        return mm

    def default_pgraphviz_view(self):
        """
        default_pgraphviz_view
        """
        RESPONSE = self.REQUEST.response
        if self.REQUEST.has_key('format'):
            t = self.REQUEST['format']
            ext = '-Tpng '
            mimetype = 'image/png'
            if t == 'svg':
                ext = '-Tsvg '
                mimetype = 'image/svg+xml'
            elif t == 'jpg':
                ext = '-Tjpg '
                mimetype = 'image/jpeg'
            commandLine = graphvizCommand + graphvizFont + ext
            input, output = os.popen2(commandLine)
            input.write(self.getRawText())
            input.close()
            mm = output.read()
            RESPONSE.appendHeader("Content-type", mimetype)
            return mm
        else:
            RESPONSE.appendHeader("Content-type", "text/html")
            return self.outputPage.render()

registerType(PGraphviz)
