# -*- coding: utf-8 -*-
"""PGnuplot"""

__author__  = 'Kenji Saito <ksaito@do-johodai.ac.jp>'
#__docformat__ = 'plaintext'

from AccessControl import ClassSecurityInfo

try:
  from Products.LinguaPlone.public import *
except ImportError:
  # No multilingual support
  from Products.Archetypes.public import *

from Products.PGnuplot.interfaces import IPGnuplot

from Products.ATContentTypes.content.document import ATDocument
from Products.ATContentTypes.content.document import finalizeATCTSchema

from Products.Archetypes.Marshall import RFC822Marshaller
import os, string, re

from Products.PageTemplates.PageTemplateFile import PageTemplateFile

# Copy the ATDocument schema (to avoid modifying the original) and append our
# own fields for the images and attachments manager widgets.
PGnuplotSchema = ATDocument.schema.copy() + Schema((
        TextField('text',
                  searchable=1,
                  required=1,
                  primary=1,
                  widget=TextAreaWidget(label='Body',rows=30),
                  ),
    ),
    marshall=RFC822Marshaller(),
    )

# Finalise the schema according to ATContentTypes standards. This basically
# moves the Related items and Allow discussion fields to the bottom of the
# form. See ATContentTypes.content.schemata for details.
finalizeATCTSchema(PGnuplotSchema)

gnuplotCommand = ''
gnuplotFont = ''
if os.name == 'nt':
    gnuplotCommand = 'pgnuplot -'
    gnuplotFont = 'msgothic'
elif os.name == 'mac':
    gnuplotCommand = 'gnuplot -'
    gnuplotFont = 'HiraMaruPro-W4'
elif os.name == 'posix':
    gnuplotCommand = 'gnuplot -'
    gnuplotFont = '/usr/share/fonts/truetype/ttf-ipafonts/ipag.ttf'

class PGnuplot(ATDocument):
    """
    PGnuplot
    """

    # Standard content type setup
    portal_type = meta_type = 'PGnuplot'
    archetype_name = 'PGnuplot'
    #content_icon = 'RichDocument.gif'
    schema = PGnuplotSchema
    typeDescription= 'PGnuplot'
    typeDescMsgId  = 'PGnuplot'

    # Set up our views - these are available from the 'display' menu
    default_view = 'default_pgnuplot_view'
    immediate_view = 'default_pgnuplot_view'
    suppl_views = ()

    # Make sure we get title-to-id generation when an object is created
    _at_rename_after_creation = True

    # Make sure we get all the interface declarations from ATDocument,
    # which includes support for ISelectableBrowserDefault to get the
    # 'display' menu to work, IHistoryAware and other standard interfaces.
    # In addition, add INonStructuralFolder to tell Plone that even though
    # this type is technically a folder, it should be treated as a standard
    # content type. This ensures the user doesn't perceive a RichDocument as
    # a folder.
    __implements__ = ATDocument.__implements__ + \
                     (IPGnuplot,)

    # Get the standard actions (tabs)
    actions = ATDocument.actions
    #actions = ({
    #    'id': 'view',
    #    'name': 'View',
    #    'action': 'string:${object_url}/pgnuplot_view',
    #    'permissions': (CMFCorePermissions.View,)
    #    },)

    # This method, from ISelectableBrowserDefault, is used to check whether
    # the "Choose content item to use as deafult view" option will be 
    # presented. This makes sense for folders, but not for RichDocument, so
    # always disallow
    def canSetDefaultPage(self):
        return False

    # enable FTP/WebDAV and friends
    PUT = ATDocument.PUT

    outputPage = PageTemplateFile('../skins/PGnuplot/pgnuplot_view.pt', globals())

    def CookedBody(self, stx_level=None, setlevel=0):
        mm = self.getRawText()
        mm = '<pre>' + mm + '</pre>'
        return mm

    def default_pgnuplot_view(self):
        """
        default_pgnuplot_view
        """
        RESPONSE = self.REQUEST.response
        if self.REQUEST.has_key('format'):
            t = self.REQUEST['format']
            terminal = 'set terminal png font "'+gnuplotFont+"\"\n"
            mimetype = 'image/png'
            if t == 'svg':
                terminal = "set terminal svg\n"
                mimetype = 'image/svg+xml'
            elif t == 'jpg':
                terminal = 'set terminal jpeg font "'+gnuplotFont+"\"\n"
                mimetype = 'image/jpeg'
            commandLine = gnuplotCommand
            input, output = os.popen2(commandLine)
            input.write(terminal)
            input.write(self.getRawText())
            input.write("\n")
            input.close()
            mm = output.read()
            RESPONSE.appendHeader("Content-type", mimetype)
            if mimetype == 'image/svg+xml':
                mm = self.fixSVG(mm)
            return mm
        else:
            RESPONSE.appendHeader("Content-type", "text/html")
            return self.outputPage.render()

    #gnuplotの出すsvgはデフォルトネームスペースの設定が
    #無いので，とりあえず場当たり的な方法で対処
    def fixSVG(self,mm):
        p = re.compile('<svg')
        mm = p.sub('<svg xmlns="http://www.w3.org/2000/svg"',mm,1)
        return mm

registerType(PGnuplot)
