#!/usr/bin/python
# -*- coding: utf-8 -*-

from Products.Archetypes.public import BaseFolderSchema

from Globals import InitializeClass
from OFS.SimpleItem import SimpleItem
from AccessControl import ClassSecurityInfo

from Products.CMFCore.utils import UniqueObject, getToolByName
from Products.PageTemplates.PageTemplateFile import PageTemplateFile

from config import view_permission, product_name, type_id
from config import mod_permission

from DateTime import DateTime
import string

#----------------------------------------------------------------------

# まず，ATCTContentとATFolderを拡張しておく
# でATCTContent
from Products.ATContentTypes.content.base import ATCTContent

def mySetModificationDate(self,dt):
    setModificationDateOrg(self,dt)
    print 'mySetModificationDate(gaha)\n'

setModificationDateOrg = ATCTContent.setModificationDate
ATCTContent.setModificationDate = mySetModificationDate

#----------------------------------------------------------------------
# 次ATFolder
from Products.ATContentTypes.content.folder import ATFolder

#ファイルを削除するメソッドをオーバライド。
#その際に、.pscファイルの中に削除されたファイルの
#ファイル名と削除時間のリストを保存する。
#
#ただし、一回削除されたファイルがもう一度追加されて
#復活した場合、それが起ったことをどうやって検知するか
#わからなかった。そういう理由で、.pscファイルの中身は
#厳密には削除されているファイルのリストにはならない。
#そのへんはPloneSyncツールのほうで対応させることにする。
def myManage_delObjects(self,delFiles):
    ss = getRemovedFileList(self)
    dt = DateTime()
    for d in delFiles:
        ss.append(d + '/' + (str(long(dt)*1000)))
    #実際の削除
    manage_delObjectsOrg(self,delFiles)
    #実在するファイルをリストから削除
    sss = []
    ids = self.objectIds()
    for s in ss:
        b = True
        for i in ids:
            if string.find(s,i)==0: # <-- 一致した場合
                b = False
        if b:
            sss.append(s)
    #重複を削除(古いほう削除)
    ss = []
    for s1 in sss:
        s11 = string.split(s1,'/')
        b = True # s1を残すべき:True、その逆:False
        for s2 in sss:
            s22 = string.split(s2,'/')
            if s11[0] == s22[0]:
                if s11[1] < s22[1]:
                    b = False
                    break
        if b:
            ss.append(s1)

    setRemovedFileList(self,ss)

#以下内部で使ってるサブメソッド

# 削除ファイルのリストを.pscファイルからゲット。
# 返えされる値はファイル名と削除時間(Long)を「/」で
# 区切ったもののリスト。
def getRemovedFileList(self):
    try:
        dot_psc = self['.psc']
        if not dot_psc:
            return []
        ssTmp = string.split(dot_psc.data,'\n')
        ss = []
        for s in ssTmp:
            if s != '':
                ss.append(s)
        return ss
    except:
        return []
    return[]

# 削除ファイルのリストを.pscファイルにセット。
# dFilesにはファイル名と削除時間(Long)を「/」で区切ったものの
# リストをわたすこと。
def setRemovedFileList(self,dFiles):
    try:
        dot_psc = self['.psc']
        if not dot_psc:
            self.manage_addFile('.psc','','.psc','','plane/text')
            dot_psc = self['.psc']
    except:
        self.manage_addFile('.psc','','.psc','','plane/text')
        dot_psc = self['.psc']
    list = ''
    for f in dFiles:
        list = list + f + '\n'
    dot_psc.data = list

manage_delObjectsOrg = ATFolder.manage_delObjects
ATFolder.manage_delObjects = myManage_delObjects

######################################################################
# ここからツールのプログラム
######################################################################

def addPloneSync(self,REQUEST=None):
    """ Add a link checker in """
    ps=PloneSync()
    self._setObject(type_id,ps)

class PloneSync(UniqueObject,  SimpleItem):
    """ change last modified time of contents. and some utility """
    meta_type = product_name
    id = type_id

    security = ClassSecurityInfo()
    outputPage = PageTemplateFile('www/output.pt', globals())

    manage_options = (
        {'label':'output', 'action':'outputPage'},
        ) + SimpleItem.manage_options

    #テスト用のメソッド
    #このスクリプトにアクセスしているユーザをゲットする
    #方法は適当。これで正しいのか確認すること。
    #content.acquiredRolesAreUsedBy()の意味がわからない。
    security.declareProtected(view_permission, 'test')
    def test(self):
        """ test method """
        ss = ''

        #実際に操作したいコンテンツをゲットする
        content = self.getParentNode()
        #このスクリプトにアクセスしているユーザをゲットする
        user = self.REQUEST['AUTHENTICATED_USER']
        #pm = getToolByName(self,'portal_membership')
        #user = pm.getMemberById(userID)
        #ユーザのcontentに対するロールをゲットする
        userRoles = user.getRolesInContext(content)
        #HTTPリクエストから更新時間をゲットする
        #リクエストの名前は「modTime」とする。
        if self.REQUEST.has_key('modTime'):
            modTime = self.REQUEST['modTime']
        else:
            modTime = None
        #contentのroles?
        roles = content.rolesOfPermission(mod_permission)
        #contentの獲得？
        a = content.acquiredRolesAreUsedBy(mod_permission)
        #content.setModificationDate()
        t = content.ModificationDate()

        #実際に権限があるかどうか
        permi = False
        if a:
            permi = True
        else:
            for p in roles:
                if p['selected']:
                    if p['name'] in userRoles:
                        permi = True

        ss = ss + 'content:%s\n' % str(content)
        ss = ss + 'user:%s\n' % str(user)
        ss = ss + 'userRoles:%s\n' % str(userRoles)
        ss = ss + 'modTime:%s\n' % str(modTime)
        ss = ss + 'roles:%s\n' % str(roles)
        ss = ss + 'a:%s\n' % str(a)
        ss = ss + 't:%s\n' % str(t)
        ss = ss + 'permi:%s\n' % str(permi)

        #以下調べ物用のコード
        #for d in self.REQUEST.keys():
        #    ss = ss + '%s \n' % str(d)
        #for d in dir(content):
        #    ss = ss + '%s \n' % str(d)
        #for d in dir(self):
        #    ss = ss + '%s \n' % str(d)
        #for d in globals():
        #    ss = ss + '%s \n' % str(d)

        return + ss

    #pathを引数で指定してコンテンツを取り出す
    def getContentByPath(self,contentPath):
        if contentPath.startswith('/'):
            contentPath = contentPath[1:]
        if contentPath.endswith('/'):
            contentPath = contentPath[:-1]
        pu = getToolByName(self,'portal_url')
        content = pu.getPortalObject()
        for p in string.split(contentPath,'/'):
            for c in content.getChildNodes():
                if p == c.id:
                    content = c
                    break
            else:
                content = None
                break
        return content

    #pathリクエストのコンテンツを取り出す
    def getRequestedContent(self):
        if not self.REQUEST.has_key('path'):
            return None
        contentPath = self.REQUEST['path']
        return self.getContentByPath(contentPath)

    #pathリクエストが示すコンテンツの親と
    #pathリクエストが示すコンテンツのIdを返す
    #親が無い場合はNoneを返えす。
    #このメソッドちょっと問題ありで、path=/testのような場合、
    #つまりルートのすぐ下のコンテンツをpathに指定された時、
    #親はploneのルートになるべきなのだが、これが上手く取得
    #できない。後で直すべし。
    def getParentAndContentId(self):
        if not self.REQUEST.has_key('path'):
            return (None,None)
        contentPath = self.REQUEST['path']
        if contentPath.endswith('/'):
            contentPath = contentPath[:-1]
        parentPath = contentPath[:string.rfind(contentPath,'/')]
        contentId = contentPath[string.rfind(contentPath,'/')+1:]
        if parentPath == "":
            pu = getToolByName(self,'portal_url')
            p = pu.getPortalObject()
        else:
            p = self.getContentByPath(parentPath)
        return (p,contentId)

    #hasPermission_USERのuser省略版
    def hasPermission(self,content,permission):
        user = self.REQUEST['AUTHENTICATED_USER']
        return self.hasPermission_USER(user,content,permission)

    #userがcontentにpermissionする権限があるかどうか
    #True,Falseで返す。
    def hasPermission_USER(self,user,content,permission):
        userRoles = user.getRolesInContext(content)
        roles = content.rolesOfPermission(permission)
        a = content.acquiredRolesAreUsedBy(permission)
        permi = False
        if a:
            permi = True
        else:
            for p in roles:
                if p['selected']:
                    if p['name'] in userRoles:
                        permi = True
        return permi

    #contentにpermissionする権限があるかどうか
    #True,Falseで返す。これはportal_membershipツールを
    #使った実装だが、上手く動作してないっぽい。
    #なにか勘違いしているのかも。でも、参考のため残しておく。
    def hasPermission_BAK(self,content,permission):
        mt = getToolByName(self,'portal_membership')
        if mt.checkPermission(permission,content):
            return True
        else:
            return False

    #ファイルが存在してるかどうかのチェックをする関数
    #http://foo.com/plone/plone_sync/exists?path=/some/path
    #という感じで使う
    security.declareProtected(view_permission, 'exists')
    def exists(self):
        """ exists method """
        (parent,dirName) = self.getParentAndContentId()
        if not parent:
            return 'ps_return:error'
        permi = self.hasPermission(parent,view_permission)
        if not permi:
            return 'ps_return:error'
        content = self.getRequestedContent()
        if content:
            return 'ps_return:true'
        else:
            return 'ps_return:false'

    #新しいディレクトリを作成する。
    #作成したいディレクトリの名前は
    #http://foo.com/plone/plone_sync/mkdir?path=/some/path
    #という感じで指定する。
    security.declareProtected(view_permission, 'mkdir')
    def mkdir(self):
        """ mkdir method """
        (parent,dirName) = self.getParentAndContentId()
        if not parent:
            return 'ps_return:error'
        permi = self.hasPermission(parent,mod_permission)
        if not permi:
            return 'ps_return:error'
        try:
            #parent.manage_addPloneFolder(dirName,dirName)
            #parent.manage_addProduct['Folder'].addFolder(dirName)
            parent.invokeFactory("Folder", id=dirName, title=dirName)
            return 'ps_return:true'
        except:
            return 'ps_return:error'

    #ディレクトリ(フォルダ)かどうか確認する。
    #http://foo.com/plone/plone_sync/isDirectory?path=/some/path
    #という感じで使う。
    #フォルダの時はtrueと返し、それ以外はfalseを返す。
    #存在しない場合や権限が無い場合はerrorと返す。
    security.declareProtected(view_permission, 'isDirectory')
    def isDirectory(self):
        """ isDirectory method """
        content = self.getRequestedContent()
        if not content:
            return 'ps_return:error'
        permi = self.hasPermission(content,view_permission)
        if not permi:
            return 'ps_return:error'
        if content.isPrincipiaFolderish:
            return 'ps_return:true'
        else:
            return 'ps_return:false'

    #ファイルかどうか確認する。というよりフォルダでない時には
    #ファイルであると判定することにする。
    #http://foo.com/plone/plone_sync/isFile?path=/some/path
    #という感じで使う。
    #ファイルの時はtrueと返し、それ以外はfalseと返す。
    #エラーの場合はerrorを返す。
    security.declareProtected(view_permission, 'isFile')
    def isFile(self):
        """ isFile method """
        content = self.getRequestedContent()
        if not content:
            return 'ps_return:error'
        permi = self.hasPermission(content,view_permission)
        if not permi:
            return 'ps_return:error'
        if not content.isPrincipiaFolderish:
            return 'ps_return:true'
        else:
            return 'ps_return:false'

    #最終更新時間をlong値で返えす。
    #あっ。ミリ秒だった。面倒なので1000倍する。
    #http://foo.com/plone/plone_sync/lastModified?path=/some/path
    #という感じで使う。
    #エラーなどの場合はerrorと返す。
    security.declareProtected(view_permission, 'lastModified')
    def lastModified(self):
        """ lastModified method """
        content = self.getRequestedContent()
        if not content:
            return 'ps_return:error'
        permi = self.hasPermission(content,view_permission)
        if not permi:
            return 'ps_return:error'
        t = content.ModificationDate()
        dt = DateTime(t)
        return 'ps_return:' + str(long(dt)*1000)

    #最終更新時間をlong値を使って書き換える。GETメソッドで
    #アクセスするならば、
    #http://foo.com/plone/plone_sync/setLastModified?path=/some/path&modTime=1132714962000
    #のような感じで呼出す。
    #あっ。ミリ秒だった。面倒なので1000で割る。
    security.declareProtected(view_permission, 'setLastModified')
    def setLastModified(self):
        """ setLastModified method """
        content = self.getRequestedContent()
        if not content:
            return 'ps_return:error'
        permi = self.hasPermission(content,mod_permission)
        if not permi:
            return 'ps_return:error'
        if not self.REQUEST.has_key('modTime'):
            return 'ps_return:error'
        modTime = self.REQUEST['modTime']
        dt = DateTime(long(modTime)/1000)
        content.setModificationDate(dt)
        return 'ps_return:true'

    #コンテンツの子要素を返す。各要素はスラッシュで
    #区切られる。もし、一つも子要素がなければ
    #「/」と返事をする。いずれにせよ一文字目は「/」となる。
    #http://foo.com/plone/plone_sync/listFiles?path=/some/path
    #という感じで使う。
    #エラーが起きた場合は「error」と返事することにする。
    #よって一文字目(「/」か「e」)でエラーかどうか判定できる。
    security.declareProtected(view_permission, 'listFiles')
    def listFiles(self):
        """ listFiles method """
        content = self.getRequestedContent()
        if not content:
            return 'ps_return:error'
        permi = self.hasPermission(content,view_permission)
        if not permi:
            return 'ps_return:error'
        if not content.isPrincipiaFolderish:
            return 'ps_return:error'
        cns = content.objectValues()
        cns2 = []
        for cn in cns:
            if not self.hasPermission(cn,view_permission):
                continue
            if (cn.getId()=='.psc'):
                continue
            if (cn.getId()=='.wf_policy_config'):
                continue
            if cn.portal_type=='Topic':
                continue
            cns2.append(cn.getId())
        if len(cns2)==0:
            return 'ps_return:/'
        ss = ''
        for cn in cns2:
            ss = ss + '/' + cn
        return 'ps_return:' + ss

    #このツールがインストールされているサイトの現在時刻を
    #lognで返す。同期を取る時、互いのマシンの時刻が合って
    #るかどうか、このメソッドで試す。
    #あっ。ミリ秒だった。面倒なので1000倍する。
    #http://foo.com/plone/plone_sync/siteCurrentTime
    #という感じで使う。
    security.declareProtected(view_permission, 'siteCurrentTime')
    def siteCurrentTime(self):
        """ siteCurrentTime method """
        dt = DateTime()
        return 'ps_return:' + str(long(dt)*1000)

    #plone_syncツールを呼出すための本当の場所を返えす
    #http://foo.com/plone/.../plone_sync/absoluteURLOfPloneSyncTool
    #という感じで使う。「absoluteURLOfPloneSyncTool」の直前までのURLは
    #実在していないとうまく動作しない。
    security.declareProtected(view_permission, 'absoluteURLOfPloneSyncTool')
    def absoluteURLOfPloneSyncTool(self):
        """ absoluteURLOfPloneSyncTool method """
        ps = getToolByName(self,'plone_sync')
        return 'ps_return:' + str(ps.absolute_url())

    #ファイルやディレクトリを削除する。
    #http://foo.com/plone/plone_sync/delete?path=/some/path
    #という感じで指定する。
    #パーミッションの確認が不完全かも？
    security.declareProtected(view_permission, 'delete')
    def delete(self):
        """ delete method """
        (parent,delFile) = self.getParentAndContentId()
        if not parent:
            return 'ps_return:error'
        permi = self.hasPermission(parent,mod_permission)
        if not permi:
            return 'ps_return:error'
        content = self.getRequestedContent()
        if not content:
            return 'ps_return:error'
        permi = self.hasPermission(content,mod_permission)
        if not permi:
            return 'ps_return:error'
        parent.manage_delObjects([delFile])
        return 'ps_return:true'

    #指定したフォルダの中に、以前は存在してたけど今は削除されて
    #しまっているコンテンツの名前のリストを返えす。以下のクエリの
    #pathに指定されるコンテンツはSyncFolderでなければならない。
    #http://foo.com/plone/plone_sync/getRemoved?path=/some/path
    #このメソッドの返事はlistFileと同じ形式とする。
    #エラーの場合は「error」と返す。
    #(.pscファイルの中身には昔削除されたけど、今復活している
    # ファイルが含まれる可能性があるので、そのようなファイルは、
    # このメソッドの中で取り除いてreturnしないといけない。)
    security.declareProtected(view_permission, 'getRemoved')
    def getRemoved(self):
        """ getRemoved method """
        content = self.getRequestedContent()
        if not content:
            return 'ps_return:error'
        permi = self.hasPermission(content,view_permission)
        if not permi:
            return 'ps_return:error'
        dot_psc = None
        os = content.objectValues()
        for o in os:
            if o.getId() == '.psc':
                dot_psc = o
                break
        if not dot_psc:
            return 'ps_return:/'
        ss = string.split(dot_psc.data,'\n')
        sss = []
        ids = content.objectIds()
        for s in ss:
            if s == '':
                continue
            b = True
            for i in ids:
                if s[:string.find(s,'/')] == i:
                    b = False
            if b:
                sss.append(s)
        if len(sss)==0:
            return 'ps_return:/'
        list = ''
        for s in sss:
            list = list + '/' + string.split(s,'/')[0]
        return 'ps_return:' + list

    #以前は存在してたけど、今は削除されてしまっている
    #場合にtrueそれ以外はfalseと返す。指定されたコンテンツの親が
    #SyncFolderでなければ正常に動作しない。
    #http://foo.com/plone/plone_sync/isRemoved?path=/some/path
    #(.pscファイルの中身には昔削除されたけど、今復活している
    # ファイルが含まれる可能性があるので、そのような場合は
    # falseと返事しなければならない。)
    security.declareProtected(view_permission, 'isRemoved')
    def isRemoved(self):
        """ isRemoved method """
        (parent,c) = self.getParentAndContentId()
        content = self.getRequestedContent()
        if not parent:
            return 'ps_return:error'
        if content:
            return 'ps_return:false'
        permi = self.hasPermission(parent,view_permission)
        if not permi:
            return 'ps_return:error'
        dot_psc = None
        os = parent.objectValues()
        for o in os:
            if o.getId() == '.psc':
                dot_psc = o
                break;
        if not dot_psc:
            return 'ps_return:false'
        ss = string.split(dot_psc.data,'\n')
        for s in ss:
            if s == '':
                continue
            if s[:string.find(s,'/')] == c:
                return 'ps_return:true'
        return 'ps_return:false'

    #以前は存在してたけど、今は削除されてしまっている
    #場合に、その削除された時間を返す。指定された情報が無ければ
    #errorを返えす。SyncFolderに保存されたものでなければ正常に動作しない。
    #http://foo.com/plone/plone_sync/getRemovedTime?path=/some/path
    #(.pscファイルの中身には昔削除されたけど、今復活している
    # ファイルが含まれる可能性があるので、そのような場合は
    # errorと返事しなければならない。)
    security.declareProtected(view_permission, 'getRemovedTime')
    def getRemovedTime(self):
        """ getRemovedTime method """
        (parent,c) = self.getParentAndContentId()
        content = self.getRequestedContent()
        if not parent:
            return 'ps_return:error'
        if content:
            return 'ps_return:error'
        permi = self.hasPermission(parent,view_permission)
        if not permi:
            return 'ps_return:error'
        dot_psc = None
        os = parent.objectValues()
        for o in os:
            if o.getId() == '.psc':
                dot_psc = o
                break;
        if not dot_psc:
            return 'ps_return:-1'
        ss = string.split(dot_psc.data,'\n')
        for s in ss:
            if s == '':
                continue
            if s[:string.find(s,'/')] == c:
                return 'ps_return:' + s[string.find(s,'/')+1:]
        return 'ps_return:error'

    #本当のテスト関数
    security.declareProtected(view_permission, 'gaha')
    def gaha(self):
        """ gaha method """
        content = self.getRequestedContent()
        f = content.portal_type
        return 'ps_return:' + str(f)

InitializeClass(PloneSync)
