package jp.sourceforge.mixedmark.mm2xhtmlj;

import java.io.*;
import com.petebevin.markdown.*;
import jp.sourceforge.mixedmark.itex2mmlj.*;

public class MM2XhtmlJ {
    public static String mm2xhtml(String s) throws Exception {
    	StringReader sr = new StringReader(s);
    	StringWriter sw = new StringWriter();
    	mm2xhtml(sr,sw);
    	return sw.toString();
    }
    public static void mm2xhtml(Reader r,Writer w) throws Exception {
    	Lexer l = new Lexer(r);
    	Parser p = new Parser();
    	StringWriter sw = new StringWriter();
    	p.setOutput(sw);
    	p.yyparse(l);
    	MarkdownProcessor mp = new MarkdownProcessor();
    	String out = mp.markdown(sw.toString());
        PrintWriter pw = new PrintWriter(w);
        pw.print(out);
        pw.flush();
    }
}

