#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# 全文章の中から特定のチャプターだけ取り出す。
# 0章と指定された時には最初のH1以前の項目の後に
# 目次を自動生成することとする。
#
# HTMLのH1はチャプターなのかセクションなのかわからないけど、
# チャプターということにする。
# 

import xml.dom.minidom
from make_mm_dom import make_mm_dom

def isH1(n):
    if n.nodeType == xml.dom.minidom.Node.ELEMENT_NODE:
        if n.tagName == 'h1':
            return True
        else:
            return False
    else:
        return False

def isH2(n):
    if n.nodeType == xml.dom.minidom.Node.ELEMENT_NODE:
        if n.tagName == 'h2':
            return True
        else:
            return False
    else:
        return False

def pickOutChapter(body,c):
    doc = make_mm_dom(body)
    topLevelNode = doc.documentElement.firstChild.firstChild

    chapterCount = 0
    sectionCount = 0
    mokuji = []
    nodes = []
    while (topLevelNode):
        if isH1(topLevelNode):
            chapterCount = chapterCount + 1
            sectionCount = 0
            topLevelNode.setAttribute('id','mmChapter'+str(chapterCount))
            mokuji.append(['c',chapterCount,topLevelNode])
        elif isH2(topLevelNode):
            sectionCount = sectionCount + 1
            topLevelNode.setAttribute('id','mmSection'+str(chapterCount)+'-'+str(sectionCount))
            mokuji.append(['s',chapterCount,sectionCount,topLevelNode])

        if chapterCount==c:
            nodes.append(topLevelNode)

        topLevelNode = topLevelNode.nextSibling

    # 目次
    if c==0:
        chap_ul = doc.createElement('ul')
        chap_li = doc.createElement('li')
        chap_ul.appendChild(chap_li)
        chap_li.appendChild(doc.createTextNode(u'目次'))
        sec_ul = None
        for m in mokuji:
            if m[0]=='c':
                if sec_ul:
                    chap_li.appendChild(sec_ul)
                    sec_ul = None
                chap_li = doc.createElement('li')
                chap_ul.appendChild(chap_li)
                for child in m[2].childNodes:
                    chap_li.appendChild(child)
            else:
                if not sec_ul:
                    sec_ul = doc.createElement('ul')
                sec_li = doc.createElement('li')
                for child in m[3].childNodes:
                    sec_li.appendChild(child)
                sec_ul.appendChild(sec_li)
        nodes = nodes + [chap_ul]

    ret = ''
    for n in nodes:
        ret = ret + n.toxml('UTF-8')

    # 目次のページでなければページの上下にナビを付ける
    if c!=0:
        ret = '<table><tr><td>前</td><td>目次</td><td>次</td></tr></table>' + ret
        ret = ret + '<table><tr><td>前</td><td>目次</td><td>次</td></tr></table>'

    return ret
