#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# HTMLのbody部を受け取り
# S5(A Simple Standards-Based Slide Show System)
# 形式に整形する。
# 

import xml.dom.minidom
from make_mm_dom import make_mm_dom
from notation3ToRDF import notation3ToRDF

template = '''<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1 plus MathML 2.0 plus SVG 1.1//EN"
 "http://www.w3.org/2002/04/xhtml-math-svg/xhtml-math-svg.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>%s</title>
<!-- metadata -->
<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
<meta name="generator" content="S5" />
<meta name="version" content="S5 1.1" />
<meta name="presdate" content="20050728" />
<meta name="author" content="Eric A. Meyer" />
<meta name="company" content="Complex Spiral Consulting" />
<!-- configuration parameters -->
<meta name="defaultView" content="slideshow" />
<meta name="controlVis" content="hidden" />
<!-- style sheet links -->
<link rel="stylesheet" href="s5ui/default/slides.css" type="text/css" media="projection" id="slideProj" />
<link rel="stylesheet" href="s5ui/default/outline.css" type="text/css" media="screen" id="outlineStyle" />
<link rel="stylesheet" href="s5ui/default/print.css" type="text/css" media="print" id="slidePrint" />
<link rel="stylesheet" href="s5ui/default/opera.css" type="text/css" media="projection" id="operaFix" />
<!-- S5 JS -->
<script src="s5ui/default/slides.js" type="text/javascript"></script>
<!-- Other CSS -->
%s
<!-- Other Javascript -->
%s
<!-- RDF -->
%s
</head>
<body>

<div class="layout">
<div id="controls"><!-- DO NOT EDIT --></div>
<div id="currentSlide"><!-- DO NOT EDIT --></div>
<div id="header"></div>
<div id="footer">
<h1>[location/date of presentation]</h1>
<h2>[slide show title here]</h2>
</div>
</div>

%s

</body>
</html>
'''

def isDiv(n):
    if n.nodeType == xml.dom.minidom.Node.ELEMENT_NODE:
        if n.tagName == 'div':
            return True
        else:
            return False
    else:
        return False

def packSlide(body):
    doc = make_mm_dom(body)
    topLevelNode = doc.documentElement.firstChild.firstChild

    while (topLevelNode):
        if isDiv(topLevelNode):
            topLevelNode.setAttribute('class','slide')
        topLevelNode = topLevelNode.nextSibling

    ret = ''
    topLevelNode = doc.documentElement.firstChild
    while (topLevelNode):
        ret = ret + topLevelNode.toxml('UTF-8')
        topLevelNode = topLevelNode.nextSibling

    doc.unlink()

    return ret


# これがメインの変換関数
# 現在エンティティの処理が上手くいかないので、
# ヘナチョコなプログラムになっている。
def transToS5(inText, headers):
    inText = inText.replace('&','＆')
    inText = packSlide(inText)
    inText = inText.replace('＆','&')
    inText = inText.replace('&amp;gt;','>')
    inText = inText.replace('&amp;quot;','"')
    #inText = inText.replace('&amp;apos;',"'")
    title = ""
    cssline = ""
    javascript = ""
    rdf = ""
    for k, v in headers:
        if k == 'title':
            title = v
        elif k == 'css':
            c = v.strip()
            c = c.split()
            for i in range(len(c)):
                c[i] = c[i].strip()
            if len(c)==1:
                cssline = cssline + ('<link rel="stylesheet" type="text/css" href="%s" />\n' % c[0])
            elif len(c)==2:
                cssline = cssline + ('<link rel="stylesheet" type="text/css" href="%s" media="%s" />\n' % (c[0], c[1]))
            elif len(c)==3:
                cssline = cssline + ('<link rel="stylesheet" type="text/css" href="%s" media="%s" charset="%s"/>\n' % (c[0], c[1], c[2]))
        elif k == 'javascript':
            c = v.strip()
            c = c.split()
            for i in range(len(c)):
                c[i] = c[i].strip()
            if len(c)==1:
                javascript = javascript + ('<script type="text/javascript" src="%s">\n</script>\n' % c[0])
            elif len(c)==2:
                javascript = javascript + ('<script type="text/javascript" src="%s" charset"%s">\n</script>\n' % (c[0], c[1]))
        elif k == 'notation3':
            rdf = notation3ToRDF(v)
    return (template % (title,cssline,javascript,rdf,inText))

def transToS5Body(inText, headers):
    inText = inText.replace('&','＆')
    inText = packSlide(inText)
    inText = inText.replace('＆','&')
    inText = inText.replace('&amp;gt;','>')
    inText = inText.replace('&amp;quot;','"')
    #inText = inText.replace('&amp;apos;',"'")
    return inText
