#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# XHTMLのbodyの中身を受け取りDOMのドキュメントオブジェクト
# を作る。# プロパティエンティティに対して余計な
# 展開や変換が行われるので、今のところこのソースの外で
# 対応することとする。(mmPostProcess.py参照)
# 誰か解決法を教えて欲しい。
# 

from xml.dom.minidom import *
from xml.sax import handler, make_parser
import re

#DOMのデフォルトの動作は不明なエンティティを
#消去するもののようなので、一応ダミーのDTDを
#読ませて&Sum;とか&yen;などのエンティティが
#消えてしまわないようにするためのEntityResolver
#でも、今は使っていない。また使うかもしれないので、
#残してある。
class MMEntityResolver(handler.EntityResolver):
    def resolveEntity(self,publicId,systemId):
        f = open('/usr/local/bin/mixedmark.ent')
        return f
#EntityResolverを利用してDOMのドキュメントオブジェクトを作る。
#DOMはXHTMlのbodyの中身だけでは作れないので、
#ダミーのDOCTYPE宣言とhtml要素を付けている。
#でも、今はEntityResolverの機能はOFFにしてある。
def make_mm_dom(body):
    h = '''<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1 plus MathML 2.0 plus SVG 1.1//EN"
 "http://www.w3.org/2002/04/xhtml-math-svg/xhtml-math-svg.dtd">
<html xmlns="http://www.w3.org/1999/xhtml"><body>
'''
    t = '</body></html>'
    body = h + body + t
    #mmer = MMEntityResolver()
    #parser = make_parser()
    #parser.setEntityResolver(mmer)
    #doc = parseString(body,parser)
    doc = parseString(body)
    return doc

