#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# HTMLのbody部を受け取り
# headerとかを付けて整形する。
# 

from notation3ToRDF import notation3ToRDF

template = '''<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1 plus MathML 2.0 plus SVG 1.1//EN"
    "http://www.w3.org/2002/04/xhtml-math-svg/xhtml-math-svg.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="jp" lang="jp">
<head>
<meta http-equiv="Content-Type" content="application/xhtml+xml; charset=UTF-8" />
<title>%s</title>
<!-- CSS -->
%s
<!-- Javascript -->
%s
<!-- RDF -->
%s
</head>
<body>

%s

</body>
</html>
'''


# これがメインの変換関数
def transToXHTML(inText, headers):
    title = ""
    cssline = ""
    javascript = ""
    rdf = ""
    for k, v in headers:
        if k == 'title':
            title = v
        elif k == 'css':
            v = v.strip()
            c = v.split()
            for i in range(len(c)):
                c[i] = c[i].strip()
            if len(c)==1:
                cssline = cssline + ('<link rel="stylesheet" type="text/css" href="%s" />\n' % c[0])
            elif len(c)==2:
                cssline = cssline + ('<link rel="stylesheet" type="text/css" href="%s" media="%s" />\n' % (c[0], c[1]))
            elif len(c)==3:
                cssline = cssline + ('<link rel="stylesheet" type="text/css" href="%s" media="%s" charset="%s"/>\n' % (c[0], c[1], c[2]))
        elif k == 'javascript':
            v = v.strip()
            c = v.split()
            for i in range(len(c)):
                c[i] = c[i].strip()
            if len(c)==1:
                javascript = javascript + ('<script type="text/javascript" src="%s">\n</script>\n' % c[0])
            elif len(c)==2:
                javascript = javascript + ('<script type="text/javascript" src="%s" charset"%s">\n</script>\n' % (c[0], c[1]))
        elif k == 'notation3':
            rdf = notation3ToRDF(v)
    return (template % (title,cssline,javascript,rdf,inText))
