#!/usr/bin/perl

# obmenu-generator - schema file

=for comment

    item:      add an item inside the menu               {item => ["command", "label", "icon"]},
    cat:       add a category inside the menu             {cat => ["name", "label", "icon"]},
    sep:       horizontal line separator                  {sep => undef}, {sep => "label"},
    pipe:      a pipe menu entry                         {pipe => ["command", "label", "icon"]},
    file:      include the content of an XML file        {file => "/path/to/file.xml"},
    raw:       any XML data supported by Openbox          {raw => q(...)},
    beg:       begin of a category                        {beg => ["name", "icon"]},
    end:       end of a category                          {end => undef},
    obgenmenu: generic menu settings                {obgenmenu => ["label", "icon"]},
    exit:      default "Exit" action                     {exit => ["label", "icon"]},

=cut

# NOTE:
#    * Keys and values are case sensitive. Keep all keys lowercase.
#    * ICON can be a either a direct path to an icon or a valid icon name
#    * Category names are case insensitive. (X-XFCE and x_xfce are equivalent)

require "$ENV{HOME}/.config/obmenu-generator/config.pl";

## Text editor
my $editor = $CONFIG->{editor};

our $SCHEMA = [
    {sep => 'MiyoLinux'},
    #          COMMAND                 	    LABEL                      ICON
    {item => ['pcmanfm',       		'File Manager', 	'system-file-manager']},
    {item => ['lxterminal',		'Terminal',     	'utilities-terminal']},
    {item => ['j4-dmenu-desktop', 	'Run command',  	'system-search']},
	{beg => ['Screenshot',	'accessories-camera']}, 
    	{item => ['scrot -q 90 -d 1 -e "mv $f ~/Pictures/"',	'Now',                   		'accessories-camera']},
	{item => ['scrot -q 90 -d 10 -e "mv $f ~/Pictures/"',  	'In 10 seconds...',      		'accessories-camera']},
	{item => ['scrot -q 90 -d 20 -e "mv $f ~/Pictures/"',  	'In 20 seconds...',      		'accessories-camera']},
        {item => ['scrot -q 90 -s -e "mv $f ~/Pictures/"',	'Area (drag the mouse)',     		'accessories-camera']},
        {item => ['scrot -q 90 -s -e "mv $f ~/Pictures/"',     	'Window (click the window)',		'accessories-camera']},
    	{end => undef},
    {sep => 'Applications'},

    #          NAME            LABEL                ICON
    {cat => ['utility',     'Accessories', 'applications-utilities']},
    {cat => ['development', 'Development', 'applications-development']},
    {cat => ['education',   'Education',   'applications-science']},
    {cat => ['game',        'Games',       'applications-games']},
    {cat => ['graphics',    'Graphics',    'applications-graphics']},
    {cat => ['audiovideo',  'Multimedia',  'applications-multimedia']},
    {cat => ['network',     'Network',     'applications-internet']},
    {cat => ['office',      'Office',      'applications-office']},
    {cat => ['other',       'Other',       'applications-other']},
    {cat => ['settings',    'Settings',    'applications-accessories']},
    {cat => ['system',      'System',      'applications-system']},

    #             LABEL          ICON
    #{beg => ['My category',  'cat-icon']},
    #          ... some items ...
    #{end => undef},

    #            COMMAND     LABEL        ICON
    #{pipe => ['obbrowser', 'Disk', 'drive-harddisk']},

    ## Generic advanced settings
    #{sep       => undef},
    #{obgenmenu => ['Openbox Settings', 'applications-engineering']},
    #{sep       => undef},

    ## Custom advanced settings
    {sep => undef},
    {beg => ['Advanced Settings', 'applications-engineering']},
      # obmenu-generator category
      {beg => ['Obmenu-Generator', 'accessories-text-editor']},
        {item => ["$editor ~/.config/obmenu-generator/schema.pl", 'Menu Schema', 'text-x-generic']},
        {item => ["$editor ~/.config/obmenu-generator/config.pl", 'Menu Config', 'text-x-generic']},
        {sep  => undef},
        {item => ['obmenu-generator -s -c',    	'Generate a static menu',             	'accessories-text-editor']},
        {item => ['obmenu-generator -s -i -c', 	'Generate a static menu with icons',  	'accessories-text-editor']},
        {sep  => undef},
        {item => ['obmenu-generator -p',       	'Generate a dynamic menu',            	'accessories-text-editor']},
        {item => ['obmenu-generator -p -i',    	'Generate a dynamic menu with icons', 	'accessories-text-editor']},
        {sep  => undef},
        {item => ['obmenu-generator -d', 	'Refresh cache', 			'view-refresh']},
      {end => undef},
      # Openbox category
      {beg => ['Openbox', 'openbox']},
         {item => ['openbox --reconfigure',               	'Reconfigure Openbox',   	'gtk-refresh']},
	 {item => ['openbox --restart',		     		'Restart Openbox',	      	'system-reboot']},
	 {sep => undef},
         {item => ["$editor ~/.config/openbox/autostart", 	'autostart',     		'accessories-text-editor']},
         {item => ["$editor ~/.config/openbox/rc.xml",    	'rc.xml',            		'accessories-text-editor']},
         {item => ["$editor ~/.conkyrc",                  	'.conkyrc',   			'accessories-text-editor']},
         {item => ["$editor ~/.config/compton.conf",      	'compton.conf', 		'accessories-text-editor']},
       {end => undef},
      {end => undef},
      # MiyoLinux category
    	{beg => ['Miyo Accessories', 	'/usr/share/miyolinux/miyolinux.png']},
		{item => ['miyo-root-appearance',	'Customize Look and Feel (as Root)',	'preferences-desktop-theme']},
		{item => ['miyo-root-pcmanfm',	 	'PCManFM (as Root)',			'system-file-manager']},
		{item => ['/usr/bin/miyo-touchpad',   	'Touchpad Controls',      		'input-touchpad']},
		{item => ['/usr/bin/miyo-keyboard',     'Live Keyboard Layout',			'input-keyboard']},
	{end => undef},

    {sep => 'Session'},		
    	{item => ['miyo-lock', 		'Lock', 	'system-lock-screen']},
    	{item => ['miyo-exit', 		'Exit', 	'gnome-shutdown']},
]
