#!/usr/bin/env bash

list=$(apt-get -s dist-upgrade | awk '/^Inst/ { print $2 }')

count=$(echo "$list" | wc -l)

notify-send --expire-time=30000 --icon="/usr/share/pixmaps/updates.svg" "Available updates: $count

$list"

yad --notification \
--image="/usr/share/pixmaps/updates.svg" \
--icon-size=22 \
--command="killall yad" \
--text="Available updates: $count
_____________________

$list" 
 
