#pragma once


#undef _EXPORT_
#ifdef PIC_KERNEL_EXPORTS
#define _EXPORT_ __declspec(dllexport) 
#else
#define _EXPORT_ __declspec(dllimport) 
#endif

#include <windows.h>

class CPLFileData;

class _EXPORT_ CPLMemoryData
{
protected:
	CPLMemoryData(void);
	~CPLMemoryData(void);

public:
	enum MEMORY_TYPE
	{
		E_DATA_MEMORY_PL,
		E_DATA_MEMORY_LA,
		E_DATA_MEMORY_GA
	};

	
	static CPLMemoryData * __fastcall create( );
	static CPLMemoryData * __fastcall create( HANDLE hMemory, CPLMemoryData::MEMORY_TYPE eType );
	static void __fastcall destroy( CPLMemoryData *pData );
	
	void __fastcall init( );

	bool __fastcall attach( HANDLE hMemory, CPLMemoryData::MEMORY_TYPE eType );
	bool __fastcall detach( );
	bool __fastcall destroy( );
	CPLMemoryData::MEMORY_TYPE __fastcall get_type( );
	void * __fastcall get_ptr( );
	HANDLE __fastcall get_handle( );
	unsigned int __fastcall get_size( );

	CPLFileData * __fastcall write_to_file( const char *strFileName );

protected:
	MEMORY_TYPE m_eMemoryType;
	HANDLE m_hMemoryHandle;
	HANDLE m_pMemoryPtr;
	DWORD m_nSizeOfMemoryImage;
};

