#pragma once
#include "plimage.h"

#undef _EXPORT_
#ifdef PIC_KERNEL_EXPORTS
#define _EXPORT_ __declspec(dllexport) 
#else
#define _EXPORT_ __declspec(dllimport) 
#endif

class CBlockCacheArray;

class _EXPORT_ CPLFileImage :
	public CPLImage
{
public:
	CPLFileImage(void);
	virtual ~CPLFileImage(void);

	static CPLFileImage * __fastcall Create( );

	// 
	virtual bool __fastcall CreateImage( char *strImageName, int width, int height, int colordepth );
	virtual CPLImage * __fastcall Clone( char *strNewImageName );
	virtual bool HasObject( );

	// j
	virtual void __fastcall DestroyImage( );

	// 擾
	virtual bool __fastcall GetImagePixel( int width, int heihgt, COLORREF &crResult );
	virtual bool __fastcall GetImagePixel( int width, int height, unsigned char &paletteIndex );
	virtual bool __fastcall GetImageLine( int nLine, unsigned char **pResult, BOOL bPaletteIndex );
	virtual bool __fastcall GetImageLine( int nLine, const unsigned char ** const pResult, BOOL bPaletteIndex );

	// ݒ
	virtual bool __fastcall SetImagePixel( int width, int height, COLORREF crPixel );
	virtual bool __fastcall SetImagePixel( int width, int height, unsigned char paletteNo );
	virtual bool __fastcall SetImageLine( int nLine, unsigned char *pLineData );

	// AANZXœK
	virtual bool __fastcall BeginAccessLines( int nStartLine, int nEndLine );
	virtual bool __fastcall EndAccessLines( );

	static void __fastcall SetCacheSize( unsigned int nNewCacheSize );

protected:

	CBlockCacheArray *m_pCacheFile;
	unsigned char *m_pCacheBuffer;

	static unsigned int MEMORY_CACHE_SIZE ;

	void __fastcall init( );
};
