#include "../hed/hed_common/stl.h"
#include "../hed/hed_picturelib/filter.h"
#include "hed\pic_kernel.h"
#include "../hed/hed_picturelib/filedata.h"
#include "../hed/hed_picturelib/memorydata.h"

CPLFileData::CPLFileData(void)
{
	m_file = NULL;
}

CPLFileData::~CPLFileData(void)
{
	destroy( );
}

CPLFileData * __fastcall CPLFileData::create( const char *strFileName )
{
	CPLFileData *pResult = new CPLFileData( );
	pResult->attach( strFileName );
	return pResult;
}

void __fastcall CPLFileData::destroy( CPLFileData *pData )
{
	delete pData;
}

bool __fastcall CPLFileData::attach( const char *strName )
{
	detach( );
	if( strName )
	{
		if( !m_file )
			m_file = (SFileData*)PL_Malloc( sizeof( SFileData ), true );
		strncpy( m_file->FileName, strName, MAX_PATH );
		return true;
	}
	else
	{
		return false;
	}
}

bool __fastcall CPLFileData::detach( )
{
	if( m_file )
	{
		memset( m_file, 0x00, sizeof( SFileData ) );
		return true;
	}
	else
	{
		return false;
	}
}

bool __fastcall CPLFileData::destroy( )
{
	PL_Free( m_file );
	m_file = NULL;
	return true;
}

bool __fastcall CPLFileData::get_name( char *strName, unsigned int bufSize )
{
	if( !strName || bufSize == 0 )
		return false;
	strName[0] = '\0';
	if( !m_file )
		return false;
	strncpy( strName, m_file->FileName, bufSize );
	return true;
}

CPLMemoryData * __fastcall CPLFileData::read_data( )
{
	CPLMemoryData *pResult = NULL;

	FILE *fp = fopen( m_file->FileName, "rb" );
	if( fp )
	{
		fseek( fp, 0, SEEK_END );
		int nSize = ftell( fp );
		fclose( fp );
		pResult = read_data( nSize );
	}
	return pResult;
}

CPLMemoryData * __fastcall CPLFileData::read_data( int nSize )
{
	CPLMemoryData *pResult = NULL;

	FILE *fp = fopen( m_file->FileName, "rb" );
	if( fp )
	{
		void *pMem = PL_Malloc( nSize, false );
		fread( pMem, 1, nSize, fp );
		fclose( fp );
		pResult = CPLMemoryData::create( );
		pResult->attach( pMem, CPLMemoryData::E_DATA_MEMORY_PL );
	}
	return pResult;
}
