#include "../hed/hed_common/stl.h"
#include <windows.h>
#include <stdio.h>
#include "../hed/hed_picturelib/filter.h"
#include "plg_reducecolor.h"
#include "resource.h"

extern HINSTANCE g_hInstance;

__declspec(dllexport) bool __stdcall GetPluginInfo ( PLUGIN_INFO *pInfo )
{
	if( !pInfo )
		return false;
	pInfo->nVersionMejor = 1;
	pInfo->nVersionMinor = 0;
	strcpy( pInfo->chPluginName, "Convert from 24bit to 8bit" );
	strcpy( pInfo->chPluginCopyright, "Hiroyuki Mizuhara" );

	pInfo->bSupport8_8 = false;
	pInfo->bSupport8_24 = false;
	pInfo->bSupport24_8 = true;
	pInfo->bSupport24_24 = false;
	return true;
}

__declspec(dllexport) int __stdcall GetOptionSize( )
{
	return sizeof( reduce_color_option );
}

__declspec(dllexport) bool __stdcall GetDefaultOption( void *pDefaultOption )
{
	if( !pDefaultOption )
		return false;
	reduce_color_option *pOption = ( reduce_color_option* )pDefaultOption;
	pOption->ucUsePalette = 256;
	return true;
}


BOOL CALLBACK ConfigurationDlgFunction( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam );
__declspec(dllexport) bool __stdcall Configure( HWND hWndParent, LPVOID pOption )
{
	if( ::DialogBoxParam( g_hInstance, MAKEINTRESOURCE(IDD_CONFIGURE), hWndParent, ConfigurationDlgFunction, (LPARAM)pOption ) == IDOK )
	{
		return true;
	}
	else
	{
		return false;
	}
}

BOOL CALLBACK ConfigurationDlgFunction( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam )
{
	static reduce_color_option *pOption = NULL;
	switch( message )
	{
	case WM_INITDIALOG:
		{
			pOption = (reduce_color_option*)lParam;
			char chColorNumber[32];
			sprintf( chColorNumber, "%d", pOption->ucUsePalette );
			::SetDlgItemText( hWnd, IDC_EDIT_COLORNUM, chColorNumber );
		}
		break;
	case WM_COMMAND:
		{
			switch( LOWORD(wParam) )
			{
			case IDOK:
				{
					char chDlgItemText[32];
					int nColorNum = 0;
					::GetDlgItemText( hWnd, IDC_EDIT_COLORNUM, chDlgItemText, 32 );
					nColorNum = atoi( chDlgItemText );
					if( nColorNum <= 0 || nColorNum > 256 )
					{
						break;
					}
					else
					{
						pOption->ucUsePalette = nColorNum;
					}
					::EndDialog( hWnd, IDOK );
				}
				break;
			case IDCANCEL:
				::EndDialog( hWnd, IDCANCEL );
				break;
			}
		}
		break;
	default:
		return FALSE;
	}
	return TRUE;
}
