#include "../hed/hed_common/stl.h"
#include <windows.h>
#include <stdio.h>
#include "../hed/hed_picturelib/PLImage.h"

void ConvertMonokuroPalette( CPLImage *in )
{

	for( int i = 0; i < 256; i++ )
	{
		COLORREF palette = RGB( 0, 0, 0 );
		in->GetImagePalette( i, palette );
		double dr = GetRValue( palette );
		double dg = GetGValue( palette );
		double db = GetBValue( palette );
		double luminance = ( 0.298912 * dr + 0.586611 * dg + 0.114478 * db ); 
		int val = (int)(luminance);
		in->SetImagePalette( i, RGB( val, val, val ) );
	}
}

void ConvertMonokuroBits( CPLImage *in )
{
	if( !in )
		return;
	int width = 0, height = 0, colordepth = 0;
	in->GetImageSize( width, height );
	in->GetImageColorDepth( colordepth );
	int err = 0;
	for( int h = 0; h < height; h++ )
	{
		for( int w = 0; w < width; w++ )
		{
			COLORREF crBits = RGB( 0, 0, 0 );
			in->GetImagePixel( w, h, crBits );
			double dr = GetRValue( crBits );
			double dg = GetGValue( crBits );
			double db = GetBValue( crBits );
			double luminance = ( 0.298912 * dr + 0.586611 * dg + 0.114478 * db ); 
			int val = (int)(luminance);
			in->SetImagePixel( w, h, RGB( val, val, val ) );
		}
	}
}

bool to_monokuro( CPLImage *in, CPLImage *out, void *pOption )
{
	if( !in || !out )
		return false;
	int colordepth = 0;
	in->GetImageColorDepth( colordepth );
	in->Copy( *out ); 
	if( colordepth == 8 )
	{
		ConvertMonokuroPalette( out );
	}
	else if( colordepth == 24 )
	{
		ConvertMonokuroBits( out );
	}
	else
	{
		out->DestroyImage( );
		out = NULL;
	}
	return (out != NULL);
}

// ėptB^ckk֐
__declspec(dllexport) bool __stdcall do_filter( CPLImage *in, CPLImage *out, void *pOption )
{
	if( !in )
		return NULL;

	return to_monokuro( in, out, NULL );
}