// PLSusieArchiveData.cpp: CPLSusieArchiveData NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "../hed/hed_common/stl.h"
#include "../hed/hed_susie/PLSusieArchiveData.h"
#include "../hed/hed_susie/susie.h"
#include "../hed/hed_susie/susiearchive.h"
#include "../hed/hed_picturelib/pldata.h"
#include "../hed/hed_picturelib/memorydata.h"
#include "../hed/hed_picturelib/filedata.h"

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CPLSusieArchiveData::CPLSusieArchiveData( CPLData *pData, CPLMemoryData *pArchiveInfo, CSusieArchive *pPlugin )
{
	m_nMaxSize = 0;
	m_pData = NULL;
	if( pData )
	{
		char strObjectName[256];
		pData->get_name( strObjectName, 256 );
		m_pData = new CPLData( strObjectName );
		if(pData->is_file() )
		{
			char strFile[256];
			pData->get_file()->get_name( strFile, 256 );
			CPLFileData *pFile = CPLFileData::create( strFile );
			m_pData->set_file( pFile );
		}
		else if( pData->is_memory() )
		{
			HANDLE hMemory = pData->get_memory()->get_handle();
			void *pMemory = pData->get_memory()->get_ptr();
			UINT uiSize = pData->get_memory()->get_size();
			CPLMemoryData::MEMORY_TYPE type = pData->get_memory()->get_type();
			CPLMemoryData *pMemoryData = CPLMemoryData::create( hMemory, type );
			m_pData->set_memory( pMemoryData );
		}
	}
	m_ArchiveInfo = pArchiveInfo;
	m_pPluginObject = pPlugin;
	if( m_ArchiveInfo )
	{
		fileInfo *pInfo = (fileInfo*)pArchiveInfo->get_ptr();
		while( pInfo->method[0] != '\0' )
		{
			m_nMaxSize ++;
			pInfo ++;
		}
	}
}

CPLSusieArchiveData::~CPLSusieArchiveData()
{
	if( m_pData->is_file() )
	{
		CPLFileData *pFile =m_pData->get_file();
		CPLFileData::destroy(pFile);
	}
	else if( m_pData->is_memory() )
	{
		CPLMemoryData *pMemory = m_pData->get_memory();
		CPLMemoryData::destroy( pMemory );
	}
	delete m_pData;
	CPLMemoryData::destroy( m_ArchiveInfo );
}

unsigned int CPLSusieArchiveData::Count( )
{
	return m_nMaxSize;
}

CPLData *CPLSusieArchiveData::GetDataSource( )
{
	return m_pData;
}

bool CPLSusieArchiveData::GetAt( int nIndex, CPLData *pDataResult )
{
	if( !m_ArchiveInfo || !m_pPluginObject )
		return false;

	fileInfo *pInfo = (fileInfo*)m_ArchiveInfo->get_ptr();
	if( !pInfo )
		return false;
	if( nIndex < 0 || nIndex >= m_nMaxSize )
		return false;
	pInfo = &(pInfo[nIndex]);
	
	return m_pPluginObject->DecodeFile( m_pData, pInfo->position, pInfo->compsize, pDataResult );
}

std::string CPLSusieArchiveData::GetFileName( int nIndex )
{
	if( !m_ArchiveInfo || !m_pPluginObject )
		return "";

	fileInfo *pInfo = (fileInfo*)m_ArchiveInfo->get_ptr();
	if( !pInfo )
		return "";
	if( nIndex < 0 || nIndex >= m_nMaxSize )
		return "";
	pInfo = &(pInfo[nIndex]);

	return std::string(pInfo->filename);
}

std::string CPLSusieArchiveData::GetPathName( int nIndex )
{
	if( !m_ArchiveInfo || !m_pPluginObject )
		return "";

	fileInfo *pInfo = (fileInfo*)m_ArchiveInfo->get_ptr();
	if( !pInfo )
		return "";
	if( nIndex < 0 || nIndex >= m_nMaxSize )
		return "";
	pInfo = &(pInfo[nIndex]);
	
	if( pInfo->path[strlen(pInfo->path) - 1] != '\\' )
		return std::string(pInfo->path) + "\\" ;
	else
		return std::string(pInfo->path );
}
