#include "../hed/hed_common/stl.h"
#include "../hed/hed_susie/susiearchive.h"
#include "../hed/hed_susie/susie.h"
#include "../hed/hed_susie/plsusiearchivedata.h"
#include "../hed/hed_picturelib/pldata.h"
#include "../hed/hed_picturelib/memorydata.h"
#include "../hed/hed_picturelib/filedata.h"

CSusieArchive::CSusieArchive(void)
{
}

CSusieArchive::~CSusieArchive(void)
{
}

bool CSusieArchive::Initialize( const char * const strPluginName)
{
	return CPluginObject::Initialize( strPluginName );
}

bool CSusieArchive::TestPlugin( )
{
	bool bUnload = false;
	bool bResult = false;

	if( m_hInstance == NULL )
	{
		LoadPluginObject( );
		bUnload = true;
	}

	do
	{
		if( !m_fpGetPluginInfo  ||
			!m_fpIsSupported )
			break;

		char chBuffer[ 256 ] = "";
		int nResult = GetPluginInfo( m_fpGetPluginInfo, 0, chBuffer, 256 );
		if( nResult <= 0 || strcmp( chBuffer, "00AM" ) )
			break;

		if( !m_fpGetArchiveInfo ||
			!m_fpGetFile )
			break;
		bResult = true;
	}while( false );

	if( bUnload != false )
		UnloadPluginObject( );

	return bResult;
}

bool CSusieArchive::GetArchiveFileInfo( CPLData *pData, CPLSusieArchiveData **pResult )
{
	if( !pData || !pResult )
		return false;

	bool bUnload = false;
	bool bResult = false;
	
	*pResult = NULL;

	if( m_hInstance == NULL )
	{
		LoadPluginObject( );
		bUnload = true;
	}

	LPSTR src = 0;
	long bufLen = 0;
	UINT flag = 0;
	HLOCAL hLocal = 0;
	char chFileName[256] = "";
	if( pData->is_memory() )
	{
		CPLMemoryData *pMemory = pData->get_memory();
		src = (LPSTR)pMemory->get_ptr();
		bufLen = pMemory->get_size();
		flag = 0x00000001;
	}
	else if( pData->is_file() )
	{
		CPLFileData *pFile = pData->get_file();
		pFile->get_name( chFileName, 256 );
		src = chFileName;
	}

	int nResult = ::GetArchiveInfo( m_fpGetArchiveInfo, src, bufLen, flag, &hLocal );
	if( hLocal != NULL )
	{
		CPLMemoryData *pRetMemory = CPLMemoryData::create( hLocal, CPLMemoryData::E_DATA_MEMORY_LA );
		*pResult = new CPLSusieArchiveData( pData, pRetMemory, this );
	}

	if( bUnload != false )
		UnloadPluginObject( );

	return ( *pResult != NULL );
}

bool CSusieArchive::DecodeFile( CPLData *pData, 
		long offset, 
		long size, 
		CPLData *pResult,
		CALLBACKPROGRESS_SUSIE callback,
		int lParam )
{
	if( !pData || !pResult )
		return false;
	if( !callback )
		callback = CPluginObject::SusieDefaultCallBack;

	bool bUnload = false;
	bool bResult = false;

	if( m_hInstance == NULL )
	{
		LoadPluginObject( );
		bUnload = true;
	}

	LPSTR src = 0;
	long len = 0;
	LPSTR dest = 0;
	UINT flag = 0;
	char chFileName[MAX_PATH] = "";
	char chFileNameDest[MAX_PATH] = "";
	HLOCAL hLocalResult = NULL;
	if( pData->is_memory() )
	{
		CPLMemoryData *pMemory = pData->get_memory();
		src = (LPSTR)pMemory->get_ptr() + offset;
		len = size;
		flag = 0x00000001;
	}
	else if( pData->is_file() )
	{
		CPLFileData *pFile = pData->get_file();
		pFile->get_name( chFileName, MAX_PATH );
		src = chFileName;
		len = offset;
	}
	else
	{
		return false;
	}

	if( pResult->is_file( ) )
	{
		CPLFileData *pFile = pData->get_file();
		pFile->get_name( chFileNameDest, 256 );
		dest = chFileNameDest;
	}
	else if( pResult->is_memory( ) )
	{
		dest = (LPSTR)&hLocalResult;
		flag |= 0x00000100;
	}
	else
	{
		return false;
	}
	
	
	int nResult = GetFile( m_fpGetFile, src, len, dest, flag, (FARPROC)callback, lParam );

	if( nResult==0)
	{
		if(pResult->is_memory())
		{
			CPLMemoryData *pMemory = pResult->get_memory();
			pMemory->attach( hLocalResult, CPLMemoryData::E_DATA_MEMORY_LA);
		}
	}

	if( bUnload != false )
		UnloadPluginObject( );

	return (nResult == 0);
}
