#include "mk.h"
#include <string.h>

static const MK_CHAR className[] = CLASS_INTERNAL_EXCEPTION;
static const MK_CHAR classSuper[] = CLASS_INTERNAL_OBJECT;

MK_CLASS *mk_create_exception_class( MK_VM_STRUCT *vm )
{
	MK_CLASS *result =
		mk_create_object( MK_TYPE_CLASS );
	
	result->nameThis = mk_get_symbol_name_ptr( vm, className );
	result->nameSuper = mk_get_symbol_name_ptr( vm, classSuper );

	mk_register_variable( vm, 
		mk_create_variable( vm, "id", MK_TYPE_VARIABLE | MK_TYPE_ATTRIBUTE_VARIABLE_MEMBER, NULL ),
		result );

	mk_register_variable( vm, 
		mk_create_variable( vm, "name", MK_TYPE_VARIABLE | MK_TYPE_ATTRIBUTE_VARIABLE_MEMBER, NULL ),
		result );

	mk_register_variable( vm, 
		mk_create_variable( vm, "line", MK_TYPE_VARIABLE | MK_TYPE_ATTRIBUTE_VARIABLE_MEMBER, NULL ),
		result );

	mk_register_variable( vm, 
		mk_create_variable( vm, "description", MK_TYPE_VARIABLE | MK_TYPE_ATTRIBUTE_VARIABLE_MEMBER, NULL ),
		result );

	return result;
}
