#include "mk.h"
#include <string.h>

static const MK_CHAR className[] = CLASS_INTERNAL_IO;
static const MK_CHAR classSuper[] = CLASS_INTERNAL_OBJECT;

static 
int mk_io_open( MK_VM_STRUCT *vm, MK_NODE_EXPR *src, MK_NODE_EXPR *targetName, MK_VM_FRAME_ITEM **result )
{
	*result = NULL;
	return MK_VM_EXECUTE_EXPR_RETURN_RETURN;
}

MK_CLASS *mk_create_io_class( MK_VM_STRUCT *vm )
{
	MK_CLASS *result =
		mk_create_object( MK_TYPE_CLASS );
	
	result->nameThis = mk_get_symbol_name_ptr( vm, className );
	result->nameSuper = mk_get_symbol_name_ptr( vm, classSuper );

	mk_register_function( 
		vm,
		mk_create_native_function( 
			vm, 
			"open", 
			2, 
			MK_TYPE_FUNCTION | MK_TYPE_ATTRIBUTE_FUNCTION_NATIVE, 
			mk_io_open ),
		result );
	return result;
}