#include "mk.h"
#include <stdlib.h>
#include <memory.h>
#include <string.h>


MK_VECTOR *mk_create_vector( unsigned int defaultSize, unsigned int extend )
{
	size_t size = 
		sizeof( void* ) * defaultSize;
	MK_VECTOR *result = 
		malloc( sizeof( MK_VECTOR ) );
	result->flags = 
		MK_TYPE_VECTOR | ( ( extend << 18 ) & MK_TYPE_VECTOR_SIZE_EXTEND_MASK );
	result->size = defaultSize;
	result->used = 0;
	result->items = malloc( size );
	return result;
}

unsigned int mk_insert_at_vector( MK_VECTOR **ptarget, unsigned int index, void *elem )
{
	MK_VECTOR *target = NULL;

	if( (*ptarget) == NULL )
	{
		index = 0;
		*ptarget = 
			mk_create_vector( MK_SIZEOF_VECTOR_DEFAULT, MK_SIZEOF_EXTEND_VECTOR_DEFAULT );
		target = *ptarget;
	}
	else
	{
		target = *ptarget;
		if( index > target->used )
			index = target->used ;
		if( target->size == target->used )
		{
			unsigned int extend = 
				MK_TYPE_VECTOR_SIZE_EXTEND(target->flags);
			void **newItems = 
				malloc( sizeof( void* ) * ( target->size + extend ) ), **oldItems = NULL;
			memcpy( newItems, target->items, sizeof(void*) * ( (index < target->used) ? index : target->used ) );
			if( target->used > index )
				memcpy( &newItems[index+1], &(target->items[index]), sizeof(void*) * (target->used-index) );
			oldItems = target->items;
			target->items = newItems;
			target->size += extend;
			free( oldItems );
		}
	}

	if( target->used - index > 0 && target->used > 0)
		memmove( &(target->items[index+1]), &(target->items[index]), sizeof(void*) * ( target->used-index ) );

	target->items[index] = elem;
	target->used ++;
	return index;
}

void *mk_set_at_vector( MK_VECTOR *ptarget, unsigned int index, void *newItem )
{
	void *old = NULL;
	if( ptarget == NULL || ptarget->used <= index )
		return NULL;
	old = ptarget->items[index];
	ptarget->items[index] = newItem;
	return old;
}

#ifdef _DEBUG
const void **mk_get_item_ptr_vector( MK_VECTOR *ptarget )
{
	return ( ptarget != NULL ) ?
		(const void**)ptarget->items : NULL;
}


void mk_trim_size_vector( MK_VECTOR *ptarget, unsigned int newSize )
{
	if( ptarget != NULL &&
		ptarget->used > newSize )
		ptarget->used = newSize;
}

void mk_push_vector( MK_VECTOR *ptarget, void *elem )
{
	if(ptarget!=NULL && ptarget->used < ptarget->size )
		ptarget->items[ptarget->used++] = elem;
	else
		mk_insert_at_vector( &ptarget, 0xffffffff, elem );
}

unsigned int mk_size_vector( MK_VECTOR *ptarget )
{
	return ( ptarget != NULL ) ?
		ptarget->used : 0;
}


void* mk_get_at_vector( MK_VECTOR *ptarget, unsigned int index )
{
	return ( ptarget != NULL && index < ptarget->used ) ?
		ptarget->items[index] : NULL;
}

void *mk_pop_vector( MK_VECTOR *ptarget )
{
	return ( ptarget != NULL && ptarget->used > 0 ) ?
		ptarget->items[--ptarget->used] : NULL;
}
#endif
