#include "mk.h"
#include <string.h>

static const MK_CHAR classNameException[] = CLASS_INTERNAL_EXCEPTION;
static const MK_CHAR classSuper[] = CLASS_INTERNAL_OBJECT;

MK_CLASS *mk_create_exception_class( MK_VM_STRUCT *vm )
{
	MK_CLASS *result =
		mk_create_object( MK_TYPE_CLASS );
	
	result->nameThis = mk_get_symbol_name_ptr( vm, classNameException );
	result->nameSuper = mk_get_symbol_name_ptr( vm, classSuper );

	mk_register_variable( vm, 
		mk_create_variable( vm, "id", MK_TYPE_VARIABLE | MK_TYPE_ATTRIBUTE_VARIABLE_VALUE, NULL ),
		result );

	mk_register_variable( vm, 
		mk_create_variable( vm, "name", MK_TYPE_VARIABLE | MK_TYPE_ATTRIBUTE_VARIABLE_VALUE, NULL ),
		result );

	mk_register_variable( vm, 
		mk_create_variable( vm, "line", MK_TYPE_VARIABLE | MK_TYPE_ATTRIBUTE_VARIABLE_VALUE, NULL ),
		result );

	mk_register_variable( vm, 
		mk_create_variable( vm, "description", MK_TYPE_VARIABLE | MK_TYPE_ATTRIBUTE_VARIABLE_VALUE, NULL ),
		result );

	return result;
}

static const MK_CHAR classNameCompileError[] = CLASS_INTERNAL_COMPILE_ERROR_EXCEPTION;

MK_CLASS *mk_create_compile_error_exception_class( MK_VM_STRUCT *vm )
{
	MK_CLASS *result =
		mk_create_object( MK_TYPE_CLASS );
	
	result->nameThis = mk_get_symbol_name_ptr( vm, classNameCompileError );
	result->nameSuper = mk_get_symbol_name_ptr( vm, classNameException );

	return result;
}

static const MK_CHAR classNameVMError[] = CLASS_INTERNAL_VM_ERROR_EXCEPTION;

MK_CLASS *mk_create_vm_error_exception_class( MK_VM_STRUCT *vm )
{
	MK_CLASS *result =
		mk_create_object( MK_TYPE_CLASS );
	
	result->nameThis = mk_get_symbol_name_ptr( vm, classNameVMError );
	result->nameSuper = mk_get_symbol_name_ptr( vm, classNameException );

	return result;
}

static const MK_CHAR classNameArrayOutOfRange[] = CLASS_INTERNAL_ARRAY_OUTOF_RANGE;

MK_CLASS *mk_create_array_outof_range_exception_class( MK_VM_STRUCT *vm )
{
	MK_CLASS *result =
		mk_create_object( MK_TYPE_CLASS );
	
	result->nameThis = mk_get_symbol_name_ptr( vm, classNameArrayOutOfRange );
	result->nameSuper = mk_get_symbol_name_ptr( vm, classNameException );

	return result;
}

