#include "mk.h"

static const MK_CHAR className[] = CLASS_INTERNAL_REFERENCE;
static const MK_CHAR classSuper[] = CLASS_INTERNAL_OBJECT;

MK_VM_FRAME_ITEM *mk_reference_to_value( MK_VM_STRUCT *vm, MK_VM_FRAME_ITEM *source )
{
	if( MK_TYPE_ATTRIBUTE(source->flags) == MK_VM_FRAME_ITEM_TYPE_REFERENCE_VALUE )
		return
			mk_vm_find_instance( vm, 
				source, 
				vm->cache->internalClassSymbolName[MK_VM_FRAME_ITEM_TYPE_REFERENCE_VALUE>>24] );
	else if( MK_TYPE_ATTRIBUTE(source->flags) == MK_VM_FRAME_ITEM_TYPE_REFERENCE_ARRAY_VALUE )
		return
			(MK_VM_FRAME_ITEM*)mk_get_at_vector( 
				source->referenceArrayType.target, 
				source->referenceArrayType.index );
	else
		return NULL;
}
static
int mk_reference_equal( struct TAG_MK_VM_STRUCT *vm, unsigned int varArgC )
{
	MK_VM_FRAME_ITEM *right = 
		mk_vm_pop_stack( &vm->localStack );
	MK_VM_FRAME_ITEM *target = 
		mk_vm_pop_stack( &vm->localStack );
	MK_VM_FRAME_ITEM *result = NULL;
	if( MK_VM_FRAME_ITEM_TYPE_GROUP(target->flags) != MK_VM_FRAME_ITEM_TYPE_REFERENCE_VALUE )
		target = 
			mk_vm_find_instance( vm, 
				target, 
				vm->cache->internalClassSymbolName[MK_VM_FRAME_ITEM_TYPE_REFERENCE_VALUE>>24] );
	if( target == NULL )
	{
		return MK_VM_EXECUTE_EXPR_THROW;
	}
	else
	{
		if( MK_TYPE_ATTRIBUTE(target->flags) == MK_VM_FRAME_ITEM_TYPE_REFERENCE_VALUE )
		{
			mk_insert_item_hashtable(
				target->referenceTypeValue.target, 
				target->referenceTypeValue.symbolName, right );
		}
		else if( MK_TYPE_ATTRIBUTE(target->flags) == MK_VM_FRAME_ITEM_TYPE_REFERENCE_ARRAY_VALUE )
		{
			mk_set_at_vector( 
				target->referenceArrayType.target, 
				target->referenceArrayType.index, 
				(INT_PTR)right );
		}
		mk_vm_push_stack( &vm->localStack, target );
		return MK_VM_EXECUTE_EXPR_RETURN_NEXTSTEP;
	}
}

MK_CLASS *mk_create_referecne_class( MK_VM_STRUCT *vm )
{
	MK_CLASS *result =
		mk_create_object( MK_TYPE_CLASS );
	MK_VARIABLE *insertMethod = NULL;
	result->nameThis = mk_get_symbol_name_ptr( vm, className );
	result->nameSuper = mk_get_symbol_name_ptr( vm, classSuper );

	mk_register_variable(
		vm,
		mk_create_default_native_method(
			vm,
			"=",
			MK_TYPE_VARIABLE | 
				MK_TYPE_ATTRIBUTE_VARIABLE_METHOD | 
				MK_TYPE_ATTRIBUTE_VARIABLE_METHOD_NATIVE |
				MK_TYPE_ATTRIBUTE_VARIABLE_METHOD_OPERATOR |
				MK_LEX_TYPE_RESERVED_MARK_EQUAL |
				MK_TYPE_ATTRIBUTE_VARIABLE_NEW_NATIVE_METHOD, 
			1,
			(INT_PTR)mk_reference_equal ),
		result );

	return result;
}
