
{
                         Linux_desktop_mklauncher.pp
                        -----------------------------

     This file is part of "mklauncher", launcher generator for free desktop.

     See the file COPYING.LGPL.txt, included in this distribution,
     for details about the copyright.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

     "mklauncher" Copyright (c) by "Fedoramedia team". Is free software,  This
     works in GNU/Linux, FreeBSD and others, is freed under the terms of the
     GPL (GNU GENERAL PUBLIC LICENSE). More information can be found in :

     http://www.fedoramedia.cf

     _________________________________________________________

     You can support this project by sending a donation to :


     PayPal [http://mklauncher.osdn.io/en/donate.html]
}

{******************************<< Header >>**********************************}

Unit linux_desktop_mklauncher;

{*****************************<< Unit Mode >>********************************}

{$MODE OBJFPC} {$H+} {$GOTO ON}

{*****************************<< Interface >>********************************}

Interface

{******************************<< Units >>***********************************}

Uses
     Commands_shell, Classes, FileUtil, Filemanager, Sysutils,
     linux_desktop_list, UTF8Process, Process, StrUtils,
     {$IFDEF UNIX}
     BaseUnix,
     {$ENDIF}
     Parser_commands, base64;

{******************************<< Labels >>**********************************}

(* Empty *)

{*******************************<< Const >>**********************************}

Const
      {--- Launcher location ---}

      gpl_Size  = 3;
      upl_Size  = 3;

      Launcher_path : Array [1..gpl_Size] of String = (

      ( '/usr/share/applications' ),
      ( '/usr/local/share/applications' ),
      ( '\usr\share\applications' )

      );

      Launcher_local_path : Array [1..upl_Size] of String = (

      ( '.local/share/applications' ),
      ( '.nix-profile/share/applications' ),
      ( 'local\share\applications' )

      );

      root_local = '/root/.local/share/applications';

      {--- UNIX alike ---}

      {$IFDEF UNIX}
      Passwd_file_1 = '/etc/passwd';
      Config_file   = '/etc/mklauncher.cfg';
      {$ENDIF}

      {--- UNIX simulated ---}

      {$IFDEF WINDOWS}
      Passwd_file_1 = '\etc\passwd';
      Config_file   = '\etc\mklauncher.cfg';
      {$ENDIF}

      Constraint = '\/:*?"<>|';

      {--- Polkit directory ---}

      Polkit_directory = '/usr/share/polkit-1/actions';

{*******************************<< Types >>**********************************}

Type

{******************************<< Objects >>*********************************}

  (* Empty *)

{*******************************<< Class >>**********************************}

{
 --------------------------------------------------------------
| Tmklauncher : Class                                          |
 --------------------------------------------------------------
}
  Tmklauncher = Class(TCommands_shell)

       Private

       mkl_Name,
       mkl_Path,
       mkl_Application,
       mkl_image,
       mkl_Comment,
       mkl_Keyword,
       mkl_Generic_name,
       mkl_Category,
       mkl_Version,
       mkl_remove_file,
       mkl_remove_input,
       mkl_Type,
       mkl_PathApp,
       mkl_URL,
       mkl_mime,
       mkl_Release,
       mkl_Polkit_name,
       System_desktop,
       Session_user,
       Error              : String;

       Parameter_found,
       mkl_terminal,
       mkl_StartupNotify,
       mkl_yes_all,
       mkl_Create_polkit,
       Update_desktop,
       Current_user_only  : Boolean;

       Launcher_file,
       Polkit_file,
       Insert_entry,
       Desktop_paths,
       mkl_Config_file    : TStringlist;

       Warning,
       c_Launcher_path,
       c_Launcher_local   : Word;

       File_manager       : TFileManager;
       Process_manager    : TProcessUTF8;
       System_users       : TFPList;
       User_ID            : LongInt;
       Polkit_v           : Array [1..9] of String;

       Function  Get_command_output(Command : String) : String;
       Procedure Get_system_users(Users : TFPList);
       Function  Get_system_desktop : String;
       Procedure Get_configuration(Configuration : TStringlist);
       Function  Search_constraint(Name : String) : Word;
       Procedure Syntax_error;
       Procedure Polkit_syntax_error;
       Function  Valid_DBus_name(Name : String) : String;
       Procedure Fix_desktop(New_desktop : String);
       Procedure Symbolic_link(New_link : String);
       Procedure Detect_launchers_path(Owner_user : Boolean; Uid,Gid : Longword);

       Public

       Constructor Create;
       Destructor  Destroy; Override;
       Procedure   DisplayInfo; Override;
       Procedure   Display_help; Override;
       Procedure   Process_command_line; Override;
       Procedure   Display(NewText : String);
  End;

{
 --------------------------------------------------------------
| TSystem_user : Class                                         |
 --------------------------------------------------------------
}
  TSystem_user = Class(TObject)

       Name     : String;
       Uid      : Longword;
       Gid      : Longword;
       Home_dir : String;
  End;

{*******************************<< Vars >>***********************************}

Var
    Error_st : Integer;

{***************************<< Headers Prc/Fun >>****************************}

  (* Empty *)

{****************************<< Implementation >>****************************}

Implementation

{****************************<< Methods/Objects >>***************************}

  (* Empty *)

{*****************************<< Methods/Class >>****************************}

{
 -------------------------------------------------
| Method Public Tmklauncher.Create                |
 -------------------------------------------------
}
Constructor Tmklauncher.Create;
Begin
      Inherited Create;

      mkl_Release              := '2022-08-12';
      Version                  := '1.0';
      Date                     := '[13/09/2018] - [12/08/2022]';
      Prompt                   := '(Command)';
      Error_status             := 0;
      Parameter_found          := False;
      c_Launcher_path          := 1;
      c_Launcher_local         := 1;

      {--- mklauncher parameters ---}

      mkl_Name                 := '';
      mkl_Path                 := Launcher_path[c_Launcher_path];
      mkl_Application          := '';
      mkl_image                := '';
      mkl_Comment              := '';
      mkl_Keyword              := '';
      mkl_Generic_name         := '';
      mkl_Category             := 'Other';
      Parameter_found          := False;
      mkl_terminal             := False;
      mkl_StartupNotify        := False;
      mkl_Version              := '';
      mkl_yes_all              := False;
      mkl_remove_file          := '';
      mkl_remove_input         := '';
      mkl_Type                 := 'Application';
      mkl_PathApp              := '';
      mkl_URL                  := '';
      mkl_mime                 := '';
      mkl_Polkit_name          := 'mkl.$$name.policy';
      mkl_Create_polkit        := False;
      System_desktop           := '';
      Session_user             := '';
      Error                    := '';
      Update_desktop           := True;
      Warning                  := 0;
      Current_user_only        := False;
      User_ID                  := -1;

      {$IFDEF UNIX}
      User_ID                  := fpGeteuid;
      {$ENDIF}

      Launcher_file            := TStringlist.Create;
      Polkit_file              := TStringlist.Create;
      Insert_entry             := TStringlist.Create;
      File_manager             := TFileManager.Create(_8191);
      Desktop_paths            := TStringlist.Create;
      mkl_Config_file          := TStringlist.Create;
      System_users             := TFPList.Create;

      Polkit_v[pk_path]        := '';
      Polkit_v[pk_local]       := '';
      Polkit_v[pk_remote]      := '';
      Polkit_v[pk_vendor_url]  := '';
      Polkit_v[pk_description] := '';
      Polkit_v[pk_message]     := '';
      Polkit_v[pk_icon_name]   := '';
      Polkit_v[pk_vendor]      := '';
      Polkit_v[pk_gui]         := '';
End;
{
 -------------------------------------------------
| Method Public Tmklauncher.Destroy               |
 -------------------------------------------------
}
Destructor Tmklauncher.Destroy;

Var
    Counter1 : Word;

Begin
      Launcher_file.Free;
      Polkit_file.Free;
      Insert_entry.Free;
      File_manager.Free;
      Desktop_paths.Free;
      mkl_Config_file.Free;

      If System_users.Count > 0 Then

      Begin
            For Counter1 := 0 to System_users.Count - 1 do

            Begin
                  TSystem_user(System_users.Items[Counter1]).Free;
            End;
      End;

      System_users.Free;

      Inherited Destroy;
End;
{
 -----------------------------------------------------
| Method Public Tmklauncher.DisplayInfo               |
 -----------------------------------------------------
}
Procedure Tmklauncher.DisplayInfo;
Begin
      If (Silence = False) and (Parameters_str = '') Then

      Begin
            Writeln('');
            Writeln('"mklauncher" version ',Version,' ',Date);
            Writeln('Launcher generator for free desktop, http://www.fedoramedia.cf');
            Writeln('Copyright (c) by "Fedoramedia team"');
            Writeln('Type "help" for obtain help.');
            Writeln('');
            Writeln('You can support this project by sending a donation to :');
            Writeln('');
            Writeln('PayPal [http://mklauncher.osdn.io/en/donate.html]');
            Writeln;
            Flush(Output);
      End;
End;
{
 ------------------------------------------------------
| Method Public Tmklauncher.Display_help               |
 ------------------------------------------------------
}
Procedure Tmklauncher.Display_help;
Begin
      If Silence = False Then

      Begin
            Writeln;
            Writeln('"mklauncher" version ',Version,' Release [' + mkl_Release + ']');
            Writeln('Date ',Date);
            Writeln('Launcher generator for free desktop, http://www.fedoramedia.cf');
            Writeln('Copyright (c) by "Fedoramedia team"');
            Writeln;
            Writeln('Command line :');
            Writeln;
            Writeln('mklauncher -n -e -i -p -c -k -gn -cat -terminal -sn -v -u -y -r ');
            Writeln('           -help -s -in -url -mime -nodesk -fix-desktop -link');
            Writeln('           -polkit                                           ');
            Writeln;
            Writeln('Options : ');
            Writeln;
            Writeln('-n "Name" Name of the launcher and the ".desktop" file that will be');
            Writeln('    created, example : -n "Firefox". The file is created by default');
            Writeln('    in "/usr/share/applications", to create the launcher only for');
            Writeln('    the current user add "-u". It is recommended to use a maximum');
            Writeln('    size of 85 characters.');
            Writeln;
            Writeln('-e "Name_app" Executable name, if this is not in a standard location,');
            Writeln('    "/usr/local/bin", "/usr/bin" or "/bin" you can include the full path,');
            Writeln('    example : -e "/opt/firefox/firefox".');
            Writeln;
            Writeln('-i "Image.png" Image of the launcher, you can include the full path,');
            Writeln('    example : -i "/opt/icons/firefox.png". If this value is omitted, a');
            Writeln('    standard icon is used. The images that are in : ');
            Writeln('    "/usr/local/share/icons" and "/usr/share/icons", can be used without');
            Writeln('    including your complete path. "mklauncher" provides a set of standard');
            Writeln('    images, see "Icons" below.');
            Writeln;
            Writeln('-p "/opt/emulator/roms" It allows to specify the working directory,');
            Writeln('    the application starts inside this directory.');
            Writeln;
            Writeln('-c "Web browser" Allows you to add a comment about the current');
            Writeln('    application.');
            Writeln;
            Writeln('-k "Browser;Web;" Allows you to add keywords for searches.');
            Writeln;
            Writeln('-gn "Web browser" Generic name for the launcher.');
            Writeln;
            Writeln('-cat "Network" Allows you to specify the category, which may be');
            Writeln('      Utility, Graphics, System, Network, Game, Office, AudioVideo,');
            Writeln('      Audio, Video, Education, Science, Settings, Development. If it');
            Writeln('      is not specified, the default category is "Other".');
            Writeln;
            Writeln('-terminal If this parameter is specified, the application is executed');
            Writeln('          in a terminal.');
            Writeln;
            Writeln('-sn If this parameter is specified, the application is executed with');
            Writeln('    the parameter "StartupNotify=true".');
            Writeln;
            Writeln('-v "5.0" Allows you to specify the version of the executable.');
            Writeln;
            Writeln('-u If this parameter is specified, change the location to create the ');
            Writeln('   file ".desktop" for "/home/[Current user]/.local/share/applications"');
            Writeln('   or "/root/.local/share/applications", the launcher is for the ');
            Writeln('   current user only. This location is also used by remove "-r".');
            Writeln;
            Writeln('-y It is used in conjunction with the "-r" parameter to remove');
            Writeln('   ".desktop" files without confirmation.');
            Writeln;
            Writeln('-r "Name" Delete the file "Name.desktop", this file is searched in');
            Writeln('   "/usr/share/applications", or in : ');
            Writeln('   "/root/.local/share/applications" and ');
            Writeln('   "/home/[Current user]/.local/share/applications" if the parameter');
            Writeln('   "-u" is used. The "-r" option can only erase launchers that were ');
            Writeln('    previously created with "mklauncher". To erase launchers that were');
            Writeln('    not created with "mklauncher", it is necessary to write the real');
            Writeln('    name of the file ".desktop" as it appears in :');
            Writeln('   "/usr/share/applications"');
            Writeln('    or');
            Writeln('   "/home/[Current user]/.local/share/applications" and ');
            Writeln('   "/root/.local/share/applications"');
            Writeln('    If the launcher is linked with a ".policy" file in the ');
            Writeln('   "/usr/share/polkit-1/actions" folder, this is deleted too.');
            Writeln;
            Writeln('-help Display this help.');
            Writeln;
            Writeln('-s Display only necessary information.');
            Writeln;
            Writeln('-in "Name[pt]=Evolution" Allows you to insert any optional entry ');
            Writeln('     in the ".desktop" file. Example : "GenericName[bn]=Groupware Suite",');
            Writeln('    "NoDisplay=true", "Hidden=true", "OnlyShowIn=GNOME", (OnlyShowIn Value :');
            Writeln('     GNOME,KDE,LXDE,LXQt,MATE,Razor,ROX,TDE,Unity,XFCE,EDE,Cinnamon,Pantheon,');
            Writeln('     Old), "DBusActivatable=true", "TryExec=/opt/firefox/firefox", and so on.');
            Writeln;
            Writeln('-url "http://www.fedoramedia.cf" Allows you to enter a "URL", ');
            Writeln('      if the launcher is a hyperlink.');
            Writeln;
            Writeln('-mime "text/plain;text/x-pascal;" Allows you to specify the file types ');
            Writeln('       that the current application can handle. Additionally, the "%f" ');
            Writeln('       and "%F" parameters can be used with the option "-e". To open');
            Writeln('       automatically, files of the type specified by "-mime", example :');
            Writeln;
            Writeln('# mklauncher -n "FPC coder" -e "fpcoder %f" -mime "text/plain;text/x-pascal;"');
            Writeln;
            Writeln('Combinations of predefined mime types can also be used, example :');
            Writeln;
            Writeln('# mklauncher -n "FPC coder" -e "fpcoder %f" -mime "text-editor:pascal-editor:"');
            Writeln;
            Writeln('"mklauncher" provides a set of combinations, see "Combinations of mime types"');
            Writeln('below.');
            Writeln;
            Writeln('-nodesk If this parameter is specified, the launcher is not added to the');
            Writeln('        desktop.');
            Writeln;
            Writeln('-fix-desktop "/home/[user]/Skrivbord" If is not possible to detect the path');
            Writeln('             of the desktop, use "-fix-desktop" to correct this problem.');
            Writeln;
            Writeln('-link "/opt/books/Debian manual.pdf" It allows creating a simple symbolic');
            Writeln('       link towards a folder or file in the desktop. It is important to ');
            Writeln('       remember that symbolic links can not be placed in the list of ');
            Writeln('       applications.');
            Writeln;
            Writeln('-polkit "path=/usr/bin/gedit" "local=root" "remote=null" Allows you to specify');
            Writeln('         the access requirements, so that a graphical application runs with ');
            Writeln('         administrative privileges on systems that use "Wayland". Only three');
            Writeln('         variables are mandatory "path", "local" and "remote". "path" contains');
            Writeln('         the path of the application which must be executed with administrative');
            Writeln('         permissions. "local" and "remote", they represent the type of users ');
            Writeln('        "local users" and "remote users". "local" and "remote" contain the ');
            Writeln('         requirements for execution with administrative privileges, these can ');
            Writeln('         be the following :');
            Writeln;
            Writeln('         root       : Administrator password is required');
            Writeln('         password   : User password is required');
            Writeln('         user       : No password required to run as administrator');
            Writeln('         null       : It is not allowed to run this application');
            Writeln('         root_k     : Same as "root" but will ask for the password again');
            Writeln('         password_k : Same as "password" but will ask for the password again');
            Writeln;
            Writeln('         The following optional variables can be included, these are displayed');
            Writeln('         in the authentication agent : "message" A human readable message, ');
            Writeln('         example : "message=Requires authentication". "description" A human');
            Writeln('         readable description of the action, example : ');
            Writeln('         "description=Install unsigned software". "vendor" The name of the ');
            Writeln('         project or vendor, example : "vendor=GNOME Project". "vendor_url"');
            Writeln('         A URL to the project or vendor, example : ');
            Writeln('         "vendor_url=https://www.freedesktop.org". "icon_name" An icon ');
            Writeln('         representing the project or vendor, example : ');
            Writeln('         "icon_name=accessories-text-editor". "gui" This variable is used ');
            Writeln('         with applications that do not have a graphical interface, example :');
            Writeln('         "gui=no_gui"');
            Writeln;
            Writeln('- NOTE -');
            Writeln('');
            Writeln('Code       Description');
            Writeln('_______________________');
            Writeln('');
            Writeln('%f         A single file.');
            Writeln('%F         A list of files.');
            Writeln('%u         A single URL.');
            Writeln('%U         A list of URLs.');
            Writeln;
            Writeln;
            Writeln('======= Examples =======');
            Writeln('');
            Writeln('');
            Writeln('Create launcher without custom image :');
            Writeln('');
            Writeln('# mklauncher -n "Wine config" -e "winecfg"');
            Writeln('');
            Writeln('');
            Writeln('Create launcher with standard image :');
            Writeln('');
            Writeln('# mklauncher -n "Wine config" -e "winecfg" -i "mk-wine.png"');
            Writeln('');
            Writeln('');
            Writeln('Create launcher with custom image :');
            Writeln('');
            Writeln('# mklauncher -n "Wine config" -e "winecfg" -i "/opt/icons/wine.png"');
            Writeln('');
            Writeln('');
            Writeln('Create launcher with executable in a non-standard location : ');
            Writeln('');
            Writeln('# mklauncher -n "Firefox web browser" -e "/opt/firefox/firefox %U" -i "/opt/icons/firefox.png" -mime "web-browser:"');
            Writeln('');
            Writeln('');
            Writeln('Create launcher with executable in a non-standard location, for the');
            Writeln('current user only : ');
            Writeln('');
            Writeln('# mklauncher -u -n "Firefox web browser" -e "/opt/firefox/firefox %U" -i "/opt/icons/firefox.png" -mime "web-browser:"');
            Writeln('');
            Writeln('');
            Writeln('======= Games =======');
            Writeln('');
            Writeln('');
            Writeln('Launch an emulator through "wine" : ');
            Writeln('');
            Writeln('# mklauncher -n "Crude Buster" -e "wine MameUI32.exe roms/cbuster.zip" -i "/opt/icons/rb-Crudeb.png" -p "/opt/mame32" -cat "Game" -k "wine;mame;Game;"');
            Writeln('');
            Writeln('');
            Writeln('Launch a "Linux" emulator : ');
            Writeln('');
            Writeln('# mklauncher -n "Circle of the moon" -e "mednafen ''Circle of The Moon.gba.zip''" -i "/opt/icons/circlemoon.png" -p "/opt/GameBoy" -cat "Game" -k "mednafen;GameBoy;Game;"');
            Writeln('');
            Writeln('');
            Writeln('======= Java =======');
            Writeln('');
            Writeln('');
            Writeln('Launch a "Java" application : ');
            Writeln('');
            Writeln('# mklauncher -n "JEditor" -e "java -jar JEditor.jar" -i "/opt/icons/JEditor.png" -p "/opt/JavaApps" -cat "Development" -k "Editor;Java;Development;"');
            Writeln('');
            Writeln('');
            Writeln('======= Automatic launcher =======');
            Writeln('');
            Writeln('');
            Writeln('Create a "Java" automatic launcher, see option "-mime" above : ');
            Writeln('');
            Writeln('# mklauncher -n "Java launcher" -e "java -jar %f" -i "mk-java.png" -p "/opt/JavaApps" -cat "Development" -k "Java;Launcher;Development;" -mime "application/java-archive;application/x-java-archive"');
            Writeln('');
            Writeln('Select an application "Java .jar", press "right click", and choose');
            Writeln('"Run with Java launcher". Automatic launchers for other file types,');
            Writeln('can be created.');
            Writeln('');
            Writeln('');
            Writeln('======= Folders =======');
            Writeln('');
            Writeln('');
            Writeln('Open folder by means of "xdg-utils" package : ');
            Writeln('');
            Writeln('# mklauncher -n "Global launchers" -e "xdg-open ''/usr/share/applications''" -i "mk-folder.png" -cat "System" -k "Global;Launcher;"');
            Writeln('');
            Writeln('"xdg-open" Open a folder using the default file manager. This option');
            Writeln(' requires that the "xdg-utils" package be installed.');
            Writeln('');
            Writeln('');
            Writeln('Open folder directly : ');
            Writeln('');
            Writeln('# mklauncher -n "Global launchers" -e "nautilus /usr/share/applications" -i "mk-folder.png" -cat "System" -k "Global;Launcher;"');
            Writeln('');
            Writeln('# mklauncher -n "Global launchers" -e "dolphin /usr/share/applications" -i "mk-folder.png" -cat "System" -k "Global;Launcher;"');
            Writeln('');
            Writeln('# mklauncher -n "Global launchers" -e "thunar /usr/share/applications" -i "mk-folder.png" -cat "System" -k "Global;Launcher;"');
            Writeln('');
            Writeln('');
            Writeln('======= Files =======');
            Writeln('');
            Writeln('');
            Writeln('Open file by means of "xdg-utils" package : ');
            Writeln('');
            Writeln('# mklauncher -n "Debian GNU Linux" -e "xdg-open ''/opt/books/Debian manual.pdf''" -i "mk-PDF.png" -cat "Education" -k "Linux;manual;"');
            Writeln('');
            Writeln('"xdg-open" Open a file using the application appropriate for the ');
            Writeln('file type. This option requires that the "xdg-utils" package be ');
            Writeln('installed.');
            Writeln('');
            Writeln('');
            Writeln('Open PDF file directly : ');
            Writeln('');
            Writeln('# mklauncher -n "Debian GNU Linux" -e "evince ''/opt/books/Debian manual.pdf''" -i "mk-PDF.png" -cat "Education" -k "Linux;manual;"');
            Writeln('');
            Writeln('# mklauncher -n "Debian GNU Linux" -e "atril ''/opt/books/Debian manual.pdf''" -i "mk-PDF.png" -cat "Education" -k "Linux;manual;"');
            Writeln('');
            Writeln('');
            Writeln('Create a simple symbolic link, on the desktop : ');
            Writeln('');
            Writeln('# mklauncher -link "/opt/books/Debian manual.pdf"');
            Writeln('');
            Writeln('');
            Writeln('======= URL =======');
            Writeln('');
            Writeln('');
            Writeln('Open website by means of "xdg-utils" package : ');
            Writeln('');
            Writeln('# mklauncher -n "GNU Linux OS" -e "xdg-open https://www.linux.org" -i "mk-internet.png" -cat "Network"');
            Writeln('');
            Writeln('');
            Writeln('Using the option "-url" : ');
            Writeln('');
            Writeln('# mklauncher -n "GNU Linux OS" -url "https://www.linux.org" -i "mk-internet.png" -cat "Network"');
            Writeln('');
            Writeln('Some desktops only allow launchers of websites created with the');
            Writeln('"-url" option in the Desktop folder.');
            Writeln('');
            Writeln('');
            Writeln('Open web site directly : ');
            Writeln('');
            Writeln('# mklauncher -n "GNU Linux OS" -e "firefox https://www.linux.org" -i "mk-internet.png" -cat "Network"');
            Writeln('');
            Writeln('');
            Writeln('======= Launch how root =======');
            Writeln('');
            Writeln('');
            Writeln('NORMAL');
            Writeln('------');
            Writeln('');
            Writeln('');
            Writeln('Run by means of terminal : ');
            Writeln('');
            Writeln('# mklauncher -n "Gedit(root)" -e "su -c ''gedit''" -i "mk-text.png" -terminal -cat "Utility" -k "Gedit;root;"');
            Writeln('');
            Writeln('');
            Writeln('Run by means of "gksu" : ');
            Writeln('');
            Writeln('# mklauncher -n "Gedit(root)" -e "gksu gedit" -i "mk-text.png" -cat "Utility" -k "Gedit;root;"');
            Writeln('');
            Writeln('This option requires that the "gksu" package be installed.');
            Writeln('');
            Writeln('');
            Writeln('WAYLAND POLKIT');
            Writeln('--------------');
            Writeln('');
            Writeln('To run applications on Wayland with administrative privileges, it is necessary');
            Writeln('to use "POLKIT". Polkit is used for controlling system-wide privileges. It ');
            Writeln('works through ".policy" files that contain access requirements for local and ');
            Writeln('remote users. "mklauncher" automates the creation of ".policy" files.');
            Writeln('');
            Writeln('Example :');
            Writeln('');
            Writeln('Run "Gedit" in root mode : ');
            Writeln('');
            Writeln('# mklauncher -n "Gedit(root)" -e "pkexec gedit" -i "mk-text.png" -cat "Utility" -k "Gedit;root;" -polkit "path=/usr/bin/gedit" "local=root" "remote=null"');
            Writeln('');
            Writeln('');
            Writeln('======= Remove launcher =======');
            Writeln('');
            Writeln('');
            Writeln('# mklauncher -r "Firefox web browser"');
            Writeln('');
            Writeln('');
            Writeln('Remove launcher for current user only :');
            Writeln('');
            Writeln('# mklauncher -u -r "Firefox web browser"');
            Writeln('');
            Writeln('');
            Writeln('- NOTE -');
            Writeln('');
            Writeln('The "-r" option can only erase launchers that were previously created');
            Writeln('with "mklauncher". To erase launchers that were not created with');
            Writeln('"mklauncher", it is necessary to write the real name of the file');
            Writeln('".desktop". You can use the file manager to copy and paste the names');
            Writeln('of the ".desktop" files.');
            Writeln;
            Writeln;
            Writeln('# mklauncher -r ''start_smb''');
            Writeln('');
            Writeln('');
            Writeln('Remove launcher for current user only :');
            Writeln('');
            Writeln('# mklauncher -u -r ''start_smb''');
            Writeln;
            Writeln;
            Writeln('It is also possible to eliminate the launchers directly :');
            Writeln('');
            Writeln('# rm ''/usr/share/applications/start_smb.desktop''');
            Writeln('');
            Writeln('# rm ''/home/[Current user]/.local/share/applications/start_smb.desktop''');
            Writeln('');
            Writeln('');
            Writeln('If the launcher is linked with a ".policy" file in the ');
            Writeln('"/usr/share/polkit-1/actions" folder, this is deleted too.');
            Writeln('');
            Writeln('');
            Writeln('======= Fix desktop =======');
            Writeln('');
            Writeln('');
            Writeln('If is not possible to detect the path of the desktop, use "-fix-desktop"');
            Writeln('to correct this problem. Example :');
            Writeln('');
            Writeln('# mklauncher -fix-desktop "/home/[user]/darbastalis"');
            Writeln('');
            Writeln('# mklauncher -fix-desktop "/home/[user]/Scriptorio"');
            Writeln('');
            Writeln('# mklauncher -fix-desktop "/home/[user]/Namizje"');
            Writeln('');
            Writeln('');
            Writeln('======= Icons =======');
            Writeln('');
            Writeln('');
            Writeln('mk-app.png       mk-script.png      mk-wine.png    mk-java.png');
            Writeln('mk-game.png      mk-link.png        mk-folder.png  mk-remote.png');
            Writeln('mk-group.png     mk-file.png        mk-text.png    mk-image.png');
            Writeln('mk-html.png      mk-audio.png       mk-video.png   mk-package.png');
            Writeln('mk-photo.png     mk-media.png       mk-print.png   mk-optical.png');
            Writeln('mk-pendrive.png  mk-server.png      mk-pc.png      mk-script2.png');
            Writeln('mk-PDF.png       mk-game2.png       mk-game3.png   mk-game4.png');
            Writeln('mk-python.png    mk-ruby.png        mk-php.png     mk-js.png');
            Writeln('mk-graphics.png  mk-freepascal.png  mk-hint.png    mk-internet.png');
            Writeln;
            Writeln;
            Writeln('======= Combinations of mime types =======');
            Writeln;
            Writeln;
            Writeln('web-browser:   video-editor:   python-editor:  js-editor:');
            Writeln('text-editor:   design-editor:  c-editor:       java-editor:');
            Writeln('image-editor:  audio-editor:   c++-editor:     perl-editor:');
            Writeln('pdf-editor:    script-editor:  pascal-editor:  ');
            Writeln('mail-editor:   ruby-editor:    php-editor:');
            Writeln;
            Writeln;
            Writeln('It is possible to use several combinations at the same time, example :');
            Writeln('');
            Writeln('    -mime "text-editor:c-editor:c++-editor:"');
            Writeln('');
            Writeln('    -mime "php-editor:image/png;image/jpeg;"');
            Writeln('');
            Writeln('To view the details of a specific combination, execute "mklauncher" with ');
            Writeln('the name of the desired type combination, such as :');
            Writeln('');
            Writeln('# mklauncher -mime "web-browser:"');
            Writeln('# mklauncher -mime "text-editor:"');
            Writeln('');
            Writeln('To see all the type combinations in detail, run the command :');
            Writeln('');
            Writeln('# mklauncher -mime "predefined-list"');
            Writeln('');
            Writeln('To create a text file, run the command :');
            Writeln('');
            Writeln('# mklauncher -mime "predefined-list" > "predefined-list.txt"');
            Writeln('');
            Writeln('The text file "predefined-list.txt" contains detailed information on each ');
            Writeln('combination of mime types.');
            Writeln;
            Writeln;
            Writeln('======= Exit codes =======');
            Writeln('');
            Writeln('No error                              0');
            Writeln('Syntax error                          1');
            Writeln('Command not found                     2');
            Writeln('Executed as administrator (root)      3');
            Writeln('File not found                        4');
            Writeln('Operation aborted                     5');
            Writeln('Error directory not found             6');
            Writeln('Invalid character                     7');
            Writeln('Error can not delete file             8');
            Writeln('Error name of the launcher too large  9');
            Writeln('Polkit syntax error                   10');
            Writeln('Polkit error unable to create file    11');
            Writeln('');
            Writeln('');
            Writeln('======= Warnings =======');
            Writeln('');
            Writeln('Error loading user list                   -1');
            Writeln('No desktop path                           -2');
            Writeln('Unable to create config file              -3');
            Writeln('Session not detected                      -4');
            Writeln('- NOTE - unable to create file            -5');
            Writeln('- NOTE - Polkit file can not delete file  -6');
            Writeln('- NOTE - unable to access file            -7');
            Writeln('');
            Writeln('');
            Writeln('_____________________________________________________________________');
            Writeln('You can report any defect or request an improvement at this address :');
            Writeln('');
            Writeln('OSDN [https://osdn.net/ticket/newticket.php?group_id=11497]');
            Writeln('');
            Writeln('_______________________________________________________');
            Writeln('You can support this project by sending a donation to :');
            Writeln('');
            Writeln('PayPal [http://mklauncher.osdn.io/en/donate.html]');
            Writeln('');

            Flush(Output);
      End;
End;
{
 --------------------------------------------------------------
| Method Public Tmklauncher.Process_command_line               |
 --------------------------------------------------------------
}
Procedure Tmklauncher.Process_command_line;

Label
      Make_remove;

Var
    NewPosition,
    Counter1,
    Counter2,
    Counter3,
    Constraint_pos         : Word;

    Launcher_to_remove,
    Launcher_No_DBus,
    Delete_polkit_file     : Array [0..510] of Char;

    User_                  : TSystem_user;

    Desktop_file,
    User_desktop,
    pk_Parameter,
    Launcher_path_remove   : String;

    Owner_user,
    FE_Launcher_to_remove,
    FE_Launcher_No_DBus    : Boolean;

Begin
      {--- No parameters ---}

      If Parameters.Count = 0 Then

      Begin
            Display_help;
            LowCommanLine := 'quit';
            Display('Exit');
            Flush(Output);
            Exit;
      End;

      {--- help parameters ---}

      If (Find_parameter('help',NewPosition)   = True) or
         (Find_parameter('-help',NewPosition)  = True) or
         (Find_parameter('--help',NewPosition) = True) Then

      Begin
            Display_help;
            LowCommanLine := 'quit';
            Display('Exit');
            Flush(Output);
            Exit;
      End;

      {--- Get current ID ---}

      If User_ID <> 0 Then

      Begin
            If Get_command_output('id -u') <> '0' Then

            Begin
                  LowCommanLine := 'quit';
                  Error_status  := 3;
                  Display('Error, this command must be executed as administrator (root).');
                  Exit;
            End;

            User_ID := 0;
      End;

      {--- Get session user ---}

      Session_user := Get_command_output('logname');

      If Error <> '' Then

      Begin
            Error_status := -4;

            Display('');
            Display('- NOTE -');
            Display('');
            Display('Session not detected');
            Display(Error);
            Display('');

            Error          := '';
            Update_desktop := False;

            Flush(Output);
      End;

      {--- -fix-desktop "/home/[user]/Skrivbord" ---}

      If (Find_parameter('-fix-desktop',NewPosition) = True) Then

      Begin
            If NewPosition + 1 <= (Parameters.Count - 1) Then

            Begin
                  Fix_desktop(Parameters.Strings[NewPosition + 1]);
                  LowCommanLine := 'quit';
                  Exit;
            End

            Else

            Begin
                  Syntax_error;
                  Exit;
            End;
      End;

      {--- Get system users ---}

      Get_system_users(System_users);

      If Error <> '' Then

      Begin
            Error_status := -1;
            Display('');
            Display('- NOTE -');
            Display('');
            Display('Error loading user list.');
            Display(Error);
            Display('');

            Error          := '';
            Update_desktop := False;

            Flush(Output);
      End;

      {--- Owner status ---}

      Owner_user := False;

      If System_users.Count > 0 Then

      Begin
            For Counter2 := 0 to System_users.Count - 1 do

            Begin
                  User_ := TSystem_user(System_users.Items[Counter2]);

                  If User_.Name = Session_user Then

                  Begin
                        Owner_user := True;
                        Break;
                  End;
            End;
      End;

      {--- Detect global local launchers path ---}

      Detect_launchers_path(Owner_user,User_.Uid,User_.Gid);

      {--- -nodesk ---}

      If (Find_parameter('-nodesk',NewPosition) = True) Then

      Begin
            Update_desktop  := False;
            Parameter_found := True;
      End;

      {--- Get system desktop ---}

      If Update_desktop = True Then

      Begin
            System_desktop := Get_system_desktop;

            If Update_desktop = False Then

            Begin
                  Error_status := -2;

                  Display('');
                  Display('- NOTE -');
                  Display('');
                  Display('It is not possible to detect the path of the desktop, use "-fix-desktop"');
                  Display('to correct this problem. Example :');
                  Display('');
                  Display('# mklauncher -fix-desktop "/home/[user]/darbastalis"');
                  Display('');
                  Display('# mklauncher -fix-desktop "/home/[user]/Scriptorio"');
                  Display('');
                  Display('# mklauncher -fix-desktop "/home/[user]/Namizje"');
                  Display('');

                  Flush(Output);
            End;
      End;

      If Warning = 1 Then

      Begin
            Error_status := -3;

            Display('');
            Display('- NOTE -');
            Display('');
            Display('Unable to create ' + Config_file);
            Display('');

            Warning := 0;
            Flush(Output);
      End;

      {--- -link "/opt/books/Debian manual.pdf" ---}

      If (Find_parameter('-link',NewPosition) = True) Then

      Begin
            If NewPosition + 1 <= (Parameters.Count - 1) Then

            Begin
                  Symbolic_link(Parameters.Strings[NewPosition + 1]);
                  LowCommanLine := 'quit';
                  Exit;
            End

            Else

            Begin
                  Syntax_error;
                  Exit;
            End;
      End;

      {--- Process parameters ---}

      {--- Silence ---}

      If (Find_parameter('-s',NewPosition)  = True) or
         (Find_parameter('--s',NewPosition) = True) Then

      Begin
            Silence         := True;
            Parameter_found := True;
      End;

      {--- -url "http://www.fedoramedia.cf" ---}

      If (Find_parameter('-url',NewPosition) = True) Then

      Begin
            If NewPosition + 1 <= (Parameters.Count - 1) Then

            Begin
                  mkl_Type        := 'Link';
                  mkl_URL         := Parameters.Strings[NewPosition + 1];
                  Parameter_found := True;
            End

            Else

            Begin
                  Syntax_error;
                  Exit;
            End;
      End;

      {--- -n "Name" ---}

      If (Find_parameter('-n',NewPosition) = True) Then

      Begin
            If NewPosition + 1 <= (Parameters.Count - 1) Then

            Begin
                  mkl_Name       := Parameters.Strings[NewPosition + 1];
                  Constraint_pos := Search_constraint(mkl_Name);

                  If Constraint_pos <> 0 Then

                  Begin
                        LowCommanLine := 'quit';
                        Error_status  := 7;

                        Display('Error "' + mkl_Name + '" invalid character "' + mkl_Name[Constraint_pos] + '"');
                        Exit;
                  End;

                  Parameter_found := True;
            End

            Else

            Begin
                  Syntax_error;
                  Exit;
            End;
      End;

      {--- -e "Name_app" ---}

      If (Find_parameter('-e',NewPosition) = True) and (mkl_URL = '') Then

      Begin
            If NewPosition + 1 <= (Parameters.Count - 1) Then

            Begin
                  mkl_Application := Parameters.Strings[NewPosition + 1];
                  Parameter_found := True;
            End

            Else

            Begin
                  Syntax_error;
                  Exit;
            End;
      End;

      {--- -mime "text/plain;text/x-pascal;" ---}

      If (Find_parameter('-mime',NewPosition) = True) Then

      Begin
            If NewPosition + 1 <= (Parameters.Count - 1) Then

            Begin
                  mkl_mime := LowParameters.Strings[NewPosition + 1];

                  If Parameters.Count = 2 Then

                  Begin
                        If mkl_mime = cml_display_com Then

                        Begin
                              {--- Display command ---}

                              Writeln('');

                              For Counter1 := 1 to cml_Size do

                              Begin
                                    Writeln('_______________________________________________________________________________');
                                    Writeln('');
                                    Writeln(cmt_list[Counter1][cml_Upper]);
                                    Writeln('');
                                    Writeln(cmt_list[Counter1][cml_Lower]);
                                    Writeln('');
                              End;

                              Flush(Output);

                              LowCommanLine := 'quit';
                              Exit;
                        End

                        Else

                        Begin
                              {--- Display combinations of mime types ---}

                              For Counter1 := 1 to cml_Size do

                              Begin
                                    If (mkl_mime = cmt_list[Counter1][cml_Upper]) and (Parameters.Count = 2) Then

                                    Begin
                                          Writeln('');
                                          Writeln('_______________________________________________________________________________');
                                          Writeln('');
                                          Writeln(cmt_list[Counter1][cml_Upper]);
                                          Writeln('');
                                          Writeln(cmt_list[Counter1][cml_Lower]);
                                          Writeln('');

                                          LowCommanLine := 'quit';
                                          Exit;
                                    End;
                              End;
                        End;
                  End;

                  If AnsiContainsText(mkl_mime,':') = True Then

                  Begin
                        For Counter1 := 1 to cml_Size do

                        Begin
                              mkl_mime := AnsiReplaceText(mkl_mime,cmt_list[Counter1][cml_Upper],cmt_list[Counter1][cml_Lower]);
                        End;
                  End;

                  Parameter_found := True;
            End

            Else

            Begin
                  Syntax_error;
                  Exit;
            End;
      End;

      {--- -i "Image.png" ---}

      If (Find_parameter('-i',NewPosition) = True) Then

      Begin
            If NewPosition + 1 <= (Parameters.Count - 1) Then

            Begin
                  mkl_image       := Parameters.Strings[NewPosition + 1];
                  Parameter_found := True;
            End

            Else

            Begin
                  Syntax_error;
                  Exit;
            End;
      End;

      {--- -p "/opt/multiemulator" ---}

      If (Find_parameter('-p',NewPosition) = True) Then

      Begin
            If NewPosition + 1 <= (Parameters.Count - 1) Then

            Begin
                  mkl_PathApp     := Parameters.Strings[NewPosition + 1];
                  Parameter_found := True;
            End

            Else

            Begin
                  Syntax_error;
                  Exit;
            End;
      End;

      {--- -in "Name[pt]=Evolution" ---}

      If (Find_parameter('-in',NewPosition) = True) Then

      Begin
            For Counter1 := NewPosition to Parameters.Count - 1 do

            Begin
                  If LowParameters.Strings[Counter1] = '-in' Then

                  Begin
                        If Counter1 + 1 <= (Parameters.Count - 1) Then

                        Begin
                              Insert_entry.Add(Parameters.Strings[Counter1 + 1]);
                        End

                        Else

                        Begin
                              Syntax_error;
                              Exit;
                        End;
                  End;
            End;

            Parameter_found := True;
      End;

      {--- -c "Web browser" ---}

      If (Find_parameter('-c',NewPosition) = True) Then

      Begin
            If NewPosition + 1 <= (Parameters.Count - 1) Then

            Begin
                  mkl_Comment     := Parameters.Strings[NewPosition + 1];
                  Parameter_found := True;
            End

            Else

            Begin
                  Syntax_error;
                  Exit;
            End;
      End;

      {--- -k "Browser;Web;" ---}

      If (Find_parameter('-k',NewPosition) = True) Then

      Begin
            If NewPosition + 1 <= (Parameters.Count - 1) Then

            Begin
                  mkl_Keyword     := Parameters.Strings[NewPosition + 1];
                  Parameter_found := True;
            End

            Else

            Begin
                  Syntax_error;
                  Exit;
            End;
      End;

      {--- -gn "Web Browser" ---}

      If (Find_parameter('-gn',NewPosition) = True) Then

      Begin
            If NewPosition + 1 <= (Parameters.Count - 1) Then

            Begin
                  mkl_Generic_name := Parameters.Strings[NewPosition + 1];
                  Parameter_found  := True;
            End

            Else

            Begin
                  Syntax_error;
                  Exit;
            End;
      End;

      {--- -cat "Network" ---}

      If (Find_parameter('-cat',NewPosition) = True) Then

      Begin
            If NewPosition + 1 <= (Parameters.Count - 1) Then

            Begin
                  mkl_Category    := Parameters.Strings[NewPosition + 1];
                  Parameter_found := True;
            End

            Else

            Begin
                  Syntax_error;
                  Exit;
            End;
      End;

      {--- -terminal ---}

      If (Find_parameter('-terminal',NewPosition) = True) Then

      Begin
            mkl_terminal    := True;
            Parameter_found := True;
      End;

      {--- -sn ---}

      If (Find_parameter('-sn',NewPosition) = True) Then

      Begin
            mkl_StartupNotify := True;
            Parameter_found   := True;
      End;

      {--- -v "5.0" ---}

      If (Find_parameter('-v',NewPosition) = True) Then

      Begin
            If NewPosition + 1 <= (Parameters.Count - 1) Then

            Begin
                  mkl_Version     := Parameters.Strings[NewPosition + 1];
                  Parameter_found := True;
            End

            Else

            Begin
                  Syntax_error;
                  Exit;
            End;
      End;

      {--- -u ---}

      If (Find_parameter('-u',NewPosition) = True) Then

      Begin
            If Session_user <> 'root' Then

            Begin
                  mkl_Path := _DS_ + 'home' + _DS_ + Session_user + _DS_ + Launcher_local_path[c_Launcher_local];
            End

            Else

            Begin
                  mkl_Path := root_local;
            End;

            If DirectoryExists(mkl_Path) = True Then

            Begin
                  Parameter_found   := True;
                  Current_user_only := True;
            End

            Else

            Begin
                  LowCommanLine := 'quit';
                  Error_status  := 6;

                  Display('Error, directory "' + mkl_Path + '" not found.');
                  Exit;
            End;
      End;

      {--- -y ---}

      If (Find_parameter('-y',NewPosition) = True) Then

      Begin
            mkl_yes_all     := True;
            Parameter_found := True;
      End;

      {--- -r "Name" ---}

      If (Find_parameter('-r',NewPosition) = True) Then

      Begin
            If NewPosition + 1 <= (Parameters.Count - 1) Then

            Begin
                  mkl_remove_file := Parameters.Strings[NewPosition + 1];
                  Parameter_found := True;

                  Goto Make_remove;
            End

            Else

            Begin
                  Syntax_error;
                  Exit;
            End;
      End;

      {--- -polkit ---}

      If (Find_parameter('-polkit',NewPosition) = True) Then

      Begin
            {--- Nine parameters for -polkit ---}

            For Counter1 := 1 to 9 do

            Begin
                  NewPosition := NewPosition + 1;

                  If NewPosition <= (Parameters.Count - 1) Then

                  Begin
                        If Pos('=',LowParameters.Strings[NewPosition]) <> 0 Then

                        Begin
                              {--- Extract parameter ---}

                              pk_Parameter := LowParameters.Strings[NewPosition];
                              Delete(pk_Parameter,Pos('=',pk_Parameter),Length(pk_Parameter) - Pos('=',pk_Parameter) + 1);

                              If pos('path',pk_Parameter) <> 0 Then

                              Begin
                                    {--- "pk_path" original value ---}

                                    Polkit_v[pk_path] := Parameters.Strings[NewPosition];
                                    Delete(Polkit_v[pk_path],1,Pos('=',Polkit_v[pk_path]));
                              End

                              Else If pos('local',pk_Parameter) <> 0 Then

                              Begin
                                    Polkit_v[pk_local] := LowParameters.Strings[NewPosition];
                                    Delete(Polkit_v[pk_local],1,Pos('=',Polkit_v[pk_local]));
                              End

                              Else If pos('remote',pk_Parameter) <> 0 Then

                              Begin
                                    Polkit_v[pk_remote] := LowParameters.Strings[NewPosition];
                                    Delete(Polkit_v[pk_remote],1,Pos('=',Polkit_v[pk_remote]));
                              End

                              Else If pos('vendor_url',pk_Parameter) <> 0 Then

                              Begin
                                    {--- "pk_vendor_url" original value ---}

                                    Polkit_v[pk_vendor_url] := Parameters.Strings[NewPosition];
                                    Delete(Polkit_v[pk_vendor_url],1,Pos('=',Polkit_v[pk_vendor_url]));
                              End

                              Else If pos('description',pk_Parameter) <> 0 Then

                              Begin
                                    {--- "pk_description" original value ---}

                                    Polkit_v[pk_description] := Parameters.Strings[NewPosition];
                                    Delete(Polkit_v[pk_description],1,Pos('=',Polkit_v[pk_description]));
                              End

                              Else If pos('message',pk_Parameter) <> 0 Then

                              Begin
                                    {--- "pk_message" original value ---}

                                    Polkit_v[pk_message] := Parameters.Strings[NewPosition];
                                    Delete(Polkit_v[pk_message],1,Pos('=',Polkit_v[pk_message]));
                              End

                              Else If pos('icon_name',pk_Parameter) <> 0 Then

                              Begin
                                    {--- "pk_icon_name" original value ---}

                                    Polkit_v[pk_icon_name] := Parameters.Strings[NewPosition];
                                    Delete(Polkit_v[pk_icon_name],1,Pos('=',Polkit_v[pk_icon_name]));
                              End

                              Else If pos('vendor',pk_Parameter) <> 0 Then

                              Begin
                                    {--- "pk_vendor" original value ---}

                                    Polkit_v[pk_vendor] := Parameters.Strings[NewPosition];
                                    Delete(Polkit_v[pk_vendor],1,Pos('=',Polkit_v[pk_vendor]));
                              End

                              Else If pos('gui',pk_Parameter) <> 0 Then

                              Begin
                                    Polkit_v[pk_gui] := LowParameters.Strings[NewPosition];
                                    Delete(Polkit_v[pk_gui],1,Pos('=',Polkit_v[pk_gui]));
                              End

                              Else

                              Begin
                                    Break;
                                    Polkit_syntax_error;
                                    Display(Parameters.Strings[NewPosition]);
                                    Exit;
                              End;
                        End

                        Else

                        Begin
                              If (Polkit_v[pk_path]   <> '') and
                                 (Polkit_v[pk_local]  <> '') and
                                 (Polkit_v[pk_remote] <> '') Then

                              Begin
                                    Break;
                              End

                              Else

                              Begin
                                    Break;
                                    Polkit_syntax_error;
                                    Exit;
                              End;
                        End;
                  End

                  Else

                  Begin
                        If (Polkit_v[pk_path]   <> '') and
                           (Polkit_v[pk_local]  <> '') and
                           (Polkit_v[pk_remote] <> '') Then

                        Begin
                              Break;
                        End

                        Else

                        Begin
                              Break;
                              Polkit_syntax_error;
                              Exit;
                        End;
                  End;
            End;

            mkl_Create_polkit := True;
            Parameter_found   := True;
      End;

      {--- Parameter not found ---}

      If Parameter_found = False Then

      Begin
            LowCommanLine := 'quit';
            Error_status  := 2;

            Display('Error : "Command not found", use "mklauncher -help" for obtain help.');
            Exit;
      End;

      {--- Execute commands ---}

      {--- Set launcher_file ---}

      Launcher_file.Add('[Desktop Entry]');
      Launcher_file.Add('Encoding=UTF-8');
      Launcher_file.Add('Type=' + mkl_Type);

      {--- URL ---}

      If mkl_URL <> '' Then

      Begin
            Launcher_file.Add('URL=' + mkl_URL);
      End;

      {--- Name ---}

      If mkl_Name <> '' Then

      Begin
            Launcher_file.Add('Name=' + mkl_Name);
      End

      Else

      Begin
            Syntax_error;
            Exit;
      End;

      {--- Generic name ---}

      If mkl_Generic_name <> '' Then

      Begin
            Launcher_file.Add('GenericName=' + mkl_Generic_name);
      End;

      {--- Application ---}

      If mkl_Application <> '' Then

      Begin
            Launcher_file.Add('Exec=' + mkl_Application);
      End;

      {--- Mime Type ---}

      If mkl_mime <> '' Then

      Begin
            Launcher_file.Add('MimeType=' + mkl_mime);
      End;

      {--- Version ---}

      If mkl_Version <> '' Then

      Begin
            Launcher_file.Add('Version=' + mkl_Version);
      End;

      {--- Image ---}

      If mkl_image <> '' Then

      Begin
            Launcher_file.Add('Icon=' + mkl_image);
      End;

      {--- Path ---}

      If mkl_PathApp <> '' Then

      Begin
            Launcher_file.Add('Path=' + mkl_PathApp);
      End;

      {--- StartupNotify ---}

      If mkl_StartupNotify = True Then

      Begin
            Launcher_file.Add('StartupNotify=true');
      End;

      {--- Terminal ---}

      If mkl_terminal = True Then

      Begin
            Launcher_file.Add('Terminal=true');
      End;

      {--- Category ---}

      If mkl_Category <> 'Other' Then

      Begin
            Launcher_file.Add('Categories=' + mkl_Category);
      End;

      {--- Keyword ---}

      If mkl_Keyword <> '' Then

      Begin
            Launcher_file.Add('Keywords=' + mkl_Keyword);
      End;

      {--- Comment ---}

      If mkl_Comment <> '' Then

      Begin
            Launcher_file.Add('Comment=' + mkl_Comment);
      End;

      {--- Insert ---}

      If Insert_entry.Count > 0 Then

      Begin
            For Counter1 := 0 to Insert_entry.Count - 1 do

            Begin
                  Launcher_file.Add(Insert_entry.Strings[Counter1]);
            End;
      End;

      {--- Polkit ---}

      If mkl_Create_polkit = True Then

      Begin
            {--- Load polkit template ---}

            Polkit_file.SetText(Polkit_template_file);

            {--- Set values ---}

            {--- "pk_gui" Position 14 ---}

            If Polkit_v[pk_gui] = 'no_gui' Then

            Begin
                  Polkit_file.Strings[14] := AnsiReplaceStr(Polkit_file.Strings[14],'$$gui','');
            End

            Else

            Begin
                  Polkit_file.Strings[14] := AnsiReplaceStr(Polkit_file.Strings[14],'$$gui','true');
            End;

            {--- "pk_path" Position 13 ---}

            Polkit_file.Strings[13] := AnsiReplaceStr(Polkit_file.Strings[13],'$$path',Polkit_v[pk_path]);

            {--- "pk_local" Position 11 ---}

            If Polkit_v[pk_local] = 'root' Then

            Begin
                  Polkit_file.Strings[11] := AnsiReplaceStr(Polkit_file.Strings[11],'$$active','auth_admin');
            End

            Else If Polkit_v[pk_local] = 'password' Then

            Begin
                  Polkit_file.Strings[11] := AnsiReplaceStr(Polkit_file.Strings[11],'$$active','auth_self');
            End

            Else If Polkit_v[pk_local] = 'user' Then

            Begin
                  Polkit_file.Strings[11] := AnsiReplaceStr(Polkit_file.Strings[11],'$$active','yes');
            End

            Else If Polkit_v[pk_local] = 'null' Then

            Begin
                  Polkit_file.Strings[11] := AnsiReplaceStr(Polkit_file.Strings[11],'$$active','no');
            End

            Else If Polkit_v[pk_local] = 'root_k' Then

            Begin
                  Polkit_file.Strings[11] := AnsiReplaceStr(Polkit_file.Strings[11],'$$active','auth_admin_keep');
            End

            Else If Polkit_v[pk_local] = 'password_k' Then

            Begin
                  Polkit_file.Strings[11] := AnsiReplaceStr(Polkit_file.Strings[11],'$$active','auth_self_keep');
            End

            Else

            Begin
                  Polkit_syntax_error;
                  Display('local=' + Polkit_v[pk_local]);
                  Exit;
            End;

            {--- "pk_remote" Position 10 ---}

            If Polkit_v[pk_remote] = 'root' Then

            Begin
                  Polkit_file.Strings[10] := AnsiReplaceStr(Polkit_file.Strings[10],'$$inactive','auth_admin');
            End

            Else If Polkit_v[pk_remote] = 'password' Then

            Begin
                  Polkit_file.Strings[10] := AnsiReplaceStr(Polkit_file.Strings[10],'$$inactive','auth_self');
            End

            Else If Polkit_v[pk_remote] = 'user' Then

            Begin
                  Polkit_file.Strings[10] := AnsiReplaceStr(Polkit_file.Strings[10],'$$inactive','yes');
            End

            Else If Polkit_v[pk_remote] = 'null' Then

            Begin
                  Polkit_file.Strings[10] := AnsiReplaceStr(Polkit_file.Strings[10],'$$inactive','no');
            End

            Else If Polkit_v[pk_remote] = 'root_k' Then

            Begin
                  Polkit_file.Strings[10] := AnsiReplaceStr(Polkit_file.Strings[10],'$$inactive','auth_admin_keep');
            End

            Else If Polkit_v[pk_remote] = 'password_k' Then

            Begin
                  Polkit_file.Strings[10] := AnsiReplaceStr(Polkit_file.Strings[10],'$$inactive','auth_self_keep');
            End

            Else

            Begin
                  Polkit_syntax_error;
                  Display('remote=' + Polkit_v[pk_remote]);
                  Exit;
            End;

            {--- "pk_icon_name" Position 8 ---}

            If Polkit_v[pk_icon_name] <> '' Then

            Begin
                  Polkit_file.Strings[8] := AnsiReplaceStr(Polkit_file.Strings[8],'$$icon','<icon_name>' + Polkit_v[pk_icon_name] + '</icon_name>');
            End

            Else

            Begin
                  Polkit_file.Delete(8);
            End;

            {--- "pk_message" Position 7 ---}

            If Polkit_v[pk_message] <> '' Then

            Begin
                  Polkit_file.Strings[7] := AnsiReplaceStr(Polkit_file.Strings[7],'$$message','<message>' + Polkit_v[pk_message] + '</message>');
            End

            Else

            Begin
                  Polkit_file.Delete(7);
            End;

            {--- "pk_description" Position 6 ---}

            If Polkit_v[pk_description] <> '' Then

            Begin
                  Polkit_file.Strings[6] := AnsiReplaceStr(Polkit_file.Strings[6],'$$description','<description>' + Polkit_v[pk_description] + '</description>');
            End

            Else

            Begin
                  Polkit_file.Delete(6);
            End;

            {--- "$$id" Position 5 ---}

            mkl_Polkit_name        := AnsiReplaceStr(mkl_Polkit_name,'$$name',Valid_DBus_name(mkl_Name));
            Polkit_file.Strings[5] := AnsiReplaceStr(Polkit_file.Strings[5],'$$id',mkl_Polkit_name);

            {--- "pk_vendor_url" Position 4 ---}

            If Polkit_v[pk_vendor_url] <> '' Then

            Begin
                  Polkit_file.Strings[4] := AnsiReplaceStr(Polkit_file.Strings[4],'$$v_url','<vendor_url>' + Polkit_v[pk_vendor_url] + '</vendor_url>');
            End

            Else

            Begin
                  Polkit_file.Delete(4);
            End;

            {--- "$$vendor" Position 3 ---}

            If Polkit_v[pk_vendor] <> '' Then

            Begin
                  Polkit_file.Strings[3] := AnsiReplaceStr(Polkit_file.Strings[3],'$$vendor',Polkit_v[pk_vendor]);
            End

            Else

            Begin
                  Polkit_file.Strings[3] := AnsiReplaceStr(Polkit_file.Strings[3],'$$vendor',mkl_Name);
            End;
      End;

      {--- Make remove ---}

      Make_remove :

      {--- Remove file ---}

      If mkl_remove_file <> '' Then

      Begin
            StrPCopy(Launcher_to_remove,mkl_Path + _DS_ + Valid_DBus_name(mkl_remove_file) + '.desktop');
            StrPCopy(Launcher_No_DBus  ,mkl_Path + _DS_ + mkl_remove_file + '.desktop');

            FE_Launcher_to_remove := FileExists(StrPas(Launcher_to_remove));
            FE_Launcher_No_DBus   := FileExists(StrPas(Launcher_No_DBus));

            If (FE_Launcher_to_remove = True) Or
               (FE_Launcher_No_DBus   = True) Then

            Begin
                  {--- Polkit file ---}

                  If FE_Launcher_to_remove = True Then

                  Begin
                        Launcher_path_remove := StrPas(Launcher_to_remove);
                  End

                  Else

                  Begin
                        Launcher_path_remove := StrPas(Launcher_No_DBus);
                  End;

                  {--- Launcher file ---}

                  If mkl_yes_all = True Then

                  Begin
                        {--- Delete Polkit file ---}

                        Try
                               Launcher_file.LoadFromFile(Launcher_path_remove);

                               If Launcher_file.Count > 0 Then

                               Begin
                                     For Counter1 := 0 to Launcher_file.Count - 1 do

                                     Begin
                                           If Pos('# <polkit file="',Launcher_file.Strings[Counter1]) <> 0 Then

                                           Begin
                                                 mkl_Polkit_name := Launcher_file.Strings[Counter1];

                                                 Delete(mkl_Polkit_name,Pos('>',mkl_Polkit_name) - 1,Length(mkl_Polkit_name) - (Pos('>',mkl_Polkit_name) - 1) + 1);
                                                 Delete(mkl_Polkit_name,1,Pos('=',mkl_Polkit_name) + 1);
                                                 StrPCopy(Delete_polkit_file,Polkit_directory + _DS_ + mkl_Polkit_name);

                                                 File_manager.Erase(Delete_polkit_file);

                                                 If File_manager.Error <> '' Then

                                                 Begin
                                                       Display('- NOTE - Polkit file can not delete file "' + Polkit_directory + _DS_ + mkl_Polkit_name + '".');
                                                       Error_status  := -6;
                                                 End;

                                                 File_manager.Restore;
                                                 Break;
                                           End;
                                     End;
                               End;
                        Except
                               Display('- NOTE - unable to access file : ' + Launcher_path_remove);
                               Error_status  := -7;
                        End;

                        {--- Launcher remove ---}

                        File_manager.Erase(Launcher_to_remove);

                        If File_manager.Error <> '' Then

                        Begin
                              File_manager.Restore;
                              File_manager.Erase(Launcher_No_DBus);

                              If File_manager.Error <> '' Then

                              Begin
                                    Display('Error can not delete file "' + mkl_remove_file + '.desktop' + '".');
                                    LowCommanLine := 'quit';
                                    Error_status  := 8;
                                    Exit;
                              End;
                        End;

                        If Update_desktop = True Then

                        Begin
                              If Current_user_only = True Then

                              Begin
                                    If Session_user <> 'root' Then

                                    Begin
                                          StrPCopy(Launcher_to_remove,_DS_ + 'home' + _DS_ + Session_user + _DS_ + System_desktop + _DS_ + Valid_DBus_name(mkl_remove_file) + '.desktop');
                                          StrPCopy(Launcher_No_DBus  ,_DS_ + 'home' + _DS_ + Session_user + _DS_ + System_desktop + _DS_ + mkl_remove_file + '.desktop');
                                    End

                                    Else

                                    Begin
                                          StrPCopy(Launcher_to_remove,_DS_ + 'root' + _DS_ + System_desktop + _DS_ + Valid_DBus_name(mkl_remove_file) + '.desktop');
                                          StrPCopy(Launcher_No_DBus  ,_DS_ + 'root' + _DS_ + System_desktop + _DS_ + mkl_remove_file + '.desktop');
                                    End;

                                    File_manager.Erase(Launcher_to_remove);
                                    File_manager.Restore;
                                    File_manager.Erase(Launcher_No_DBus);
                              End

                              Else

                              Begin
                                    If (mkl_Config_file.Count > 0) and (System_users.Count > 0) Then

                                    Begin
                                          For Counter2 := 0 to mkl_Config_file.Count - 1 do

                                          Begin
                                                For Counter3 := 0 to System_users.Count - 1 do

                                                Begin
                                                      User_ := TSystem_user(System_users.Items[Counter3]);

                                                      If Pos(User_.Name + '*',mkl_Config_file.Strings[Counter2]) <> 0 Then

                                                      Begin
                                                            User_desktop := mkl_Config_file.Strings[Counter2];
                                                            Delete(User_desktop,1,Pos('*',User_desktop));

                                                            StrPCopy(Launcher_to_remove,User_.Home_dir + _DS_ + User_desktop + _DS_ + Valid_DBus_name(mkl_remove_file) + '.desktop');
                                                            StrPCopy(Launcher_No_DBus  ,User_.Home_dir + _DS_ + User_desktop + _DS_ + mkl_remove_file + '.desktop');

                                                            File_manager.Erase(Launcher_to_remove);
                                                            File_manager.Restore;
                                                            File_manager.Erase(Launcher_No_DBus);
                                                            File_manager.Restore;

                                                            Break;
                                                      End;
                                                End;
                                          End;
                                    End;
                              End;
                        End;
                  End

                  Else

                  Begin
                        Write('You really want to erase the launcher "',mkl_remove_file + '.desktop','" ? (y/n) : ');
                        Flush(Output);
                        Readln(mkl_remove_input);

                        If Lowercase(mkl_remove_input) = 'y' Then

                        Begin
                              {--- Delete polkit file ---}

                              Try
                                     Launcher_file.LoadFromFile(Launcher_path_remove);

                                     If Launcher_file.Count > 0 Then

                                     Begin
                                           For Counter1 := 0 to Launcher_file.Count - 1 do

                                           Begin
                                                 If Pos('# <polkit file="',Launcher_file.Strings[Counter1]) <> 0 Then

                                                 Begin
                                                       mkl_Polkit_name := Launcher_file.Strings[Counter1];

                                                       Delete(mkl_Polkit_name,Pos('>',mkl_Polkit_name) - 1,Length(mkl_Polkit_name) - (Pos('>',mkl_Polkit_name) - 1) + 1);
                                                       Delete(mkl_Polkit_name,1,Pos('=',mkl_Polkit_name) + 1);
                                                       StrPCopy(Delete_polkit_file,Polkit_directory + _DS_ + mkl_Polkit_name);

                                                       File_manager.Erase(Delete_polkit_file);

                                                       If File_manager.Error <> '' Then

                                                       Begin
                                                             Display('- NOTE - Polkit file can not delete file "' + Polkit_directory + _DS_ + mkl_Polkit_name + '".');
                                                             Error_status  := -6;
                                                       End;

                                                       File_manager.Restore;
                                                       Break;
                                                 End;
                                           End;
                                     End;
                              Except
                                     Display('- NOTE - unable to access file : ' + Launcher_path_remove);
                                     Error_status  := -7;
                              End;

                              {--- Launcher remove ---}

                              File_manager.Erase(Launcher_to_remove);

                              If File_manager.Error <> '' Then

                              Begin
                                    File_manager.Restore;
                                    File_manager.Erase(Launcher_No_DBus);

                                    If File_manager.Error <> '' Then

                                    Begin
                                          Display('Error can not delete file "' + mkl_remove_file + '.desktop' + '".');
                                          LowCommanLine := 'quit';
                                          Error_status  := 8;
                                          Exit;
                                    End;
                              End;

                              If Update_desktop = True Then

                              Begin
                                    If Current_user_only = True Then

                                    Begin
                                          If Session_user <> 'root' Then

                                          Begin
                                                StrPCopy(Launcher_to_remove,_DS_ + 'home' + _DS_ + Session_user + _DS_ + System_desktop + _DS_ + Valid_DBus_name(mkl_remove_file) + '.desktop');
                                                StrPCopy(Launcher_No_DBus,  _DS_ + 'home' + _DS_ + Session_user + _DS_ + System_desktop + _DS_ + mkl_remove_file + '.desktop');
                                          End

                                          Else

                                          Begin
                                                StrPCopy(Launcher_to_remove,_DS_ + 'root' + _DS_ + System_desktop + _DS_ + Valid_DBus_name(mkl_remove_file) + '.desktop');
                                                StrPCopy(Launcher_No_DBus,  _DS_ + 'root' + _DS_ + System_desktop + _DS_ + mkl_remove_file + '.desktop');
                                          End;

                                          File_manager.Erase(Launcher_to_remove);
                                          File_manager.Restore;
                                          File_manager.Erase(Launcher_No_DBus);
                                    End

                                    Else

                                    Begin
                                          If (mkl_Config_file.Count > 0) and (System_users.Count > 0) Then

                                          Begin
                                                For Counter2 := 0 to mkl_Config_file.Count - 1 do

                                                Begin
                                                      For Counter3 := 0 to System_users.Count - 1 do

                                                      Begin
                                                            User_ := TSystem_user(System_users.Items[Counter3]);

                                                            If Pos(User_.Name + '*',mkl_Config_file.Strings[Counter2]) <> 0 Then

                                                            Begin
                                                                  User_desktop := mkl_Config_file.Strings[Counter2];
                                                                  Delete(User_desktop,1,Pos('*',User_desktop));

                                                                  StrPCopy(Launcher_to_remove,User_.Home_dir + _DS_ + User_desktop + _DS_ + Valid_DBus_name(mkl_remove_file) + '.desktop');
                                                                  StrPCopy(Launcher_No_DBus  ,User_.Home_dir + _DS_ + User_desktop + _DS_ + mkl_remove_file + '.desktop');

                                                                  File_manager.Erase(Launcher_to_remove);
                                                                  File_manager.Restore;
                                                                  File_manager.Erase(Launcher_No_DBus);
                                                                  File_manager.Restore;

                                                                  Break;
                                                            End;
                                                      End;
                                                End;
                                          End;
                                    End;
                              End;
                        End

                        Else

                        Begin
                              Display('Operation aborted.');
                              Error_status := 5;
                        End;
                  End;
            End

            Else

            Begin
                  Display('Error, file not found "' + mkl_Path + _DS_ + mkl_remove_file + '.desktop' + '"');
                  Error_status := 4;
            End;
      End

      {--- Make file ---}

      Else

      Begin
            {--- Polkit file ---}

            If mkl_Create_polkit = True Then

            Begin
                  Try
                         Polkit_file.SaveToFile(Polkit_directory + _DS_ + mkl_Polkit_name);
                         Launcher_file.Insert(0,'# <polkit file="' + mkl_Polkit_name + '">');
                  Except
                         Display('Polkit file error unable to create file : ' + mkl_Polkit_name);

                         Error_status  := 11;
                         LowCommanLine := 'quit';

                         Exit;
                  End;
            End;

            {--- Launcher file ---}

            If Current_user_only = True Then

            Begin
                  Desktop_file := mkl_Path + _DS_ + Valid_DBus_name(mkl_Name) + '.desktop';

                  {--- Check name size ---}

                  If Length(Desktop_file) > 255 Then

                  Begin
                        LowCommanLine := 'quit';
                        Error_status  := 9;
                        Display('Error name of the launcher too large "' + mkl_Name + '".');
                        Flush(Output);
                        Exit;
                  End;

                  Try
                         Launcher_file.SaveToFile(Desktop_file);
                  Except
                         Display('- NOTE - unable to create file : ' + Desktop_file);

                         Error_status  := -5;
                         LowCommanLine := 'quit';

                         Exit;
                  End;

                  {$IFDEF UNIX}

                  If Owner_user = True Then

                  Begin
                        fpChown(Desktop_file,User_.Uid,User_.Gid);
                  End;

                  fpChmod(Desktop_file,&775);

                  {$ENDIF}

                  If Update_desktop = True Then

                  Begin
                        If Session_user <> 'root' Then

                        Begin
                              Desktop_file := _DS_ + 'home' + _DS_ + Session_user + _DS_ + System_desktop + _DS_ + Valid_DBus_name(mkl_Name) + '.desktop';
                        End

                        Else

                        Begin
                              Desktop_file := _DS_ + 'root' + _DS_ + System_desktop + _DS_ + Valid_DBus_name(mkl_Name) + '.desktop';
                        End;

                        Try
                               Launcher_file.SaveToFile(Desktop_file);
                        Except
                               Display('- NOTE - unable to create file : ' + Desktop_file);

                               Error_status  := -5;
                               LowCommanLine := 'quit';

                               Exit;
                        End;

                        {$IFDEF UNIX}

                        If Owner_user = True Then

                        Begin
                              fpChown(Desktop_file,User_.Uid,User_.Gid);
                        End;

                        fpChmod(Desktop_file,&775);

                        {$ENDIF}
                  End;
            End

            Else

            Begin
                  Desktop_file := mkl_Path + _DS_ + Valid_DBus_name(mkl_Name) + '.desktop';

                  {--- Check name size ---}

                  If Length(Desktop_file) > 255 Then

                  Begin
                        LowCommanLine := 'quit';
                        Error_status  := 9;
                        Display('Error name of the launcher too large "' + mkl_Name + '".');
                        Flush(Output);
                        Exit;
                  End;

                  Try
                         Launcher_file.SaveToFile(Desktop_file);
                  Except
                         Display('- NOTE - unable to create file : ' + Desktop_file);

                         Error_status  := -5;
                         LowCommanLine := 'quit';

                         Exit;
                  End;

                  If Update_desktop = True Then

                  Begin
                        If (mkl_Config_file.Count > 0) and (System_users.Count > 0) Then

                        Begin
                              For Counter2 := 0 to mkl_Config_file.Count - 1 do

                              Begin
                                    For Counter3 := 0 to System_users.Count - 1 do

                                    Begin
                                          User_ := TSystem_user(System_users.Items[Counter3]);

                                          If Pos(User_.Name + '*',mkl_Config_file.Strings[Counter2]) <> 0 Then

                                          Begin
                                                User_desktop := mkl_Config_file.Strings[Counter2];
                                                Delete(User_desktop,1,Pos('*',User_desktop));
                                                Desktop_file := User_.Home_dir + _DS_ + User_desktop + _DS_ + Valid_DBus_name(mkl_Name) + '.desktop';

                                                Try
                                                       Launcher_file.SaveToFile(Desktop_file);

                                                       {$IFDEF UNIX}

                                                       fpChown(Desktop_file,User_.Uid,User_.Gid);
                                                       fpChmod(Desktop_file,&775);

                                                       {$ENDIF}
                                                Except
                                                       Display('- NOTE - unable to create file : ' + Desktop_file);
                                                       Error_status := -5;
                                                End;

                                                Break;
                                          End;
                                    End;
                              End;
                        End;
                  End;
            End;
      End;

      LowCommanLine := 'quit';
End;
{
 ------------------------------------------------------
| Method Public Tmklauncher.Display                    |
 ------------------------------------------------------
}
Procedure Tmklauncher.Display(NewText : String);
Begin
      If Silence = False Then

      Begin
            Writeln(NewText);
      End;
End;
{
 ------------------------------------------------------
| Method Private Tmklauncher.Get_command_output        |
 ------------------------------------------------------
}
Function Tmklauncher.Get_command_output(Command : String) : String;

Var
    Data_string    : Array [0..255] of Char;
    Length_buffer  : Integer;
    Param_app      : TStringList;
    Parser         : TParser_commands;
    Counter1       : Word;
    Command_output : String;

Begin
      Param_app               := TStringList.Create;
      Parser                  := TParser_commands.Create;
      Process_manager         := TProcessUTF8.Create(Nil);
      Process_manager.Options := [poUsePipes,poStderrToOutPut,poNoConsole];
      Counter1                := 0;

      Parser.Extract_values(Command,Param_app);

      If Param_app.Count > 0 Then

      Begin
            Try
                   Process_manager.Executable := Param_app.Strings[0];

                   If Param_app.Count > 1 Then

                   Begin
                         Param_app.Delete(0);

                         For Counter1 := 0 to Param_app.Count - 1 do

                         Begin
                               Process_manager.Parameters.Add(Param_app.Strings[Counter1]);
                         End;
                   End;

                   Process_manager.Execute;
                   Sleep(250);
                   FillChar(Data_string,Sizeof(Data_string),0);

                   Length_buffer := Process_manager.Output.NumBytesAvailable;
                   Process_manager.Output.Read(Data_string,Length_buffer);

                   Command_output     := StrPas(Data_string);
                   Command_output     := AnsiReplaceText(Command_output,LineEnding,'');
                   Error              := '';
                   Get_command_output := Command_output;
            Except
                   Error              := 'Error : It is not possible to execute the "' + Command + '" command.';
                   Get_command_output := '';
            End;
      End;

      Param_app.Free;
      Parser.Free;
      Process_manager.Free;
End;
{
 ------------------------------------------------------
| Method Private Tmklauncher.Get_system_users          |
 ------------------------------------------------------
}
Procedure Tmklauncher.Get_system_users(Users : TFPList);

Var
    Target_file,
    StrID         : String;

    Target_passwd : TStringList;
    User_         : TSystem_user;

    Counter1,
    Counter2,
    Current_pos   : Word;

    Separator     : Array [1..6] of Word;

    ValError      : Integer;

Begin
      {--- Load passwd files ---}

      If FileExists(Passwd_file_1) = True Then

      Begin
            Target_file := Passwd_file_1;
      End

      Else

      Begin
            Error := '"/etc/passwd" not found';
            Exit;
      End;

      Target_passwd := TStringList.Create;

      Try
             Target_passwd.LoadFromFile(Target_file);

             {--- Make users list ---}

             If Target_passwd.Count > 0 Then

             Begin
                   For Counter1 := 0 to Target_passwd.Count - 1 do

                   Begin
                         If (Pos(_DS_ + 'home' + _DS_,Target_passwd.Strings[Counter1]) <> 0) Or
                            (Pos(       'root:'      ,Target_passwd.Strings[Counter1]) <> 0) Then

                         Begin
                               Current_pos := 1;

                               For Counter2 := 1 to Length(Target_passwd.Strings[Counter1]) do

                               Begin
                                     If Target_passwd.Strings[Counter1][Counter2] = ':' Then

                                     Begin
                                           Separator[Current_pos] := Counter2;
                                           Current_pos            := Current_pos + 1;

                                           If Current_pos > 4 Then Break;
                                     End;
                               End;

                               Current_pos := 6;

                               For Counter2 := Length(Target_passwd.Strings[Counter1]) Downto 1 do

                               Begin
                                     If Target_passwd.Strings[Counter1][Counter2] = ':' Then

                                     Begin
                                           Separator[Current_pos] := Counter2;
                                           Current_pos            := Current_pos - 1;

                                           If Current_pos < 5 Then Break;
                                     End;
                               End;

                               {--- Add user record ---}

                               User_      := TSystem_user.Create;
                               User_.Name := Copy(Target_passwd.Strings[Counter1],1,Separator[1] - 1);
                               StrID      := Copy(Target_passwd.Strings[Counter1],Separator[2] + 1,Separator[3] - Separator[2] - 1);

                               Val(StrID,User_.Uid,ValError);

                               If ValError <> 0 Then

                               Begin
                                     Error := '"' + Target_file + '" wrong file format';
                                     Break;
                               End;

                               StrID := Copy(Target_passwd.Strings[Counter1],Separator[3] + 1,Separator[4] - Separator[3] - 1);

                               Val(StrID,User_.Gid,ValError);

                               If ValError <> 0 Then

                               Begin
                                     Error := '"' + Target_file + '" wrong file format';
                                     Break;
                               End;

                               User_.Home_dir := Copy(Target_passwd.Strings[Counter1],Separator[5] + 1,Separator[6] - Separator[5] - 1);

                               If Length(User_.Home_dir) > 0 Then

                               Begin
                                     If User_.Home_dir[Length(User_.Home_dir)] = _DS_ Then

                                     Begin
                                           Delete(User_.Home_dir,Length(User_.Home_dir),1);
                                     End;
                               End;

                               Users.Add(User_);
                         End;
                   End;
             End

             Else

             Begin
                   Error := '"' + Target_file + '" is empty.';
             End;

             Target_passwd.Free;
      Except
             Error := 'Unable to read "' + Target_file + '"';
             Target_passwd.Free;
      End;
End;
{
 ------------------------------------------------------
| Method Private Tmklauncher.Get_configuration         |
 ------------------------------------------------------
}
Procedure Tmklauncher.Get_configuration(Configuration : TStringlist);
Begin
      Try
             Configuration.LoadFromFile(Config_file);

             If Configuration.Count > 0 then

             Begin
                   Error := '';
             End

             Else

             Begin
                   Error := 'The configuration file is empty.';
             End;
      Except
             Error := 'Error it is not possible to read the configuration file.';
      End;
End;
{
 ------------------------------------------------------
| Method Private Tmklauncher.Get_system_desktop        |
 ------------------------------------------------------
}
Function Tmklauncher.Get_system_desktop : String;

Label
      Next_user;

Var
    Desktop_str,
    User_desktop : String;

    Counter1,
    Counter2,
    Counter3     : Word;

    User_        : TSystem_user;

Begin
      {--- Load config ---}

      Get_configuration(mkl_Config_file);

      If Error = '' Then

      Begin
            If (mkl_Config_file.Count > 0) and (mkl_Config_file.Strings[0] <> '') Then

            Begin
                  If System_users.Count > 0 Then

                  Begin
                        {--- Desktop_str ---}

                        Desktop_str := '';

                        {--- Extract desktop ---}

                        For Counter1 := 0 to System_users.Count - 1 do

                        Begin
                              User_ := TSystem_user(System_users.Items[Counter1]);

                              {--- Home dir ---}

                              If User_.Name = Session_user Then

                              Begin
                                    {--- search "User_.Name*Desktop_dir" ---}

                                    For Counter2 := 0 to mkl_Config_file.Count - 1 do

                                    Begin
                                          If Pos(User_.Name + '*',mkl_Config_file.Strings[Counter2]) <> 0 Then

                                          Begin
                                                User_desktop := mkl_Config_file.Strings[Counter2];
                                                Delete(User_desktop,1,Pos('*',User_desktop));

                                                If User_desktop <> '' Then

                                                Begin
                                                      Desktop_str := User_.Home_dir + _DS_ + User_desktop;
                                                      Break;
                                                End;
                                          End;
                                    End;
                              End;

                              If Desktop_str <> '' Then

                              Begin
                                    If DirectoryExists(Desktop_str) = True Then

                                    Begin
                                          Get_system_desktop := User_desktop;
                                          Exit;
                                    End

                                    Else

                                    Begin
                                          Break;
                                    End;
                              End;
                        End;
                  End;
            End;
      End;

      {--- Scan desktop ---}

      If System_users.Count > 0 Then

      Begin
            User_desktop := '';

            mkl_Config_file.Clear;

            For Counter3 := 0 to System_users.Count - 1 do

            Begin
                  User_ := TSystem_user(System_users.Items[Counter3]);

                  For Counter1 := 1 to dl_Size do

                  Begin
                        For Counter2 := 1 to 2 do

                        Begin
                              Desktop_str := User_.Home_dir + _DS_ + Desktop_list[Counter1][Counter2];

                              If DirectoryExists(Desktop_str) = True Then

                              Begin
                                    mkl_Config_file.Add(User_.Name + '*' + Desktop_list[Counter1][Counter2]);

                                    If User_.Name = Session_user Then

                                    Begin
                                          User_desktop := Desktop_list[Counter1][Counter2];
                                    End;

                                    Goto Next_user;
                              End;
                        End;
                  End;

                  Next_user :
            End;

            {--- Save config file ---}

            Try
                   mkl_Config_file.SavetoFile(Config_file);
            Except
                   Warning := 1;
            End;

            If User_desktop <> '' Then

            Begin
                  Get_system_desktop := User_desktop;
                  Exit;
            End;

            Update_desktop     := False;
            Error              := '';
            Get_system_desktop := '';
      End

      Else

      Begin
            Update_desktop     := False;
            Error              := '';
            Get_system_desktop := '';
      End;
End;
{
 ------------------------------------------------------
| Method Private Tmklauncher.Search_constraint         |
 ------------------------------------------------------
}
Function Tmklauncher.Search_constraint(Name : String) : Word;

Var
    Counter1,
    Counter2  : Word;

Begin
      If Length(Name) > 0 Then

      Begin
            For Counter1 := 1 to Length(Name) do

            Begin
                  For Counter2 := 1 to Length(Constraint) do

                  Begin
                        If Name[Counter1] = Constraint[Counter2] Then

                        Begin
                              Search_constraint := Counter1;
                              Exit;
                        End;
                  End;
            End;
      End;

      Search_constraint := 0;
End;
{
 ------------------------------------------------------
| Method Private Tmklauncher.Syntax_error              |
 ------------------------------------------------------
}
Procedure Tmklauncher.Syntax_error;
Begin
      LowCommanLine := 'quit';
      Error_status  := 1;

      Display('Syntax error, use "mklauncher -help" for obtain help.');
End;
{
 ------------------------------------------------------
| Method Private Tmklauncher.Valid_DBus_name           |
 ------------------------------------------------------
}
Function Tmklauncher.Valid_DBus_name(Name : String) : String;

Var
    Counter1  : Word;

    New_name,
    Str_ord   : String;

Begin
      If Length(Name) > 0 Then

      Begin
            New_name := '';

            For Counter1 := 1 to Length(Name) do

            Begin
                  {--- Uper case ---}

                  If Not ((Ord(Name[Counter1]) >= 65) and (Ord(Name[Counter1]) <= 90)) Then

                  Begin
                        {--- Lower case ---}

                        If Not ((Ord(Name[Counter1]) >= 97) and (Ord(Name[Counter1]) <= 122)) Then

                        Begin
                              {--- Number ---}

                              If Not ((Ord(Name[Counter1]) >= 48) and (Ord(Name[Counter1]) <= 57)) Then

                              Begin
                                    If Not ((Ord(Name[Counter1]) = Ord('_')) or (Ord(Name[Counter1]) = Ord('.'))) Then

                                    Begin
                                          If Ord(Name[Counter1]) = 32 Then

                                          Begin
                                                New_name := New_name + '_';
                                          End

                                          Else

                                          Begin
                                                Str_ord  := HexStr(Ord(Name[Counter1]),2);
                                                New_name := New_name + Str_ord;
                                          End;

                                          Continue;
                                    End;
                              End;
                        End;
                  End;

                  New_name := New_name + Name[Counter1];
            End;

            {--- If New_name > 50 use "Base 64" encode ---}

            If Length(New_name) > 50 Then

            Begin
                  New_name := EncodeStringBase64(Name);
                  New_name := AnsiReplaceText(New_name,'+','__');
                  New_name := AnsiReplaceText(New_name,'/','_');
                  New_name := AnsiReplaceText(New_name,'=','');
            End;

            If (Ord(New_name[1]) >= 48) and (Ord(New_name[1]) <= 57) Then

            Begin
                  New_name := 'mkl_' + New_name;
            End;

            {--- If New_name > 175 set length to 175 ---}

            If Length(New_name) > 175 Then

            Begin
                  SetLength(New_name,175);
            End;

            Valid_DBus_name := New_name;
      End

      Else

      Begin
            Valid_DBus_name := '';
      End;
End;
{
 ------------------------------------------------------
| Method Private Tmklauncher.Fix_desktop               |
 ------------------------------------------------------
}
Procedure Tmklauncher.Fix_desktop(New_desktop : String);

Var
    Counter1,
    Counter2 : Word;

Begin
      {--- Save config file ---}

      If Length(New_desktop) > 0 Then

      Begin
            For Counter1 := Length(New_desktop) Downto 1 do

            Begin
                  If New_desktop[Counter1] = _DS_ Then

                  Begin
                        Delete(New_desktop,1,Counter1);
                        Break;
                  End;
            End;

            Try
                   mkl_Config_file.LoadFromFile(Config_file);

                   If mkl_Config_file.Count > 0 then

                   Begin
                         For Counter2 := 0 to mkl_Config_file.Count - 1 do

                         Begin
                               If Pos(Session_user + '*',mkl_Config_file.Strings[Counter2]) <> 0 Then

                               Begin
                                     mkl_Config_file.Delete(Counter2);
                                     Break;
                               End;
                         End;
                   End;
            Except
                   mkl_Config_file.Clear;
            End;

            mkl_Config_file.Add(Session_user + '*' + New_desktop);

            Try
                   mkl_Config_file.SavetoFile(Config_file);
            Except
                   Error_status := -3;

                   Display('');
                   Display('- NOTE -');
                   Display('');
                   Display('Unable to update ' + Config_file);
                   Display('');

                   Flush(Output);
            End;
      End;
End;
{
 ------------------------------------------------------
| Method Private Tmklauncher.Symbolic_link             |
 ------------------------------------------------------
}
Procedure Tmklauncher.Symbolic_link(New_link : String);

Var
    Desktop_path,
    File_Folder     : String;

    Old_name,
    New_name,
    File_Folder_pch : Array [0..255] of char;

    Counter1,
    Separator       : Word;

Begin
      If Update_desktop = True Then

      Begin
            If Length(New_link) > 0 Then

            Begin
                  If (FileExists(New_link)      = True) or
                     (DirectoryExists(New_link) = True) Then

                  Begin
                        If Session_user <> 'root' Then

                        Begin
                              Desktop_path := _DS_ + 'home' + _DS_ + Session_user + _DS_ + System_desktop + _DS_;
                        End

                        Else

                        Begin
                              Desktop_path := _DS_ + 'root' + _DS_ + System_desktop + _DS_;
                        End;

                        File_Folder  := New_link;
                        Separator    := 0;

                        For Counter1 := Length(New_link) Downto 1 do

                        Begin
                              If New_link[Counter1] = _DS_ Then

                              Begin
                                    Separator := Counter1;
                                    Break;
                              End;
                        End;

                        If Separator > 0 Then

                        Begin
                              Delete(File_Folder,1,Separator);
                        End;

                        StrPCopy(Old_name,New_link);
                        StrPCopy(New_name,Desktop_path);
                        StrPCopy(File_Folder_pch,File_Folder);
                        StrCat(New_name,File_Folder_pch);

                        Try
                               {$IFDEF UNIX}

                               fpSymlink(Old_name,New_name);

                               {$ENDIF}
                        Except
                               Display('');
                               Display('Error : It is not possible to create the symbolic link : "' + New_link + '".');
                               Display('');

                               Flush(Output);
                        End;
                  End

                  Else

                  Begin
                        Display('');
                        Display('Error : It is not possible to create the symbolic link : "' + New_link + '".');
                        Display('');
                        Flush(Output);
                  End;
            End;
      End

      Else

      Begin
            Display('');
            Display('Error : It is not possible to create the symbolic link.');
            Display('');
            Flush(Output);
      End;
End;
{
 ------------------------------------------------------
| Method Private Tmklauncher.Detect_launchers_path     |
 ------------------------------------------------------
}
Procedure Tmklauncher.Detect_launchers_path(Owner_user : Boolean; Uid,Gid : Longword);

Label
      Global_path_found,
      Local_path_found;

Var
    Counter1,
    Counter2   : Word;

    New_folder : String;

Begin
      {--- Detect launcher global path ---}

      For Counter1 := 1 to gpl_Size do

      Begin
            If DirectoryExists(Launcher_path[Counter1]) = True Then

            Begin
                  c_Launcher_path := Counter1;
                  mkl_Path        := Launcher_path[c_Launcher_path];

                  Goto Global_path_found;
            End;
      End;

      Try
             Mkdir(Launcher_path[c_Launcher_path]);
      Except
             { Error directory not found : Error status = 6 Exit; }
      End;

      Global_path_found :

      {--- Make root local ---}

      If DirectoryExists(root_local) <> True Then

      Begin
            Try
                   Mkdir(root_local);
            Except
                   { Error directory not found : Error status = 6 Exit; }
            End;
      End;

      {--- Detect launcher local path ---}

      For Counter2 := 1 to upl_Size do

      Begin
            If DirectoryExists(_DS_ + 'home' + _DS_ + Session_user + _DS_ + Launcher_local_path[Counter2]) = True Then

            Begin
                  c_Launcher_local := Counter2;
                  Goto Local_path_found;
            End;
      End;

      If Session_user <> 'root' Then

      Begin
            Try
                   New_folder := _DS_ + 'home' + _DS_ + Session_user + _DS_ + Launcher_local_path[c_Launcher_local];
                   Mkdir(New_folder);

                   {$IFDEF UNIX}

                   If Owner_user = True Then

                   Begin
                         fpChown(New_folder,Uid,Gid);
                   End;

                   fpChmod(New_folder,&775);

                   {$ENDIF}
            Except
                   { Error directory not found : Error status = 6 Exit; }
            End;
      End;

      Local_path_found :
End;
{
 ------------------------------------------------------
| Method Private Tmklauncher.Polkit_syntax_error       |
 ------------------------------------------------------
}
Procedure Tmklauncher.Polkit_syntax_error;
Begin
      LowCommanLine := 'quit';
      Error_status  := 10;

      Display('Polkit syntax error, use "mklauncher -help" for obtain help.');
End;

{*******************************<< Prc/Fun >>********************************}

  (* Empty *)

{******************************<< Initialize >>******************************}

{
 -----------------------
| Initialization Inicio |
 -----------------------
}
Begin
End.

