
{
                               Commands_shell
                      -----------------------------------

     This file is part of the Pascal Motor Library                  
                                                                            
     See the file COPYING.LGPL.txt, included in this distribution,    
     for details about the copyright.                                         
                                                                            
     This program is distributed in the hope that it will be useful,          
     but WITHOUT ANY WARRANTY; without even the implied warranty of           
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 

     Pascal Motor Library Copyright (c) by José Francisco Arévalo(Paco)
     is free software, is a library of classes written in Pascal that 
     facilitates the creation of applications from zero. This works in 
     Windows, GNU/Linux, Mac OS X, FreeBSD and others, is freed under 
     the terms of the LGPL (GNU LIBRARY GENERAL PUBLIC LICENSE).


                                     Note
                          --------------------------
     
     Is allowed use to Pascal Motor in commercial applications consult 
     the file COPYING.LGPL.txt for more details. 
}

{******************************<< Header >>**********************************}

Unit Commands_shell;

{*****************************<< Unit Mode >>********************************}

{$MODE OBJFPC} {$H+}

{*****************************<< Interface >>********************************}

Interface

{******************************<< Units >>***********************************}

Uses
     Parser_commands, Classes, LazFileUtils, StrUtils, SysUtils;

{******************************<< Labels >>**********************************}

  (* Empty *)

{*******************************<< Const >>**********************************}

  (* Empty *)

{*******************************<< Types >>**********************************}

Type

{******************************<< Objects >>*********************************}

  (* Empty *)

{*******************************<< Class >>**********************************}

{
 -------------------------------------------------------------- 
| TCommands_shell : Class                                      | 
 -------------------------------------------------------------- 
}
  TCommands_shell    = Class(TObject)

       Public
       
       Parameters_str,
       LowParameters_str,
       Version,
       Date,
       Prompt,
       CommanLine,
       LowCommanLine      : String;

       Parameters,
       LowParameters,
       Commands,
       LowCommands        : TStringList;
       
       Error_status       : Integer;
       Silence            : Boolean;

       Protected

       Parser_            : TParser_commands;

       Public

       Constructor Create;
       Destructor  Destroy; Override;
       Procedure   DisplayInfo; Virtual;
       Procedure   Input_command;
       Procedure   Display_help; Virtual;
       Procedure   For_help; 
       Procedure   Display_exit; 
       Procedure   Current_directory; 
       Procedure   Set_current_directory(New_directory : String); 
       Function    Find_parameter(Parameter : String; Var Position : Word) : Boolean;
       Function    Find_parameter_cs(Parameter : String; Var Position : Word) : Boolean;
       Procedure   Process_command_line; Virtual;
       Procedure   Wait_for_output;
  End;
  
{*******************************<< Vars >>***********************************}

  (* Empty *)

{***************************<< Headers Prc/Fun >>****************************}

  (* Empty *)
  
{****************************<< Implementation >>****************************}

Implementation

{****************************<< Methods/Objects >>***************************}

  (* Empty *)

{*****************************<< Methods/Class >>****************************}

{
 --------------------------------------------- 
| Method Public TCommands_shell.Create Inicio | 
 --------------------------------------------- 
}
Constructor TCommands_shell.Create;

Var
    Counter1 : Integer;

Begin
      Inherited Create;
      
      Parameters_str    := '';
      LowParameters_str := ''; 
      CommanLine        := '';
      LowCommanLine     := '';
      Version           := '';
      Date              := '';
      Prompt            := '(command)';
      Parameters        := TStringList.Create;
      LowParameters     := TStringList.Create;
      Commands          := TStringList.Create;
      LowCommands       := TStringList.Create;
      Parser_           := TParser_commands.Create;
      Error_status      := 0;
      Silence           := False;
      
      {--- Parameters ---}
      
      If ParamCount > 0 Then
      
      Begin
            Parameters.Clear;
            LowParameters.Clear;
            
            For Counter1 := 1 to ParamCount do
            
            Begin
                  Parameters.Add(ParamStr(Counter1));
                  LowParameters.Add(LowerCase(ParamStr(Counter1)));
                  
                  Parameters_str    := Parameters_str + Parameters.Strings[Counter1 - 1];
                  LowParameters_str := LowParameters_str + LowParameters.Strings[Counter1 - 1]; 
                  
                  If Counter1 <> ParamCount Then
                  
                  Begin
                        Parameters_str    := Parameters_str + ' ';
                        LowParameters_str := LowParameters_str + ' '; 
                  End;
            End;
      End;
End;
{
 ---------------------------------------------- 
| Method Public TCommands_shell.Destroy Inicio | 
 ---------------------------------------------- 
}
Destructor TCommands_shell.Destroy;
Begin
      Parameters.Free;
      LowParameters.Free;
      Commands.Free;
      LowCommands.Free;
      Parser_.Free;
      
      Inherited Destroy;
End;
{
 -------------------------------------------------- 
| Method Public TCommands_shell.DisplayInfo Inicio | 
 -------------------------------------------------- 
}
Procedure TCommands_shell.DisplayInfo;
Begin
      If Silence = False Then
      
      Begin
            Writeln('Name and version 1.0 date [dd/mm/yyyy]');
            Writeln('Short description, http://www.your_site.com');
            Writeln('Copyright (c) by your name');
            Writeln('Type "help" for obtain help.');
            Writeln;
            Flush(Output);
      End;
End;
{
 ---------------------------------------------------- 
| Method Public TCommands_shell.Input_command Inicio | 
 ---------------------------------------------------- 
}
Procedure TCommands_shell.Input_command;
Begin
      Write(Prompt);
      Flush(Output);
      Readln(CommanLine);
      LowCommanLine := LowerCase(CommanLine);
      Commands.Clear;
      LowCommands.Clear;
      Parser_.Extract_values(CommanLine,Commands);
      Parser_.Extract_values(LowCommanLine,LowCommands);
End;
{
 ---------------------------------------------------- 
| Method Public TCommands_shell.Display_help  Inicio | 
 ---------------------------------------------------- 
}
Procedure TCommands_shell.Display_help;
Begin
      If Silence = False Then
      
      Begin
            Writeln('Quit = exit');
            Writeln('Help = obtain help');
            Flush(Output);
      End;
End;
{
 ----------------------------------------------- 
| Method Public TCommands_shell.For_help Inicio | 
 ----------------------------------------------- 
}
Procedure TCommands_shell.For_help;
Begin
      If Silence = False Then
      
      Begin
            Writeln('Error:"Command not found"; type "help" for obtain help.');
            Flush(Output);
      End;
End;
{
 --------------------------------------------------- 
| Method Public TCommands_shell.Display_exit Inicio | 
 --------------------------------------------------- 
}
Procedure TCommands_shell.Display_exit;
Begin
      Writeln('Exit');
      Flush(Output);
End;
{
 -------------------------------------------------------- 
| Method Public TCommands_shell.Current_directory Inicio | 
 -------------------------------------------------------- 
}
Procedure TCommands_shell.Current_directory;
Begin
      If Silence = False Then
      
      Begin
            Writeln(GetCurrentDirUTF8);
            Flush(Output);
      End;
End;       
{
 ------------------------------------------------------------ 
| Method Public TCommands_shell.Set_current_directory Inicio | 
 ------------------------------------------------------------ 
}
Procedure TCommands_shell.Set_current_directory(New_directory : String);
Begin
      {--- Change dir ---}
            
      New_directory := DelChars(New_directory,'"');
      
      If SetCurrentDirUTF8(New_directory) <> True Then
      
      Begin
            If Silence = False Then
      
            Begin
                  Writeln('Error:"Set_current_directory";');
                  Flush(Output);
            End;
      End
      
      Else
      
      Begin
            If Silence = False Then
      
            Begin
                  Writeln('Success:"New directory"; ',New_directory);
                  Flush(Output);
            End;
      End;
End;
{
 ----------------------------------------------------- 
| Method Public TCommands_shell.Find_parameter Inicio | 
 ----------------------------------------------------- 
}
Function TCommands_shell.Find_parameter(Parameter : String; Var Position : Word) : Boolean;

Var
    LowParameter : String;
    Counter1     : Integer; 

Begin
      If Parameters_str <> '' Then
      
      Begin
            LowParameter := LowerCase(Parameter);
            
            For Counter1 := 0 to LowParameters.Count - 1 do
            
            Begin
                  If LowParameter = LowParameters.Strings[Counter1] Then
                  
                  Begin
                        Position       := Counter1;
                        Find_parameter := True;
                        Exit;
                  End;
            End;
            
            Position       := 0;
            Find_parameter := False;
      End
      
      Else
      
      Begin
            Position       := 0;
            Find_parameter := False;
      End;
End;
{
 -------------------------------------------------------- 
| Method Public TCommands_shell.Find_parameter_cs Inicio | 
 -------------------------------------------------------- 
}
Function TCommands_shell.Find_parameter_cs(Parameter : String; Var Position : Word) : Boolean;

Var
    Counter1 : Integer; 

Begin
      If Parameters_str <> '' Then
      
      Begin
            For Counter1 := 0 to Parameters.Count - 1 do
            
            Begin
                  If Parameter = Parameters.Strings[Counter1] Then
                  
                  Begin
                        Position          := Counter1;
                        Find_parameter_cs := True;
                        Exit;
                  End;
            End;
            
            Position          := 0;
            Find_parameter_cs := False;
      End
      
      Else
      
      Begin
            Position          := 0;
            Find_parameter_cs := False;
      End;
End;
{
 -----------------------------------------------------------
| Method Public TCommands_shell.Process_command_line Inicio |
 -----------------------------------------------------------
}
Procedure TCommands_shell.Process_command_line;

Begin
End;
{
 ------------------------------------------------------
| Method Public TCommands_shell.Wait_for_output Inicio |
 ------------------------------------------------------
}
Procedure TCommands_shell.Wait_for_output;

Begin
      Flush(Output);
      Sleep(250);
End;

{*******************************<< Prc/Fun >>********************************}

  (* Empty *)

{******************************<< Initialize >>******************************}

{
 ----------------------- 
| Initialization Inicio |
 ----------------------- 
}
Begin
End.
{
 ----------------------- 
| Initialization Fin    |
 ----------------------- 
}
