#include <windows.h>
#include "../itemlist.h"
#include "itunesdb.h"
#include "resource.h"
#include "mt19937ar.h"

static int group;
//static const int RAND_MIDDLE = RAND_MAX/2;

static int get_result(int n) 
{
	switch ( n ) {
      case CSTR_LESS_THAN : return -1;
      case CSTR_EQUAL     : return  0;
      case CSTR_GREATER_THAN : return  1;
	  default: return  0;
      }
}
#define SKIP_THE_AND_WHITESPACE(x) { while (!isalnum(*x) && *x) x++; if (!_strnicmp(x,"the ",4)) x+=4; while (*x == ' ') x++; }
static int STRCMP_NULLOK(const char *pa, const char *pb)
{
  if (!pa) pa="";
  else SKIP_THE_AND_WHITESPACE(pa)
  if (!pb) pb="";
  else SKIP_THE_AND_WHITESPACE(pb) 
  return get_result(CompareString(LOCALE_SYSTEM_DEFAULT,0,pa,-1,pb,-1));
}


static int CMP_TRACKNUM(int aa, int bb)
{
  int a=aa;
  int b=bb;
  if(a==NULL || a<0) a=0;
  if(b==NULL || b<0) b=0;
  return a-b;
}

static int sortFunc_cardinality(const void *elem1, const void *elem2)
{
  C_ItemList * a = (C_ItemList *)*(void **)elem1; 
  C_ItemList * b = (C_ItemList *)*(void **)elem2;
  return a->GetSize() - b->GetSize();
}

static int sortFunc_reversecardinality(const void *elem1, const void *elem2)
{
  C_ItemList * a = (C_ItemList *)*(void **)elem1; 
  C_ItemList * b = (C_ItemList *)*(void **)elem2;
  return b->GetSize() - a->GetSize();
}

static int sortFunc_group(const void *elem1, const void *elem2)
{
  Song * a = (Song *)*(void **)elem1;
  Song * b = (Song *)*(void **)elem2;
  switch(group) {
  case 1: return STRCMP_NULLOK(a->album,b->album);
  case 2: return STRCMP_NULLOK(a->artist,b->artist);
  case 3: return STRCMP_NULLOK(a->genre,b->genre);
  }   
  return 0;
}

extern void randomizeList(void *list, int elems, int elemsize); // in view_ipod.cpp


static int sortFunc_track(const void *elem1, const void *elem2)
{ return CMP_TRACKNUM(((Song *)*(void **)elem1)->track_nr,((Song *)*(void **)elem2)->track_nr);
}

static char* getGroupItem(Song * s,int group)
{
  if(!s) return NULL;
  switch(group) {
  case 1: return s->album;
  case 2: return s->artist;
  case 3: return s->genre;
  }
  return NULL;
}

static bool shuffle_separate(C_ItemList * pl, int separate)
{
  if(pl->GetSize()<2) return false;

  C_ItemList * groups = new C_ItemList;
  C_ItemList * curGroup;
  group = separate;
  qsort(pl->GetAll(),pl->GetSize(),sizeof(void*),sortFunc_group);
  int l=pl->GetSize();
  char * curGroupStr=NULL;
  for(int i=0; i<l; i++)
  {
    if(STRCMP_NULLOK(curGroupStr,getGroupItem((Song *)pl->Get(i),group))==0 && i>0)
      curGroup->Add(pl->Get(i));
    else
    {
      if(i>0) randomizeList(curGroup->GetAll(),curGroup->GetSize(),sizeof(void*));
      curGroup = new C_ItemList;
      groups->Add(curGroup);
      curGroup->Add(pl->Get(i));
      curGroupStr = getGroupItem((Song *)pl->Get(i),group);
    }
    pl->Set(i,NULL);
  }
  randomizeList(curGroup->GetAll(),curGroup->GetSize(),sizeof(void*));
  qsort(groups->GetAll(),groups->GetSize(),sizeof(void*),sortFunc_reversecardinality);
  
  C_ItemList * gTo;
  C_ItemList * gFrom;
  int nextSize=0;
  if(groups->GetSize() > 4)
  {
    gTo = (C_ItemList*)groups->Get(groups->GetSize() - 2);
    gFrom = (C_ItemList*)groups->Get(groups->GetSize() - 1);
    nextSize = gFrom->GetSize() + gTo->GetSize();
  }
  while(groups->GetSize() > 4 && nextSize < l/5)
  {
    int i = gFrom->GetSize();
    while(i>0) gTo->Add(gFrom->Get(--i));
    groups->Del(groups->GetSize() - 1);
    delete gFrom;
    randomizeList(gTo->GetAll(),gTo->GetSize(),sizeof(void*));
    qsort(groups->GetAll(),groups->GetSize(),sizeof(void*),sortFunc_reversecardinality);
    gTo = (C_ItemList*)groups->Get(groups->GetSize() - 2);
    gFrom = (C_ItemList*)groups->Get(groups->GetSize() - 1);
    nextSize=gFrom->GetSize() + gTo->GetSize();
  }

  qsort(groups->GetAll(),groups->GetSize(),sizeof(void*),sortFunc_reversecardinality);

  int lgs = groups->GetSize();
  int randomConst = genrand_int31() % 10; //(10 * rand())/RAND_MAX;
  for(int i=0; i<lgs; i++)
  {
    curGroup = (C_ItemList*)groups->Get(i);
    int lg=curGroup->GetSize();
    int beenFullCycle=0;
    int denom = lg;
    int pp=0; //-(l/denom);
    for(int j=0; j<lg; j++)
    {
      pp = ((j*l)/denom + l/(2*denom) + i + randomConst) % l;
      int p=pp;
      while (pl->Get(p)!=NULL) 
      {
tryAgain:
        p=(p+1)%l;
        if(pp==p)  beenFullCycle=1;
      }
      if(pl->Get(p)==NULL && pl->Get((p+1)%l)==NULL && beenFullCycle==0) p=(p+1)%l;
      if(STRCMP_NULLOK(getGroupItem((Song*)pl->Get(p+1),group),getGroupItem((Song*)curGroup->Get(j),group))==0 && beenFullCycle==0)
      { goto tryAgain;
      }
      if(STRCMP_NULLOK(getGroupItem((Song*)pl->Get(p-1),group),getGroupItem((Song*)curGroup->Get(j),group))==0 && beenFullCycle==0)
      { goto tryAgain;
      }
      pl->Set(p,curGroup->Get(j));
    }
    delete curGroup;
  }
  delete groups;
  return true;
}


static bool shuffle_group(C_ItemList * pl, int groupField)
{
  if(pl->GetSize()<2) return false;

  C_ItemList * groups = new C_ItemList;
  C_ItemList * curGroup;
  group = groupField;
  qsort(pl->GetAll(),pl->GetSize(),sizeof(void*),sortFunc_group);
  int l=pl->GetSize();
  char * curGroupStr=NULL;
  for(int i=0; i<l; i++)
  {
    if(STRCMP_NULLOK(curGroupStr,getGroupItem((Song *)pl->Get(i),group))==0 && i>0)
      curGroup->Add(pl->Get(i));
    else
    {
      if(i>0) { if(group==1) qsort(curGroup->GetAll(),curGroup->GetSize(),sizeof(void*),sortFunc_track);
      else randomizeList(curGroup->GetAll(),curGroup->GetSize(),sizeof(void*)); }
      curGroup = new C_ItemList;
      groups->Add(curGroup);
      curGroup->Add(pl->Get(i));
      curGroupStr = getGroupItem((Song *)pl->Get(i),group);
    }
    pl->Set(i,NULL);
  }
  if(group==1) qsort(curGroup->GetAll(),curGroup->GetSize(),sizeof(void*),sortFunc_track);
  else randomizeList(curGroup->GetAll(),curGroup->GetSize(),sizeof(void*));
  randomizeList(groups->GetAll(),groups->GetSize(),sizeof(void*));
  
  int lgs = groups->GetSize();
  int k=0;
  for(int i=0; i<lgs; i++)
  {
    curGroup = (C_ItemList*)groups->Get(i);
    int lg=curGroup->GetSize();
    for(int j=0; j<lg; j++)
    {
      pl->Set(k++,curGroup->Get(j));
    }
    delete curGroup;
  }
  delete groups;
  return true;
}



bool SmartShuffle(C_ItemList * pl,int sortby)
{
  //srand(GetTickCount() % RAND_MAX);
  init_genrand(GetTickCount());
  switch(sortby)
  {
  case ID_IPODSORT_SMARTSHUFFLE_SHUFFLEGROUPINGALBUMS:
    return shuffle_group(pl,1);
  case ID_IPODSORT_SMARTSHUFFLE_SHUFFLEGROUPINGARTISTS:
    return shuffle_group(pl,2);
  case ID_IPODSORT_SMARTSHUFFLE_SHUFFLEGROUPINGGENRES:
    return shuffle_group(pl,3);
  case ID_IPODSORT_SMARTSHUFFLE_SHUFFLESEPARATINGALBUMS:
    return shuffle_separate(pl,1);
  case ID_IPODSORT_SMARTSHUFFLE_SHUFFLESEPARATINGARTISTS:
    return shuffle_separate(pl,2);
  case ID_IPODSORT_SMARTSHUFFLE_SHUFFLESEPARATINGGENRES:
    return shuffle_separate(pl,3);
  }
  return false;
}