#define _CRT_SECURE_NO_DEPRECATE
#include "config.h"
#include "wa_transcode.h"
extern winampMediaLibraryPlugin plugin;
extern int STRCMP_NULLOK(const char *pa, const char *pb);
extern bool g_detectAll;
extern bool g_make_blank;
extern bool g_log;


extern char g_filenamescheme[255];
extern char g_outputroot[255];

extern HMENU m_context_menus;
extern FILE * g_logfile;
extern char g_logfilepath[];
extern int g_prefs_openpage;
extern view_ipod * currentiPod;
extern C_ItemList * iPods;
extern view_ipod * configiPod;
extern HWND hwnd_config;
extern char *conf_file;
extern prefsDlgRec prefsPage;

HWND m_hwndDlg;



void config_tab_init(HWND tab);

HWND m_hwndTab,m_hwndTabDisplay;

static BOOL CALLBACK config_dlgproc_general(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam){
  switch(uMsg)
  {
  case WM_INITDIALOG:
    {
      config_tab_init(hwndDlg);
      if(!configiPod) {
        EnableWindow(GetDlgItem(hwndDlg, IDC_ARTISTALBUM),FALSE);
        EnableWindow(GetDlgItem(hwndDlg, IDC_SIMPLE),FALSE);
        EnableWindow(GetDlgItem(hwndDlg, IDC_SYNCRATINGSONCONNECT),FALSE);
        EnableWindow(GetDlgItem(hwndDlg, IDC_SYNCRATINGSONEJECT),FALSE);
        EnableWindow(GetDlgItem(hwndDlg, IDC_LIVE_SMART_PLAYLISTS),FALSE);
      } else {
        CheckDlgButton(hwndDlg,IDC_SYNCRATINGSONCONNECT,BST_INDETERMINATE);
        if(GetPrivateProfileInt("ml_ipod","syncRatingsOnConnect",1,configiPod->ini_file)) CheckDlgButton(hwndDlg,IDC_SYNCRATINGSONCONNECT,BST_CHECKED);
        if(GetPrivateProfileInt("ml_ipod","syncRatingsOnEject",1,configiPod->ini_file)) CheckDlgButton(hwndDlg,IDC_SYNCRATINGSONEJECT,BST_CHECKED);
        if(GetPrivateProfileInt("ml_ipod","livesmartplaylists",0,configiPod->ini_file)) CheckDlgButton(hwndDlg,IDC_LIVE_SMART_PLAYLISTS,BST_CHECKED);
        if(configiPod->g_artistalbum) CheckDlgButton(hwndDlg,IDC_ARTISTALBUM,BST_CHECKED);
        else CheckDlgButton(hwndDlg,IDC_SIMPLE,BST_CHECKED);
      }
      if(GetPrivateProfileInt("ml_ipod","experimental",0,conf_file)) CheckDlgButton(hwndDlg,IDC_EXPERIMENTAL,BST_CHECKED);
      if(GetPrivateProfileInt("ml_ipod","noupdatenotify",0,conf_file)) CheckDlgButton(hwndDlg,IDC_NONOTIFY,BST_CHECKED);
      if(g_detectAll) CheckDlgButton(hwndDlg,IDC_DETECTALL,BST_CHECKED);
      int x;
      for (x = 0; x < 24; x ++)
      {
        char buf[3]="C:";
        buf[0]+=x;
        int a=SendDlgItemMessage(hwndDlg,IDC_COMBO1,CB_ADDSTRING,0,(LPARAM)buf);
        if(configiPod) if (!STRCMP_NULLOK(configiPod->g_ipod_drive,buf))
          SendDlgItemMessage(hwndDlg,IDC_COMBO1,CB_SETCURSEL,a,0);
      }
      break;
    }
  case WM_COMMAND:
    switch (LOWORD(wParam))
    {
    case IDC_BUTTON_FORMAT: {
      bool noformat=false;
      if(configiPod) if(configiPod->g_sendfiles_hwnd) noformat=true;
      if(noformat==false)
      {
        char temp[100]="";
        char drive[8];
        GetDlgItemText(hwndDlg,IDC_COMBO1,drive,sizeof(drive)-1);
        sprintf(temp,"This will format drive %s as an iPod.\nAll data on that drive will be lost!\nDo you want to proceed?",drive);
        if(MessageBox(hwndDlg,temp,"Warning!",MB_YESNO)==IDNO) return 0;
        sprintf(temp,"%s\\iPod_Control",drive);
        if(CreateDirectory(temp,NULL)==0) {
          if(GetLastError() == ERROR_ALREADY_EXISTS) {
            sprintf(temp,"%s\\iPod_Control\\*",drive);
            char * foo = temp+strlen(temp)+1;
            strcpy(foo,"");
            foo=temp;
            SHFILEOPSTRUCT rd;
            rd.wFunc=FO_DELETE;
            rd.pFrom=foo;
            rd.pTo=NULL;
            rd.fFlags=FOF_NOCONFIRMATION+FOF_SILENT;
            int ret = SHFileOperation(&rd);
            if(ret!=0 || rd.fAnyOperationsAborted) {
              MessageBox(hwndDlg,"Could not format iPod","In Use",0);
              return 0;
            }
          } else {MessageBox(hwndDlg,"Could not format iPod","In Use",0); return 0; }
        }
        sprintf(temp,"%s\\iPod_Control\\iTunes",drive);
        CreateDirectory(temp,NULL);
        sprintf(temp,"%s\\iPod_Control\\Music",drive);
        CreateDirectory(temp,NULL);
        sprintf(temp,"%s\\iPod_Control\\Device",drive);
        CreateDirectory(temp,NULL);
        for(int i=0; i<20; i++) {
          sprintf(temp,"%s\\iPod_Control\\Music\\F%02i",drive,i);
          CreateDirectory(temp,NULL);
        }
        if(configiPod) delete configiPod;
        g_make_blank=true;
        configiPod = new view_ipod(drive[0]);
        g_make_blank=false;
      }
      break; }
    case IDC_COMBO1:
      /*
      if(HIWORD(wParam)==CBN_KILLFOCUS && !g_sendfiles_hwnd) {
        GetDlgItemText(hwndDlg,IDC_COMBO1,g_ipod_drive,sizeof(g_ipod_drive)-1);
        g_ipod_drive[sizeof(g_ipod_drive)-1]=0;
        WritePrivateProfileString("ml_ipod","ipodpath",g_ipod_drive,configiPod->ini_file);

        parseIpodDb();
        sortPlaylists();
        //updateList();
      }
      */
      break;
    case IDC_SIMPLE:
      if(configiPod) if(IsDlgButtonChecked(hwndDlg,IDC_SIMPLE)!=0) CheckDlgButton(hwndDlg,IDC_ARTISTALBUM,0);
    case IDC_ARTISTALBUM:
      if(configiPod) if(!configiPod->g_sendfiles_hwnd) 
      {
        configiPod->g_artistalbum=IsDlgButtonChecked(hwndDlg,IDC_ARTISTALBUM)!=0;
        if(configiPod->g_artistalbum) CheckDlgButton(hwndDlg,IDC_SIMPLE,0);

        WritePrivateProfileString("ml_ipod","artistalbum",configiPod->g_artistalbum?"1":"0",configiPod->ini_file);
        SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,ML_TREEVIEW_ID_DEVICES,ML_IPC_SETCURTREEITEM);
        SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,configiPod->myParam,ML_IPC_SETCURTREEITEM);
      }
    case IDC_SYNCRATINGSONCONNECT:
      if(configiPod) WritePrivateProfileString("ml_ipod","syncRatingsOnConnect",IsDlgButtonChecked(hwndDlg,IDC_SYNCRATINGSONCONNECT)?"1":"0",configiPod->ini_file);
      break;
    case IDC_SYNCRATINGSONEJECT:
      if(configiPod) WritePrivateProfileString("ml_ipod","syncRatingsOnEject",IsDlgButtonChecked(hwndDlg,IDC_SYNCRATINGSONEJECT)?"1":"0",configiPod->ini_file);
      break;
    case IDC_EXPERIMENTAL:
      WritePrivateProfileString("ml_ipod","experimental",IsDlgButtonChecked(hwndDlg,IDC_EXPERIMENTAL)?"1":"0",conf_file);
      break;
    case IDC_LIVE_SMART_PLAYLISTS:
      if(configiPod) WritePrivateProfileString("ml_ipod","livesmartplaylists",IsDlgButtonChecked(hwndDlg,IDC_LIVE_SMART_PLAYLISTS)?"1":"0",configiPod->ini_file);
      break;
    case IDC_NONOTIFY:
      WritePrivateProfileString("ml_ipod","noupdatenotify",IsDlgButtonChecked(hwndDlg,IDC_NONOTIFY)?"1":"0",conf_file);
      break;
    case IDC_DETECTALL:
      g_detectAll=IsDlgButtonChecked(hwndDlg,IDC_DETECTALL)!=0;
      WritePrivateProfileString("ml_ipod","detectAll",g_detectAll?"1":"0",conf_file);
      break;
    case IDC_SHOWICONALWAYS:
      /*
      showIconAlways = IsDlgButtonChecked(hwndDlg,IDC_SHOWICONALWAYS)==0;
      WritePrivateProfileString("ml_ipod","showiconalways",showIconAlways?"1":"0",configiPod->ini_file);
      if(m_playlists.GetSize()<1) {
        if(showIconAlways && !myParam) {
          m_treeview = GetDlgItem(plugin.hwndLibraryParent,0x3fd); //this number is actually magic :)
          myParam=TreeView_GetCount(m_treeview) + 8000;  
          HTREEITEM devices = dofindByParam(ML_TREEVIEW_ID_DEVICES,NULL);
          TVITEM tvi = {TVIF_TEXT|TVIF_PARAM,};
          tvi.lParam=myParam;
          tvi.pszText="iPod";
          tvi.cchTextMax=4;
          TVINSERTSTRUCT tis = {devices,TVI_LAST,};
          tis.item=tvi;
          m_treeparent = TreeView_InsertItem(m_treeview,&tis);
        } else {
          TreeView_DeleteItem(m_treeview,m_treeparent);
          myParam=NULL;
        }
      }
      */
      break;
    }
  }
  return 0;
}

static BOOL CALLBACK config_dlgproc_advsettings(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam){
  if(!configiPod) return 0;
  switch(uMsg) {
  case WM_INITDIALOG:
    {

      int useipodfs=!GetPrivateProfileInt("ml_ipod","noipodfs",0,configiPod->ini_file);

      CheckDlgButton(hwndDlg,IDC_USEIPODFS,useipodfs?BST_CHECKED:0);
      if (useipodfs)
      {
        EnableWindow(GetDlgItem(hwndDlg,IDC_NFMT),0);
        EnableWindow(GetDlgItem(hwndDlg,IDC_FILENAMESCHEME),0);
        EnableWindow(GetDlgItem(hwndDlg,IDC_FORMATHELP),0);
        EnableWindow(GetDlgItem(hwndDlg,IDC_PREVIEW),0);
        EnableWindow(GetDlgItem(hwndDlg,IDC_EXAMPLE),0);
      }
      
      char buf[4096];
      GetPrivateProfileString("ml_ipod","noipodfs_fmt","<Artist> - <Album>\\## - <Title>",buf,sizeof(buf),configiPod->ini_file);
      SetDlgItemText(hwndDlg,IDC_FILENAMESCHEME,buf);
    }
  break;
  case WM_COMMAND:
    switch (LOWORD(wParam))
    {
    case IDC_FORMATHELP:
      MessageBox(hwndDlg, (char*)"You may enter a filename format string for your copied files.\nIt can contain \\ or / to delimit a path, and the following keywords:\n  <Artist> - inserts the artist with the default capitalization\n  <ARTIST> - inserts the artist in all uppercase\n  <artist> - inserts the artist in all lowercase\n  <Album>/<ALBUM>/<album> - inserts the album\n  <year> - inserts the album year\n  <Genre>/<GENRE>/<genre> - inserts the album genre\n  <Title>/<TITLE>/<title> - inserts the track title\n  #, ##, ### - inserts the track number, with leading 0s if ## or ###", "Reverse Sync filename format help", MB_OK);
      break;
    case IDC_FILENAMESCHEME:
      if(configiPod) switch(HIWORD(wParam))
      {
      case EN_CHANGE:
        {
          HWND rhwnd = GetDlgItem(hwndDlg, IDC_FILENAMESCHEME);
          //const int len = GetWindowTextLength(rhwnd);
          char filenamescheme[4096];
          GetDlgItemText(hwndDlg, IDC_FILENAMESCHEME, filenamescheme, 4096);
          Song song;
          song.artist = "U2";
          song.title = "Exit";
          song.album = "Joshua Tree";
          song.year = 1987;
          song.track_nr = 10;
          song.genre = "Self-righteous Rock";
          char *tmp = FixReplacementVars(filenamescheme, sizeof(filenamescheme), &song, true);
          strcat(tmp,".mp3");
          SetDlgItemText(hwndDlg, IDC_EXAMPLE, tmp);
        }
        break;
      }//switch (HIWORD(wParam))
      break;

    case IDC_USEIPODFS:
      {
        int en=!IsDlgButtonChecked(hwndDlg,IDC_USEIPODFS);
        EnableWindow(GetDlgItem(hwndDlg,IDC_NFMT),en);
        EnableWindow(GetDlgItem(hwndDlg,IDC_FILENAMESCHEME),en);
        EnableWindow(GetDlgItem(hwndDlg,IDC_FORMATHELP),en);
        EnableWindow(GetDlgItem(hwndDlg,IDC_PREVIEW),en);
        EnableWindow(GetDlgItem(hwndDlg,IDC_EXAMPLE),en);
      }
    break;
    case IDOK:
      WritePrivateProfileString("ml_ipod","noipodfs",IsDlgButtonChecked(hwndDlg,IDC_USEIPODFS)?"0":"1",configiPod->ini_file);
      {
        char buf[4096];
        GetDlgItemText(hwndDlg,IDC_FILENAMESCHEME,buf,sizeof(buf));
        WritePrivateProfileString("ml_ipod","noipodfs_fmt",buf,configiPod->ini_file);
      }
      //don't break, we still want to exit.
    case IDCANCEL:
      EndDialog(hwndDlg,0);
      break;
    }
    break;
  }
  return 0;
}

static BOOL CALLBACK config_dlgproc_syncsettings(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam){
  if(!configiPod) return 0;
  static int sortMethod;
  static unsigned int spaceToAutofill, totalmb;
  switch(uMsg) {
  case WM_INITDIALOG:
    {
      char tmp[1024];
      GetPrivateProfileString("ml_ipod", "syncquery",defaultQueryString,tmp,1023,configiPod->ini_file);
      SetDlgItemText(hwndDlg, IDC_IPOD_SYNC_QUERY_STRING, tmp);
      GetPrivateProfileString("ml_ipod", "autofillquery",defaultAutoFillQueryString,tmp,1023,configiPod->ini_file);
      SetDlgItemText(hwndDlg, IDC_IPOD_AUTOFILL_QUERY_STRING, tmp);
      GetPrivateProfileString("ml_ipod", "autofillratings",defaultRatingsFilterString,tmp,1023,configiPod->ini_file);
      SetDlgItemText(hwndDlg, IDC_AUTOFILL_RATINGS, tmp);
      if(GetPrivateProfileInt("ml_ipod","syncplaylists",0,configiPod->ini_file)) CheckDlgButton(hwndDlg,IDC_PLSYNC,BST_CHECKED);
      if(GetPrivateProfileInt("ml_ipod","checkfiledates",1,configiPod->ini_file)) CheckDlgButton(hwndDlg,IDC_UPDATEMODIFIED,BST_CHECKED);
      if(GetPrivateProfileInt("ml_ipod","truesync",1,configiPod->ini_file)) CheckDlgButton(hwndDlg,IDC_TRUESYNC,BST_CHECKED);
      else EnableWindow(GetDlgItem(hwndDlg,IDC_UPDATEMODIFIED),0);
      if(GetPrivateProfileInt("ml_ipod","autosmartsync",1,configiPod->ini_file)) CheckDlgButton(hwndDlg,IDC_AUTOSMARTSYNC,BST_CHECKED);
      sortMethod=GetPrivateProfileInt("ml_ipod","autofillsort",40038,configiPod->ini_file);
      if(GetPrivateProfileInt("ml_ipod","autofillbyalbum",configiPod->isiPodNano,configiPod->ini_file)) CheckDlgButton(hwndDlg,IDC_AUTOFILLALBUMS,BST_CHECKED);

      ULARGE_INTEGER free={0,}, total={0,}, freeb={0,};
      GetDiskFreeSpaceEx(configiPod->g_ipod_drive,  &free, &total, &freeb);
      totalmb=(unsigned int)((total.QuadPart)/(1024*1024));
      totalmb-=3;
      spaceToAutofill=GetPrivateProfileInt("ml_ipod","autofillspace",(totalmb*9)/10,configiPod->ini_file);
      wsprintf(tmp,"Fill %d MB",spaceToAutofill);
      SetDlgItemText(hwndDlg, IDC_FILLCAPTION, tmp);

      SendMessage(GetDlgItem(hwndDlg,IDC_SPACESLIDER),TBM_SETRANGEMAX, TRUE, totalmb);
      SendMessage(GetDlgItem(hwndDlg,IDC_SPACESLIDER),TBM_SETRANGEMIN, TRUE, 0);
      SendMessage(GetDlgItem(hwndDlg,IDC_SPACESLIDER),TBM_SETPOS, TRUE, spaceToAutofill);
      /*
      if(!configiPod->isiPodShuffle && !configiPod->isiPodNano) {
        EnableWindow(GetDlgItem(hwndDlg,IDC_IPOD_AUTOFILL_QUERY_STRING),0);
        EnableWindow(GetDlgItem(hwndDlg,IDC_AUTOFILL_RATINGS),0);
        EnableWindow(GetDlgItem(hwndDlg,IDC_SPACESLIDER),0);
        EnableWindow(GetDlgItem(hwndDlg,IDC_AUTOFILL_SORTMETHOD),0);
        EnableWindow(GetDlgItem(hwndDlg,IDC_IPOD_AUTOFILL_QUERY_EDIT),0);
        EnableWindow(GetDlgItem(hwndDlg,IDC_FILLCAPTION),0);
        EnableWindow(GetDlgItem(hwndDlg,IDC_AUTOFILLALBUMS),0);
      }
      */
    }
    break;
  case WM_NOTIFY:
    switch (LOWORD(wParam))
    {
    case IDC_SPACESLIDER:
      {
        spaceToAutofill = SendMessage(GetDlgItem(hwndDlg,IDC_SPACESLIDER),TBM_GETPOS,0,0);
        char tmp[100]="";
        wsprintf(tmp,"Fill %d MB",spaceToAutofill);
        SetDlgItemText(hwndDlg, IDC_FILLCAPTION, tmp);
      }
      break;
    }
    break;
  case WM_COMMAND:
    switch (LOWORD(wParam))
    {
    case IDC_TRUESYNC:
      EnableWindow(GetDlgItem(hwndDlg,IDC_UPDATEMODIFIED),IsDlgButtonChecked(hwndDlg,IDC_TRUESYNC));
      break;
    case IDC_AUTOFILL_SORTMETHOD:
      {
        HMENU menu=GetSubMenu(m_context_menus,5);
        CheckMenuItem(menu,sortMethod,MF_BYCOMMAND+MF_CHECKED);
        POINT p;
        GetCursorPos(&p);
        int r=TrackPopupMenu(menu,TPM_RETURNCMD|TPM_RIGHTBUTTON|TPM_LEFTBUTTON|TPM_NONOTIFY,p.x,p.y,0,hwndDlg,NULL);
        if(r==0) break;
        CheckMenuItem(menu,sortMethod,MF_BYCOMMAND+MF_UNCHECKED);
        sortMethod=r;
      }
      break;
    case IDC_IPOD_AUTOFILL_QUERY_EDIT:
      {
        char temp[1024];
        GetDlgItemText(hwndDlg, IDC_IPOD_AUTOFILL_QUERY_STRING, temp, sizeof(temp) - 1);
        
        ml_editview meq = {hwndDlg,temp,"Autofill Query",-1};
        if(!(int)SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(LPARAM)&meq,ML_IPC_EDITVIEW)) return 0;
        SetDlgItemText(hwndDlg, IDC_IPOD_AUTOFILL_QUERY_STRING, meq.query); 
      }
      break;
    case IDC_IPOD_SYNC_QUERY_EDIT:
      {
        char temp[1024];
        GetDlgItemText(hwndDlg, IDC_IPOD_SYNC_QUERY_STRING, temp, sizeof(temp) - 1);
        
        ml_editview meq = {hwndDlg,temp,"Sync Query",-1};
        if(!(int)SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(LPARAM)&meq,ML_IPC_EDITVIEW)) return 0;
        SetDlgItemText(hwndDlg, IDC_IPOD_SYNC_QUERY_STRING, meq.query); 
      }
      break;
    case IDOK:
      {
        char temp[1024];
        GetDlgItemText(hwndDlg, IDC_IPOD_SYNC_QUERY_STRING, temp, sizeof(temp) - 1);
        WritePrivateProfileString("ml_ipod","syncquery",temp,configiPod->ini_file);

        GetDlgItemText(hwndDlg, IDC_IPOD_AUTOFILL_QUERY_STRING, temp, sizeof(temp) - 1);
        WritePrivateProfileString("ml_ipod","autofillquery",temp,configiPod->ini_file);

        GetDlgItemText(hwndDlg, IDC_AUTOFILL_RATINGS, temp, sizeof(temp) - 1);
        WritePrivateProfileString("ml_ipod","autofillratings",temp,configiPod->ini_file);
        
        wsprintf(temp,"%d",sortMethod);
        WritePrivateProfileString("ml_ipod","autofillsort",temp,configiPod->ini_file);
        
        wsprintf(temp,"%d",spaceToAutofill);
        WritePrivateProfileString("ml_ipod","autofillspace",temp,configiPod->ini_file);

        WritePrivateProfileString("ml_ipod","syncplaylists",IsDlgButtonChecked(hwndDlg,IDC_PLSYNC)?"1":"0",configiPod->ini_file);
        WritePrivateProfileString("ml_ipod","truesync",IsDlgButtonChecked(hwndDlg,IDC_TRUESYNC)?"1":"0",configiPod->ini_file);
        WritePrivateProfileString("ml_ipod","autosmartsync",IsDlgButtonChecked(hwndDlg,IDC_AUTOSMARTSYNC)?"1":"0",configiPod->ini_file);
        WritePrivateProfileString("ml_ipod","checkfiledates",IsDlgButtonChecked(hwndDlg,IDC_UPDATEMODIFIED)?"1":"0",configiPod->ini_file);
        configiPod->checkfiledates=(IsDlgButtonChecked(hwndDlg,IDC_UPDATEMODIFIED) && IsDlgButtonChecked(hwndDlg,IDC_TRUESYNC));
        WritePrivateProfileString("ml_ipod","autofillbyalbum",IsDlgButtonChecked(hwndDlg,IDC_AUTOFILLALBUMS)?"1":"0",configiPod->ini_file);
      }
      //don't break, we still want to exit.
    case IDCANCEL:
      EndDialog(hwndDlg,0);
      break;
    }
    break;
  }
  return 0;
}

static BOOL CALLBACK config_dlgproc_transfer(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam){
  switch(uMsg) {
  case WM_INITDIALOG:
    {
      config_tab_init(hwndDlg);
      if(!configiPod) {
        EnableWindow(GetDlgItem(hwndDlg, IDC_CONFIRM_EVERY),FALSE);
        EnableWindow(GetDlgItem(hwndDlg, IDC_CONFIRM_SYNC),FALSE);
        EnableWindow(GetDlgItem(hwndDlg, IDC_CONFIRM_NEVER),FALSE);
        EnableWindow(GetDlgItem(hwndDlg, IDC_SYNCSETTINGS),FALSE);
        EnableWindow(GetDlgItem(hwndDlg, IDC_ADVANCEDSETTINGS),FALSE);
        EnableWindow(GetDlgItem(hwndDlg, IDC_OUTPUTROOT),FALSE);
        EnableWindow(GetDlgItem(hwndDlg, IDC_BROWSEOUTPUT),FALSE);
        EnableWindow(GetDlgItem(hwndDlg, IDC_OVERWRITE),FALSE);
        EnableWindow(GetDlgItem(hwndDlg, IDC_FILENAMESCHEME),FALSE);
        //EnableWindow(GetDlgItem(hwndDlg, IDC_FORMATHELP),FALSE);
      } else {
        char tmp[1024];
        tmp[1023]=0;
        GetPrivateProfileString("ml_ipod", "rs_filenamescheme", "<Artist>\\<Album>\\## <Title>", tmp, 1023, configiPod->ini_file);
        SetDlgItemText(hwndDlg, IDC_FILENAMESCHEME, tmp);
        GetPrivateProfileString("ml_ipod", "rs_outputroot", "C:\\", tmp, 1023, configiPod->ini_file);
        SetDlgItemText(hwndDlg, IDC_OUTPUTROOT, tmp);
        int syncConfirm = GetPrivateProfileInt("ml_ipod","syncConfirm",1,configiPod->ini_file);
        if(syncConfirm==0) CheckDlgButton(hwndDlg,IDC_CONFIRM_NEVER,BST_CHECKED);
        else if(syncConfirm==1) CheckDlgButton(hwndDlg,IDC_CONFIRM_SYNC,BST_CHECKED);
        else if(syncConfirm==2) CheckDlgButton(hwndDlg,IDC_CONFIRM_EVERY,BST_CHECKED);
        if(!GetPrivateProfileInt("ml_ipod", "rs_overwrite", 1, configiPod->ini_file)) CheckDlgButton(hwndDlg, IDC_OVERWRITE, BST_CHECKED);
      }
      if(g_log) CheckDlgButton(hwndDlg,IDC_LOG_TRANSFERS,BST_CHECKED);
      break;
    }
  case WM_COMMAND:
    switch (LOWORD(wParam))
    {
    case IDC_ADVANCEDSETTINGS:
      if(configiPod) CreateDialog(plugin.hDllInstance,MAKEINTRESOURCE(IDD_CONFIG_ADVSETTINGS),hwndDlg,config_dlgproc_advsettings);
      break;
    case IDC_SYNCSETTINGS:
      if(configiPod) CreateDialog(plugin.hDllInstance,MAKEINTRESOURCE(IDD_CONFIG_SYNCSETTINGS),hwndDlg,config_dlgproc_syncsettings);
      break;
    case IDC_CONFIRM_NEVER:
      if(configiPod) WritePrivateProfileString("ml_ipod","syncConfirm","0",configiPod->ini_file);
      break;
    case IDC_CONFIRM_SYNC:
      if(configiPod) WritePrivateProfileString("ml_ipod","syncConfirm","1",configiPod->ini_file);
      break;
    case IDC_CONFIRM_EVERY:
      if(configiPod) WritePrivateProfileString("ml_ipod","syncConfirm","2",configiPod->ini_file);
      break;
    case IDC_FILENAMESCHEME:
      if(configiPod) switch(HIWORD(wParam))
      {
      case EN_CHANGE:
        {
          HWND rhwnd = GetDlgItem(hwndDlg, IDC_FILENAMESCHEME);
          //const int len = GetWindowTextLength(rhwnd);
          char filenamescheme[4096];
          GetDlgItemText(hwndDlg, IDC_FILENAMESCHEME, filenamescheme, 4096);
          Song song;
          song.artist = "U2";
          song.title = "Exit";
          song.album = "Joshua Tree";
          song.year = 1987;
          song.track_nr = 10;
          song.genre = "Self-righteous Rock";
          char *tmp = FixReplacementVars(filenamescheme, sizeof(filenamescheme), &song, true);
          strcat(tmp,".mp3");
          SetDlgItemText(hwndDlg, IDC_EXAMPLE, tmp);
        }
        break;
      case EN_KILLFOCUS:
        GetDlgItemText(hwndDlg, IDC_FILENAMESCHEME, g_filenamescheme, sizeof(g_filenamescheme)-1);
        WritePrivateProfileString("ml_ipod", "rs_filenamescheme", g_filenamescheme, configiPod->ini_file);
        break;
      }//switch (HIWORD(wParam))
      break;
    case IDC_BROWSEOUTPUT:
      if(configiPod) {
        BROWSEINFO    bi;
        LPITEMIDLIST  iil;
        LPMALLOC    lpm;
        char bffFileName[MAX_PATH];
        ZeroMemory(&bi,sizeof(bi));
        bffFileName[0] = '\0';
        bi.hwndOwner    = hwndDlg;
        bi.pszDisplayName  = bffFileName;
        bi.lpszTitle    = "Choose a Folder or Create a New One";
        bi.ulFlags      = BIF_RETURNONLYFSDIRS | BIF_EDITBOX ;

        if((iil = SHBrowseForFolder(&bi)) != NULL)
        {
          SHGetPathFromIDList(iil,bffFileName);
          SHGetMalloc(&lpm);
          lpm->Free(iil);
          SetDlgItemText(hwndDlg, IDC_OUTPUTROOT, bffFileName);
          GetDlgItemText(hwndDlg, IDC_OUTPUTROOT, g_outputroot, sizeof(g_outputroot) - 1);
          WritePrivateProfileString("ml_ipod", "rs_outputroot", g_outputroot, configiPod->ini_file);
        }
      }
      break;
    case IDC_FORMATHELP:
      MessageBox(hwndDlg, (char*)"You may enter a filename format string for your copied files.\nIt can contain \\ or / to delimit a path, and the following keywords:\n  <Artist> - inserts the artist with the default capitalization\n  <ARTIST> - inserts the artist in all uppercase\n  <artist> - inserts the artist in all lowercase\n  <Album>/<ALBUM>/<album> - inserts the album\n  <year> - inserts the album year\n  <Genre>/<GENRE>/<genre> - inserts the album genre\n  <Title>/<TITLE>/<title> - inserts the track title\n  #, ##, ### - inserts the track number, with leading 0s if ## or ###", "Reverse Sync filename format help", MB_OK);
      break;
    case IDC_OUTPUTROOT:
      if(configiPod) if(HIWORD(wParam)==EN_KILLFOCUS) {
        GetDlgItemText(hwndDlg, IDC_OUTPUTROOT, g_outputroot, sizeof(g_outputroot) - 1);
        WritePrivateProfileString("ml_ipod", "rs_outputroot", g_outputroot, configiPod->ini_file);
      }
      break;
    case IDC_OVERWRITE:
      if(configiPod) {         
          if(IsDlgButtonChecked(hwndDlg, IDC_OVERWRITE))
            WritePrivateProfileString("ml_ipod", "rs_overwrite", "0", configiPod->ini_file);
          else
            WritePrivateProfileString("ml_ipod", "rs_overwrite", "1", configiPod->ini_file);
      }
      break;
    case IDC_OPEN_LOG:
      {
        //launch notepad.exe with the log file
        fclose(g_logfile);
        STARTUPINFO si={sizeof(si),0};
        PROCESS_INFORMATION pi={0};
        char runcmd[MAX_PATH];
        wsprintf(runcmd,"notepad.exe %s",g_logfilepath);
        CreateProcess(NULL,runcmd,NULL,NULL,FALSE,CREATE_NO_WINDOW,NULL,NULL,&si,&pi);
        g_logfile=fopen(g_logfilepath,"a");
        break;
      }
    case IDC_LOG_TRANSFERS:
      g_log=IsDlgButtonChecked(hwndDlg,IDC_LOG_TRANSFERS)!=0;
      WritePrivateProfileString("ml_ipod","log",g_log?"1":"0",conf_file);
      break;
    case IDC_LOG_CLEAR:
      fclose(g_logfile);
      _unlink(g_logfilepath);
      g_logfile=fopen(g_logfilepath,"a");
      break;
    }//switch(LOWORD(wParam))
  } //switch (uMsg)
  return 0;
}

static BOOL CALLBACK config_dlgproc_transcode_new (HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam) {
  static HWND m_encoderconfig;
  switch(uMsg) {
  case WM_INITDIALOG:
    {
      transcodeConfigStruct tds;
      tds.parent=hwndDlg;
      tds.conf_file = configiPod->ini_file;

      UINT ipc_transcode_config=SendMessage(plugin.hwndWinampParent,WM_WA_IPC,(WPARAM)&"IpcTranscodeConfig",IPC_REGISTER_WINAMP_IPCMESSAGE);
      m_encoderconfig = (HWND)SendMessage(plugin.hwndWinampParent,WM_WA_IPC,(WPARAM)&tds,ipc_transcode_config);
      RECT r;
      GetWindowRect(GetDlgItem(hwndDlg,IDC_PLACEHOLDER),&r);
      ScreenToClient(hwndDlg,(LPPOINT)&r);
      SetWindowPos(m_encoderconfig,NULL,r.left,r.top,0,0,SWP_NOACTIVATE|SWP_NOSIZE|SWP_NOZORDER);
      ShowWindow(m_encoderconfig,SW_SHOWNA);
    }
    break;
  case WM_DESTROY:
    
    break;
  case WM_COMMAND:
    switch (LOWORD(wParam))
    {
    case IDOK:
      SendMessage(m_encoderconfig,WM_USER,0,0); // get it to write the bitrate out
      DestroyWindow(m_encoderconfig);
      EndDialog(hwndDlg,0);
      break;
    }
    break;
  }
  return 0;
}

static BOOL CALLBACK config_dlgproc_transcode(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam){
  switch(uMsg) {
  case WM_INITDIALOG:
    {
      config_tab_init(hwndDlg);

      char tmp[1024];
      if(!configiPod) {
        EnableWindow(GetDlgItem(hwndDlg, IDC_TRANSCODE),FALSE);
        EnableWindow(GetDlgItem(hwndDlg, IDC_HIDECONSOLE),FALSE);
        EnableWindow(GetDlgItem(hwndDlg, IDC_TRANSCODE2),FALSE);
        EnableWindow(GetDlgItem(hwndDlg, IDC_TRANSCODE_CMD),FALSE);
        EnableWindow(GetDlgItem(hwndDlg, IDC_NEWTRANSCODE),FALSE);
        EnableWindow(GetDlgItem(hwndDlg, IDC_CONFIGNEWTRANSCODE),FALSE);
#ifndef NOHYMN
        EnableWindow(GetDlgItem(hwndDlg, IDC_TRANSCODEM4P),FALSE);
        EnableWindow(GetDlgItem(hwndDlg, IDC_HIDECONSOLE2),FALSE);
        EnableWindow(GetDlgItem(hwndDlg, IDC_TRANSCODE_CMD2),FALSE);
#endif
      } else {
//        GetPrivateProfileString("ml_ipod", "transcodecmd",defaultTranscodeString,tmp,1023,configiPod->ini_file);
//        SetDlgItemText(hwndDlg, IDC_TRANSCODE_CMD, tmp);
        if (GetPrivateProfileInt("ml_ipod","transcode",0,configiPod->ini_file))
          CheckDlgButton(hwndDlg,IDC_TRANSCODE,BST_CHECKED);
        if (GetPrivateProfileInt("ml_ipod","transcode2",0,configiPod->ini_file))
          CheckDlgButton(hwndDlg,IDC_TRANSCODE2,BST_CHECKED);
        if ((configiPod->g_hideconsole=GetPrivateProfileInt("ml_ipod","transcodehc",0,configiPod->ini_file)))          
          CheckDlgButton(hwndDlg,IDC_HIDECONSOLE,BST_CHECKED);
        GetPrivateProfileString("ml_ipod", "transcodecmd2", defaultTranscodeString2, tmp, 1023, configiPod->ini_file);
        SetDlgItemText(hwndDlg, IDC_TRANSCODE_CMD2, tmp);
        if(GetPrivateProfileInt("ml_ipod", "transcodehc2", 1, configiPod->ini_file))
          CheckDlgButton(hwndDlg, IDC_HIDECONSOLE2, BST_CHECKED);
        if(GetPrivateProfileInt("ml_ipod", "transcode3", 0, configiPod->ini_file))
          CheckDlgButton(hwndDlg, IDC_TRANSCODEM4P, BST_CHECKED);
        if(GetPrivateProfileInt("ml_ipod", "newtranscode", 1, configiPod->ini_file))
          CheckDlgButton(hwndDlg, IDC_NEWTRANSCODE, BST_CHECKED);
        break;
      }
    }
  case WM_COMMAND:
    if(!configiPod) return 0;
    switch (LOWORD(wParam))
    {
    case IDC_TRANSCODE_CMD:
      if (HIWORD(wParam) == EN_KILLFOCUS)
      {
        char buf[1024];
        GetDlgItemText(hwndDlg,IDC_TRANSCODE_CMD,buf,sizeof(buf));
        WritePrivateProfileString("ml_ipod","transcodecmd",buf,configiPod->ini_file);
      }
      break;
    case IDC_TRANSCODE_CMD2:
      if (HIWORD(wParam) == EN_KILLFOCUS)
      {
        char buf[1024];
        GetDlgItemText(hwndDlg,IDC_TRANSCODE_CMD2,buf,sizeof(buf));
        WritePrivateProfileString("ml_ipod","transcodecmd2",buf,configiPod->ini_file);
      }
      break;
    case IDC_TRANSCODE:
      WritePrivateProfileString("ml_ipod","transcode",IsDlgButtonChecked(hwndDlg,IDC_TRANSCODE)?"1":"0",configiPod->ini_file);
      break;
    case IDC_HIDECONSOLE:
      WritePrivateProfileString("ml_ipod","transcodehc",(configiPod->g_hideconsole=IsDlgButtonChecked(hwndDlg,IDC_HIDECONSOLE))?"1":"0",configiPod->ini_file);
      break;
    case IDC_HIDECONSOLE2:
      WritePrivateProfileString("ml_ipod","transcodehc2",(configiPod->g_hideconsole=IsDlgButtonChecked(hwndDlg,IDC_HIDECONSOLE2))?"1":"0",configiPod->ini_file);
      break;
    case IDC_TRANSCODE2:
      WritePrivateProfileString("ml_ipod","transcode2",IsDlgButtonChecked(hwndDlg,IDC_TRANSCODE2)?"1":"0",configiPod->ini_file);
      break;
    case IDC_TRANSCODEM4P:
      WritePrivateProfileString("ml_ipod","transcode3",IsDlgButtonChecked(hwndDlg,IDC_TRANSCODEM4P)?"1":"0",configiPod->ini_file);
      break;
    case IDC_CONFIGNEWTRANSCODE:
      CreateDialog(plugin.hDllInstance,MAKEINTRESOURCE(IDD_CONFIG_TRANSCODE_NEW),hwndDlg,config_dlgproc_transcode_new);
      break;
    case IDC_NEWTRANSCODE:
      WritePrivateProfileString("ml_ipod","newtranscode",IsDlgButtonChecked(hwndDlg,IDC_NEWTRANSCODE)?"1":"0",configiPod->ini_file);
      break;
    }
  }
  return 0;
}

static BOOL CALLBACK config_dlgproc_about(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam) {
  switch(uMsg) {
  case WM_INITDIALOG:
    {
      config_tab_init(hwndDlg);

      char filename[MAX_PATH]="";
      strcpy(filename, conf_file);
      strcpy(strrchr(filename,'\\'),"");
      strcat(filename,"\\Plugins\\ml_ipod_changelog.txt");
      int size=fileSize(filename);
      if(size<=0) return 0;
      char * log = (char *)calloc(size+10,1);
      FILE * file = fopen(filename,"rb");
      fread(log,size,1,file);
      fclose(file);
      SetDlgItemText(hwndDlg, IDC_CHANGELOG, log);
      free(log);
    }
    break;
  }
  return 0;
}

static BOOL CALLBACK config_dlgproc_donate(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam) {
  switch(uMsg) {
  case WM_INITDIALOG:
    config_tab_init(hwndDlg);
    break;
  case WM_COMMAND:
    switch(LOWORD(wParam)) {
      char * url;
    case IDC_VISITFORUM:
      url="http://forums.winamp.com/forumdisplay.php?s=&forumid=69";
      ShellExecute(hwndDlg,"open",url,NULL,NULL,SW_SHOWNA);
      break;
    case IDC_DONATE:
      url="http://sourceforge.net/donate/index.php?user_id=1016993";
      ShellExecute(hwndDlg,"open",url,NULL,NULL,SW_SHOWNA);
      break;
    }
  }
  return 0;
}

#define ETDT_DISABLE 0x01
#define ETDT_ENABLE 0x02
#define ETDT_ENABLETAB 0x06
#define ETDT_USETABTEXTURE 0x04
typedef HRESULT (WINAPI * ENABLETHEMEDIALOGTEXTURE)(HWND, DWORD);

void config_tab_init(HWND tab)
{
  RECT r;
  GetWindowRect(m_hwndTab,&r);
  TabCtrl_AdjustRect(m_hwndTab,FALSE,&r);
  MapWindowPoints(NULL,m_hwndDlg,(LPPOINT)&r,2);
  SetWindowPos(tab,HWND_TOP,r.left,r.top,r.right-r.left,r.bottom-r.top,SWP_NOACTIVATE);

  ENABLETHEMEDIALOGTEXTURE pfnETDT;
  HINSTANCE hDll;
  if(NULL != (hDll = LoadLibrary(TEXT("uxtheme.dll")))) {
    pfnETDT = (ENABLETHEMEDIALOGTEXTURE)GetProcAddress(hDll,"EnableThemeDialogTexture");
    if(NULL != pfnETDT) {
      pfnETDT(tab,ETDT_ENABLETAB);
    }
    FreeLibrary(hDll);
  }
}

struct pref_tab
{
  char *title;
  int res_id;
  DLGPROC dlg_proc;
} tabs[] = {
  {"S", IDD_CONFIG_GENERAL, config_dlgproc_general},
  {"]ݒ", IDD_CONFIG_TRANSFER, config_dlgproc_transfer},
#ifdef NOHYMN
  {"Transcoding", IDD_CONFIG_TRANSCODE_NOHYMN, config_dlgproc_transcode},
#else
  {"t@Cϊ", IDD_CONFIG_TRANSCODE, config_dlgproc_transcode},
#endif
  {"o[W", IDD_CONFIG_ABOUT, config_dlgproc_about},
};

VOID WINAPI OnSelChanged(HWND hwndDlg) 
{
  int sel=TabCtrl_GetCurSel(m_hwndTab);
  g_prefs_openpage=sel;
  if(m_hwndTabDisplay!=NULL)
    DestroyWindow(m_hwndTabDisplay);
  m_hwndTabDisplay=CreateDialog(plugin.hDllInstance,MAKEINTRESOURCE(tabs[sel].res_id),hwndDlg,tabs[sel].dlg_proc);
}

BOOL CALLBACK config_dlgproc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam) {
  switch(uMsg)
  {
  case WM_INITDIALOG:
    {
      configiPod=currentiPod;
      TCITEM tie;
      hwnd_config = hwndDlg;
      m_hwndDlg = hwndDlg;
      m_hwndTab = GetDlgItem(hwndDlg,IDC_TAB1);
      tie.mask = TCIF_TEXT;
      for(int i=0; i<sizeof(tabs)/sizeof(pref_tab); i++)
      {
        tie.pszText=tabs[i].title;
        TabCtrl_InsertItem(m_hwndTab,i,&tie);
      }

      TabCtrl_SetCurSel(m_hwndTab,g_prefs_openpage);
      OnSelChanged(hwndDlg);
      char buf[256];
      for(int i=0; i<iPods->GetSize(); i++) {
        view_ipod * ipod = (view_ipod*)iPods->Get(i);
        buf[0]=0;
        sprintf(buf,"%s (%c:)",ipod->it_get_playlist_by_nr(0)->name,ipod->g_ipod_drive[0]);
        buf[255]=0;
        int a=SendDlgItemMessage(hwndDlg,IDC_COMBO1,CB_ADDSTRING,0,(LPARAM)buf);
        if(ipod==configiPod) SendDlgItemMessage(hwndDlg,IDC_COMBO1,CB_SETCURSEL,a,0);
      }
      if(!configiPod) {
        //SetDlgItemText(hwndDlg,IDC_COMBO1,"No iPod connected");
        EnableWindow(GetDlgItem(hwndDlg, IDC_COMBO1),FALSE);
      }
      break;
    }
  case WM_COMMAND:
    if(LOWORD(wParam)==IDC_COMBO1 && HIWORD(wParam)==CBN_SELCHANGE) {
      char buf[256];
      configiPod=NULL;
      for(int i=0; i<iPods->GetSize(); i++) {
        view_ipod * ipod = (view_ipod*)iPods->Get(i);
        GetDlgItemText(hwndDlg,IDC_COMBO1,buf,255);
        buf[255]=0;
        
        if(strrchr(buf,':') > &buf[1]) if(memcmp(&ipod->g_ipod_drive[0],strrchr(buf,':')-1,1)==0) {
          configiPod = ipod;
        }
      }
      OnSelChanged(hwndDlg);
    }
    break;
  case WM_NOTIFY:
    {
      LPNMHDR lpn = (LPNMHDR) lParam; 
      if(lpn) if(lpn->code==TCN_SELCHANGE) OnSelChanged(hwndDlg);
      break;
    }
  case WM_DESTROY:
    if(configiPod != NULL) {
      // save settings onto hard drive
      char conf[MAX_PATH]="";
      GetModuleFileName(plugin.hDllInstance,conf,sizeof(conf)-1);
      strcpy(strrchr(conf,'\\'),"\\ml_ipod.ini");
      copySettings(configiPod->ini_file,conf);
    }
    configiPod=NULL;
    break;
  }
  return 0;
}

void config(HWND parent=NULL) //config now in winamp prefs!
{
  SendMessage(plugin.hwndWinampParent,WM_WA_IPC,(int)&prefsPage,IPC_OPENPREFSTOPAGE);       
}

typedef struct configtypelame {
  int bitrate;
  int vbr_max_bitrate;
  int abr_bitrate;
  int stereo_mode; //0=stereo,1=jstereo,2=mchannel,3=mono
  int quality; //0=normal,1=low,2=high,3=voice,4=r3mix,5=vh

  int vbr; // 0=high-9=low
  int vbr_method; // -1=none, 0=default, 1=old, 2=new, 3=mtrh, 4=abr

} configtypelame;

typedef struct configtypemp4 {
  int bitrate;
} configtypemp4;

int getEncodeBitrate(char * conf_file) {
  char buf[1024];
  int bitrate=0;
  GetPrivateProfileString("transcoder","encodedll","",buf,sizeof(buf),conf_file);
  if(_stricmp(buf,"enc_mp4.dll")==0) {
    configtypemp4 c={0};
    if(GetPrivateProfileStruct("audio_mp4","conf",&c,sizeof(configtypemp4),conf_file))
      bitrate = c.bitrate;
    else
      bitrate = 128000;
  } else if(_stricmp(buf,"enc_lame.dll")==0) {
    configtypelame c={0};
    if(GetPrivateProfileStruct("audio_mp3l","conf",&c,sizeof(configtypelame),conf_file)) {
      if(c.vbr_method == -1) bitrate = c.bitrate;
      else if(c.vbr_method == 4) bitrate = c.abr_bitrate;
      else bitrate = (c.bitrate + c.vbr_max_bitrate) / 2;
      bitrate *= 1000;
    } else
      bitrate = 128000;
  }
  sprintf(buf,"%d",bitrate);
  WritePrivateProfileString("transcoder","bitrate",buf,conf_file);
  OutputDebugString(buf);
  return bitrate;
}