#include <windows.h>
#include <ctype.h>
#include <string.h>

#include "strings.h"
#include "itunesdb.h"

#define CHAR2_TO_WORD(a,b) (((WORD)(a))|((b)<<8))
#define MAKESAFE(x) ((x)?(x):"")

// File_Exists: checks for existence of a file (buf)
WIN32_FIND_DATA * File_Exists(char *buf)
{
  HANDLE h;
  static WIN32_FIND_DATA fd;
  // Avoid a "There is no disk in the drive" error box on empty removable drives
  SetErrorMode(SEM_NOOPENFILEERRORBOX | SEM_FAILCRITICALERRORS);
  h = FindFirstFile(buf,&fd);
  SetErrorMode(0);
  if (h != INVALID_HANDLE_VALUE)
  {
    FindClose(h);
    return &fd;
  }
  return NULL;
}

// Skip_Root: removes drive/host/share name in a path
char * Skip_Root(char *path)
{
  char *p = CharNext(path);
  char *p2 = CharNext(p);

  if (*path && *(WORD*)p == CHAR2_TO_WORD(':', '\\'))
  {
    return CharNext(p2);
  }
  else if (*(WORD*)path == CHAR2_TO_WORD('\\','\\'))
  {
    // skip host and share name
    int x = 2;
    while (x--)
    {
      while (*p2 != '\\')
      {
        if (!*p2)
          return NULL;
        p2 = CharNext(p2);
      }
      p2 = CharNext(p2);
    }
    return p2;
  }
  return(NULL);
}

// RecursiveCreateDirectory: creates all non-existent folders in a path
BOOL RecursiveCreateDirectory(char* buf1)
{
  char *p=buf1;
  char c='c';
  int errors = 0;
  if (*p)
  {
    p = Skip_Root(buf1);
    if (!p)
      return(true);
    while (c)
    {
      WIN32_FIND_DATA *fd;
      while (*p != '\\' && *p) p=CharNext(p);
      c=*p;
      *p=0;
      int pp = strlen(buf1)-1;

        // maybe FUCKO, but should work; stupid fucking win32 api
      while(buf1[pp] == '.' || 
            buf1[pp] == ' ' || 
            (buf1[pp] == '\\' && (buf1[pp-1] == '.' || buf1[pp-1] == ' ' || buf1[pp-1] == '/'))
            || buf1[pp] == '/' && buf1)
      {
        if(buf1[pp] == '\\')
        {
          buf1[pp-1] = '_';
          pp -= 2;
        }else{
          buf1[pp] = '_';
          pp--;
        }
      }
      fd = File_Exists(buf1);
      if (!fd)
      {        
        if (!CreateDirectory(buf1,NULL))
        errors++;
      } else if ((fd->dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) == 0) errors++;
      *p++ = c;
    }
  }
  if(errors == 0)
  {
    return(false);
  }else{
    return(true);
  }
}

// FixReplacementVars: replaces <Artist>, <Title>, <Album>, and #, ##, ##, with appropriate data
char *FixReplacementVars(char *str, int str_size, Song * song, bool noext)
{
#define ADD_STR(x) { lstrcpyn(outp,(x)?(x):"",str_size-1-(outp-str)); while (*outp) outp++; }
#define ADD_STR_U(x) { lstrcpyn(outp,(x)?(x):"",str_size-1-(outp-str)); while (*outp) { *outp=toupper(*outp); outp++; } }
#define ADD_STR_L(x) { lstrcpyn(outp,(x)?(x):"",str_size-1-(outp-str)); while (*outp) { *outp=tolower(*outp); outp++; } }

  char tmpsrc[4096];
  lstrcpyn(tmpsrc,str,sizeof(tmpsrc)); //lstrcpyn is nice enough to make sure it's null terminated.

  char *inp=tmpsrc;
  char *outp=str;

  while (*inp && outp-str < str_size-2)
  {
    if (*inp == '<')
    {
      if (!strncmp(inp,"<TITLE>",7))
      {
        ADD_STR_U(song->title);
        inp+=7;
      }
      else if (!strncmp(inp,"<title>",7))
      {
        ADD_STR_L(song->title);
        inp+=7;
      }
      else if (!_strnicmp(inp,"<Title>",7))
      {
        ADD_STR(song->title);
        inp+=7;
      }
      else if (!strncmp(inp,"<ALBUM>",7))
      {
        ADD_STR_U(song->album);
        inp+=7;
      }
      else if (!strncmp(inp,"<album>",7))
      {
        ADD_STR_L(song->album);
        inp+=7;
      }
      else if (!_strnicmp(inp,"<Album>",7))
      {
        ADD_STR(song->album);
        inp+=7;
      }
      else if (!strncmp(inp,"<GENRE>",7))
      {
        ADD_STR_U(song->genre);
        inp+=7;
      }
      else if (!strncmp(inp,"<genre>",7))
      {
        ADD_STR_L(song->genre);
        inp+=7;
      }
      else if (!_strnicmp(inp,"<Genre>",7))
      {
        ADD_STR(song->genre);
        inp+=7;
      }
      else if (!strncmp(inp,"<ARTIST>",8))
      {
        ADD_STR_U(song->artist);
        inp+=8;
      }
      else if (!strncmp(inp,"<artist>",8))
      {
        ADD_STR_L(song->artist);
        inp+=8;
      }
      else if (!_strnicmp(inp,"<Artist>",8))
      {
        ADD_STR(song->artist);
        inp+=8;
      }
      else if (!_strnicmp(inp,"<year>",6))
      {
        char year[64];
        if(song->year==0) year[0]=0;
        else wsprintf(year, "%d", song->year);

        ADD_STR(year);
        inp+=6;
      }
      else *outp++=*inp++;
    }
    else if (*inp == '#')
    {
      int nd=0;
      char tmp[64];
      while (*inp =='#') nd++,inp++;

      if (!song->track_nr)
      {
        tmp[0]=0;
        while (*inp == ' ') inp++;
        if (*inp == '-' || *inp == '.' || *inp == '_') // separator
        {
          inp++;
          while (*inp == ' ') inp++;
        }
      }
      else
      {
        if (nd > 1)
        {
          char tmp2[32];
          if (nd > 5) nd=5;
          wsprintf(tmp2,"%%%02dd",nd);
          wsprintf(tmp,tmp2,song->track_nr);
        }
        else wsprintf(tmp, "%d", song->track_nr);
      }

      ADD_STR(tmp);
    }
    else *outp++=*inp++;
  }

  if(!noext)
  {
    char *p=song->ipod_path;
    while (*p) p++;
    while (p > song->ipod_path && *p != '.' && *p != '\\' && *p != '/') p--;
    if (*p == '.')
    {
      ADD_STR_L(p);
    }
  }

  *outp=0;


  inp=str;
  outp=str;
  char lastc=0;
  while (*inp) 
  {
    char c=*inp++;
    if (c == '\t') c=' ';

    if (c == ' ' && (lastc == ' ' || lastc == '\\' || lastc == '/')) continue; // ignore space after slash, or another space
    
    if ((c == '\\' || c == '/') && lastc == ' ') outp--;  // if we have a space then slash, back up to write the slash where the space was
    *outp++=c;
    lastc=c;
  }
  *outp=0;
#undef ADD_STR
#undef ADD_STR_L
#undef ADD_STR_U

  return(str);
}