#ifndef _VIEW_IPOD_H
#define _VIEW_IPOD_H

//#define NOHYMN

#include <stdlib.h>


#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <Dbt.h>
#include <time.h>
#include <shlobj.h>

//WF: seem not to need these, just comment out?

#include <malloc.h>
#include <crtdbg.h>
#include <process.h>
#include <conio.h>

#include "mt19937ar.h" // random number generator
#include "resource.h"
#include "../ml.h"
#include "../listview.h"
#include "../childwnd.h"
//#define WA_DLG_IMPLEMENT
#include "../../winamp/wa_dlg.h" // don't implement, we actually get our funcs from the ml
#include "../../winamp/ipc_pe.h"
#include "../../winamp/wa_hotkeys.h"
#include "../itemlist.h"

#include "jnetlib/jnetlib.h"
#include "jnetlib/httpget.h"
#include "itunesdb.h"
#include "eject.h"
#include "strings.h"
#include "reversesync.h"

typedef struct Album {
  int numTracks;
  char * name;
  int artistIndependantTracks;
  int year;
} Album; 

typedef struct Artist {
  int numTracks;
  char * name;
  int numAlbums;
  C_ItemList * Albums; //list of Album structs
} Artist; 

static int sortFunc(const void *elem1, const void *elem2);
static int sortFunc_artist(const void *elem1, const void *elem2);
static int sortFunc_album(const void *elem1, const void *elem2);
void autoDetectIpod(bool msgBoxOnSuccess=false, HWND hwndDlg=NULL);
bool copySettings(char * ssrc, char * sdest);

class view_ipod {
public:
  char g_ipod_drive[8];
  int doneparse;
  bool m_needfullaaupdate;
  bool m_isSync;
  int myParam;
  HTREEITEM m_treeparent;
  int playlistcount;
  int adiv1pos;
  int adiv2pos;
  Playlist *mpl;
  unsigned int m_max_ipod_id;
  C_ItemList m_songs, *m_songs_sorted;
  C_ItemList *m_artists_sorted,*m_albums_sorted,*m_artists;
  C_ItemList m_playlists,*m_toRecordList;
  W_ListView m_list,m_list_artist,m_list_album;
  HWND m_hwnd,m_hwnd_parent;
  HWND g_sendfiles_hwnd;
  HWND g_hwndDlg;
  bool g_artistalbum;
  bool delayDBWrite;
  int m_skinlistview_handle,m_skinlistview_album_handle,m_skinlistview_artist_handle;
  C_ItemList *g_items;
  bool g_abortrs;
  char g_rs_cfilename[1024];
  int g_rs_itemscopied;
  bool TrueSync;
  bool showIconAlways;
  HWND g_rsync_dlg;
  bool isiPodShuffle;
  bool isiPodNano;

  int g_sortcol, g_sortdir;
  int g_sortcol_artist;
  int g_sortdir_artist;
  int g_sortcol_album;
  int g_sortdir_album;
  Album topAlbumEntry;
  Artist topArtistEntry;
  char m_artisttopentry[100];
  char m_albumtopentry[100];
  bool doSyncOnNextConnect;
  char filterstrold[256];
  C_ItemList m_rsynclist;
  int adiv1_clickoffs,adiv1_nodraw;
  WNDPROC adiv1_oldWndProc;
  int adiv2_clickoffs,m_nodrawtopborders;
  WNDPROC adiv2_oldWndProc;
  bool m_noupdatetimer_qs;
  int m_pldrag;
  BOOL m_pldrag_save;
  int m_limit_combo_handle;
  bool m_noupdatetimer_sp;
  int g_hideconsole;
  itemRecordList *autofill;
  itemRecordList *m_to_send;
  Playlist * m_to_send_pl;
  char g_transcode_cmd2[1024];
  int m_deleted, g_transcode3;
  char * m_currentfile;
  int g_hideconsole2;
  int m_sendthreadisfinished;
  int m_blocks_xferred;
  int m_pooper_pos;
  int calls;
  int m_send_status, m_current_send, m_send_writedb;
  void *m_pooper;
  unsigned int m_start_time,m_last_updtime;
  int m_skipped;
  char * ini_file;
  char * g_pcfile;
  bool checkfiledates;
  C_ItemList * m_rscopylist;
  bool m_deleteinprogress;

  view_ipod(char drive);
  ~view_ipod();

  void close_ini();

  bool ejected;

  void sendFilesToIpod(itemRecordList *ico, Playlist * addtopl=NULL, BOOL isTrueSync=FALSE);
  void sortPlaylists();
  int delFilesFromIpod();
  void Sendm3uToIpod(char * playlist, char * playlistname0, int compareto=0);
  void editInfo();
  void SyncPlaylists();
  void sortResults(BOOL sort=TRUE,int source=0);
  void renamePlaylist(Playlist * pl);
  void refreshSmartPlaylist(Playlist * thispl);
  bool parseIpodDb();
  void filesToItemRecordList(itemRecordList *obj, int all, int playlist, bool itemlist=false);
  void SyncRatings(bool towinamp);
  void smartSyncRatings(int force=0,bool writeAsync=true);
  //void startUpdateCheck();
  void refreshAllSmartPlaylists();
  int getNewIpodId();
  Song * getSongById(unsigned int id);
  BOOL it_add_song (Song *song);
  Song * it_get_song_by_nr (unsigned int n);
  unsigned int it_get_nr_of_songs();
  Playlist *it_add_playlist (Playlist *plitem);
  Playlist *it_get_playlist_by_nr(unsigned int id);
  void it_add_songid_to_playlist (Playlist *plitem, unsigned int id);
  void it_add_plitem_to_playlist (Playlist *plitem, Playlistitem *ip);
  Song *it_get_song_in_playlist_by_nr (Playlist *plitem, unsigned int n);
  Playlistitem *it_get_plitem_in_playlist_by_nr (Playlist *plitem, unsigned int n);
  unsigned int it_get_nr_of_songs_in_playlist (Playlist *plitem);
  unsigned int it_get_nr_of_playlists();
  void clearSongList();
  void updateList(int source=0);
  void getPcFilename(char *ipodfn, char *dest);
  void matchSongsInML(itemRecordList * songs);
  void playFiles(int enqueue, int all, int playlist, bool fromRecordList=false);
  void removeFiles();
  void removeFilesFromPlaylist();
  void getSelectedItems(C_ItemList* items, int source);
  void rateItems(int rating);
  BOOL rs_dlgproc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam);
  DWORD ThreadFunc_RSync(LPVOID lpParam);
  void CopyToHardDrive(C_ItemList * items);
  void showRightClickMenu(int source,HWND hwndDlg);
  void adiv1_UpdPos(int xp);
  BOOL adiv1_newWndProc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam);
  void adiv2_UpdPos(int yp);
  BOOL adiv2_newWndProc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam);
  BOOL bothdlgproc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam, int source);
  BOOL main_dlgproc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam);
  BOOL playlist_dlgproc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam);
  bool sortplaylist(C_ItemList * members, int sortby);
  BOOL smartplaylist_dlgproc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam);
  DWORD ThreadFunc_SendFiles( LPVOID lpParam );
  bool foundFileInProbe(char * file);
  int recursiveProbeForLostMusic(char * indir);
  void probeiPodForLostMusic();
  BOOL sendFiles_dialogProc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam);
  void removePlaylist(int number,bool write=true);
  void reverseSync();
  BOOL editInfo_dialogProc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam);
  int onTreeItemDropTarget(int param, int type, void *obj);
  int onTreeItemDrag(int param, POINT p, int *type);
  int onTreeItemDrop(int param, POINT p);
  int MessageProc(int message_type, int param1, int param2, int param3);
  void EjectIpod();
  void RunDefaultQuery(itemRecordList* out);
  void autoFill();
  void cleanupAfterFile(char *fn);
  bool areSameSong(itemRecord * ice, Song * song, bool checkfiledates);
  C_ItemList * PrepareCopyToHardDrive();
  void FindCommonSongs(C_ItemList * ml, C_ItemList * iPod);
  Playlist * getPlaylistFromNodeID(int id);
};

void HwndMap_removeipod(view_ipod* a);
void HwndMap_removehwnd(HWND a);
void HwndMap_add(HWND a, view_ipod* b);
HWND HwndMap_gethwnd(view_ipod* a);
view_ipod* HwndMap_getipod(HWND a, UINT uMsg=0);

int fileSize(char * filename);
void removebadchars(char *s);

#endif